/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibFoundation.Mathematics.Matrix3f;
import WildMagic.LibFoundation.Mathematics.Matrix4f;
import WildMagic.LibFoundation.Mathematics.Plane3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import java.io.Serializable;

public class Transformation
implements Serializable {
    private static final long serialVersionUID = 8355580891567240020L;
    public static int DISK_USED = 9 * Stream.SIZEOF_FLOAT + 6 * Stream.SIZEOF_FLOAT + 3 * Stream.SIZEOF_BOOLEAN;
    private Matrix3f m_kMatrix = new Matrix3f(Matrix3f.IDENTITY);
    private Matrix3f m_kMatrixInverse = new Matrix3f(Matrix3f.IDENTITY);
    private Vector3f m_kTranslate = new Vector3f(Vector3f.ZERO);
    private Vector3f m_kScale = new Vector3f(Vector3f.ONE);
    private boolean m_bIsIdentity = true;
    private boolean m_bIsRSMatrix = true;
    private boolean m_bIsUniformScale = true;
    private boolean m_bUpdateInverse = false;

    public Transformation() {
    }

    public Transformation(Transformation rkA) {
        if (rkA == null) {
            this.MakeIdentity();
            return;
        }
        this.m_kMatrix = new Matrix3f(rkA.m_kMatrix);
        this.m_kMatrixInverse = new Matrix3f(rkA.m_kMatrixInverse);
        this.m_kTranslate = new Vector3f(rkA.m_kTranslate);
        this.m_kScale = new Vector3f(rkA.m_kScale);
        this.m_bIsIdentity = rkA.m_bIsIdentity;
        this.m_bIsRSMatrix = rkA.m_bIsRSMatrix;
        this.m_bIsUniformScale = rkA.m_bIsUniformScale;
    }

    void Inverse() {
        if (this.m_bIsIdentity) {
            return;
        }
        if (this.m_bIsRSMatrix) {
            if (this.m_bIsUniformScale) {
                this.m_kMatrix.Transpose();
                this.m_kMatrix.Scale(1.0f / this.GetUniformScale());
            } else {
                this.m_kMatrix.TimesDiagonal(this.m_kScale);
                this.m_kMatrix.Inverse();
            }
        } else {
            this.m_kMatrix.Inverse();
        }
        this.m_kMatrix.Mult(this.m_kTranslate, this.m_kTranslate);
        this.m_kTranslate.Scale(-1.0f);
        this.MakeUnitScale();
        this.m_bIsIdentity = false;
        this.m_bIsRSMatrix = false;
        this.m_bIsUniformScale = false;
    }

    public Plane3f ApplyForward(Plane3f rkInput) {
        if (this.m_bIsIdentity) {
            return new Plane3f(rkInput);
        }
        Plane3f kOutput = new Plane3f();
        if (this.m_bIsRSMatrix) {
            if (this.m_bIsUniformScale) {
                kOutput.Normal.Copy(rkInput.Normal);
                this.m_kMatrix.Mult(kOutput.Normal, kOutput.Normal);
                kOutput.Constant = this.GetUniformScale() * rkInput.Constant + kOutput.Normal.Dot(this.m_kTranslate);
                return kOutput;
            }
            kOutput.Normal.Copy(rkInput.Normal);
            float fSXY = this.m_kScale.X * this.m_kScale.Y;
            float fSXZ = this.m_kScale.X * this.m_kScale.Z;
            float fSYZ = this.m_kScale.Y * this.m_kScale.Z;
            float fInvDet = 1.0f / (fSXY * this.m_kScale.Z);
            kOutput.Normal.X = kOutput.Normal.X * fInvDet * fSYZ;
            kOutput.Normal.Y = kOutput.Normal.Y * fInvDet * fSXZ;
            kOutput.Normal.Z = kOutput.Normal.Z * fInvDet * fSXY;
            this.m_kMatrix.Mult(kOutput.Normal, kOutput.Normal);
        } else {
            if (this.m_bUpdateInverse) {
                this.m_bUpdateInverse = false;
                this.m_kMatrixInverse.Inverse(this.m_kMatrix);
            }
            this.m_kMatrixInverse.MultLeft(rkInput.Normal, kOutput.Normal);
        }
        float fInvLength = 1.0f / kOutput.Normal.Length();
        kOutput.Normal.Scale(fInvLength);
        kOutput.Constant = fInvLength * rkInput.Constant + kOutput.Normal.Dot(this.m_kTranslate);
        return kOutput;
    }

    public Vector3f ApplyForward(Vector3f rkInput) {
        if (this.m_bIsIdentity) {
            Vector3f kOutput = new Vector3f(rkInput);
            return kOutput;
        }
        if (this.m_bIsRSMatrix) {
            Vector3f kOutput = new Vector3f(this.m_kScale.X * rkInput.X, this.m_kScale.Y * rkInput.Y, this.m_kScale.Z * rkInput.Z);
            this.m_kMatrix.Mult(kOutput, kOutput);
            kOutput.Add(this.m_kTranslate);
            return kOutput;
        }
        Vector3f kOutput = new Vector3f();
        this.m_kMatrix.Mult(rkInput, kOutput);
        kOutput.Add(this.m_kTranslate);
        return kOutput;
    }

    public void ApplyForward(Vector3f rkInput, Vector3f kOutput) {
        if (this.m_bIsIdentity) {
            kOutput.Copy(rkInput);
            return;
        }
        if (this.m_bIsRSMatrix) {
            kOutput.Set(this.m_kScale.X * rkInput.X, this.m_kScale.Y * rkInput.Y, this.m_kScale.Z * rkInput.Z);
            this.m_kMatrix.Mult(kOutput, kOutput);
            kOutput.Add(this.m_kTranslate);
            return;
        }
        kOutput.Copy(rkInput);
        this.m_kMatrix.Mult(kOutput, kOutput);
        kOutput.Add(this.m_kTranslate);
    }

    public Vector3f ApplyInverse(Vector3f rkInput) {
        Vector3f kOutput = new Vector3f();
        if (this.m_bIsIdentity) {
            kOutput.Copy(rkInput);
            return kOutput;
        }
        kOutput.Sub(rkInput, this.m_kTranslate);
        if (this.m_bIsRSMatrix) {
            this.m_kMatrix.MultLeft(kOutput, kOutput);
            if (this.m_bIsUniformScale) {
                kOutput.Div(this.GetUniformScale());
            } else {
                float fSXY = this.m_kScale.X * this.m_kScale.Y;
                float fSXZ = this.m_kScale.X * this.m_kScale.Z;
                float fSYZ = this.m_kScale.Y * this.m_kScale.Z;
                float fInvDet = 1.0f / (fSXY * this.m_kScale.Z);
                kOutput.X = kOutput.X * fInvDet * fSYZ;
                kOutput.Y = kOutput.Y * fInvDet * fSXZ;
                kOutput.Z = kOutput.Z * fInvDet * fSXY;
            }
        } else {
            if (this.m_bUpdateInverse) {
                this.m_bUpdateInverse = false;
                this.m_kMatrixInverse.Inverse(this.m_kMatrix);
            }
            this.m_kMatrixInverse.Mult(kOutput, kOutput);
        }
        return kOutput;
    }

    public void ApplyInverse(Vector3f rkInput, Vector3f kOutput) {
        if (this.m_bIsIdentity) {
            kOutput.Copy(rkInput);
            return;
        }
        kOutput.Copy(rkInput);
        kOutput.Sub(this.m_kTranslate);
        if (this.m_bIsRSMatrix) {
            this.m_kMatrix.MultLeft(kOutput, kOutput);
            if (this.m_bIsUniformScale) {
                kOutput.Div(this.GetUniformScale());
            } else {
                float fSXY = this.m_kScale.X * this.m_kScale.Y;
                float fSXZ = this.m_kScale.X * this.m_kScale.Z;
                float fSYZ = this.m_kScale.Y * this.m_kScale.Z;
                float fInvDet = 1.0f / (fSXY * this.m_kScale.Z);
                kOutput.X = kOutput.X * fInvDet * fSYZ;
                kOutput.Y = kOutput.Y * fInvDet * fSXZ;
                kOutput.Z = kOutput.Z * fInvDet * fSXY;
            }
        } else {
            if (this.m_bUpdateInverse) {
                this.m_bUpdateInverse = false;
                this.m_kMatrixInverse.Inverse(this.m_kMatrix);
            }
            this.m_kMatrixInverse.Mult(kOutput, kOutput);
        }
    }

    public void Copy(Transformation rkA) {
        if (rkA == null) {
            this.MakeIdentity();
            return;
        }
        this.m_kMatrix.Copy(rkA.m_kMatrix);
        this.m_kMatrixInverse.Copy(rkA.m_kMatrixInverse);
        this.m_kTranslate.Copy(rkA.m_kTranslate);
        this.m_kScale.Copy(rkA.m_kScale);
        this.m_bIsIdentity = rkA.m_bIsIdentity;
        this.m_bIsRSMatrix = rkA.m_bIsRSMatrix;
        this.m_bIsUniformScale = rkA.m_bIsUniformScale;
    }

    public void dispose() {
        this.m_kMatrix = null;
        this.m_kTranslate = null;
        this.m_kScale = null;
    }

    public void GetHomogeneous(Matrix4f rkHMatrix) {
        if (this.m_bIsRSMatrix) {
            rkHMatrix.M00 = this.m_kScale.X * this.m_kMatrix.M00;
            rkHMatrix.M01 = this.m_kScale.X * this.m_kMatrix.M10;
            rkHMatrix.M02 = this.m_kScale.X * this.m_kMatrix.M20;
            rkHMatrix.M03 = 0.0f;
            rkHMatrix.M10 = this.m_kScale.Y * this.m_kMatrix.M01;
            rkHMatrix.M11 = this.m_kScale.Y * this.m_kMatrix.M11;
            rkHMatrix.M12 = this.m_kScale.Y * this.m_kMatrix.M21;
            rkHMatrix.M13 = 0.0f;
            rkHMatrix.M20 = this.m_kScale.Z * this.m_kMatrix.M02;
            rkHMatrix.M21 = this.m_kScale.Z * this.m_kMatrix.M12;
            rkHMatrix.M22 = this.m_kScale.Z * this.m_kMatrix.M22;
            rkHMatrix.M23 = 0.0f;
        } else {
            rkHMatrix.M00 = this.m_kMatrix.M00;
            rkHMatrix.M01 = this.m_kMatrix.M10;
            rkHMatrix.M02 = this.m_kMatrix.M20;
            rkHMatrix.M03 = 0.0f;
            rkHMatrix.M10 = this.m_kMatrix.M01;
            rkHMatrix.M11 = this.m_kMatrix.M11;
            rkHMatrix.M12 = this.m_kMatrix.M21;
            rkHMatrix.M13 = 0.0f;
            rkHMatrix.M20 = this.m_kMatrix.M02;
            rkHMatrix.M21 = this.m_kMatrix.M12;
            rkHMatrix.M22 = this.m_kMatrix.M22;
            rkHMatrix.M23 = 0.0f;
        }
        rkHMatrix.M30 = this.m_kTranslate.X;
        rkHMatrix.M31 = this.m_kTranslate.Y;
        rkHMatrix.M32 = this.m_kTranslate.Z;
        rkHMatrix.M33 = 1.0f;
    }

    public final Matrix3f GetMatrix() {
        return this.m_kMatrix;
    }

    public float GetNorm() {
        if (this.m_bIsRSMatrix) {
            float fMax = Math.abs(this.m_kScale.X);
            if (Math.abs(this.m_kScale.Y) > fMax) {
                fMax = Math.abs(this.m_kScale.Y);
            }
            if (Math.abs(this.m_kScale.Z) > fMax) {
                fMax = Math.abs(this.m_kScale.Z);
            }
            return fMax;
        }
        float fMaxRowSum = Math.abs(this.m_kMatrix.M00) + Math.abs(this.m_kMatrix.M01) + Math.abs(this.m_kMatrix.M02);
        float fRowSum = Math.abs(this.m_kMatrix.M10) + Math.abs(this.m_kMatrix.M11) + Math.abs(this.m_kMatrix.M12);
        if (fRowSum > fMaxRowSum) {
            fMaxRowSum = fRowSum;
        }
        if ((fRowSum = Math.abs(this.m_kMatrix.M20) + Math.abs(this.m_kMatrix.M21) + Math.abs(this.m_kMatrix.M22)) > fMaxRowSum) {
            fMaxRowSum = fRowSum;
        }
        return fMaxRowSum;
    }

    public Matrix3f GetRotate() {
        assert (this.m_bIsRSMatrix);
        return this.m_kMatrix;
    }

    public Vector3f GetScale() {
        assert (this.m_bIsRSMatrix);
        return this.m_kScale;
    }

    public final Vector3f GetTranslate() {
        return this.m_kTranslate;
    }

    public float GetUniformScale() {
        assert (this.m_bIsRSMatrix && this.m_bIsUniformScale);
        return this.m_kScale.X;
    }

    public Vector3f InvertVector(Vector3f rkInput) {
        if (this.m_bIsIdentity) {
            return new Vector3f(rkInput);
        }
        Vector3f kOutput = new Vector3f();
        if (this.m_bIsRSMatrix) {
            this.m_kMatrix.MultLeft(rkInput, kOutput);
            if (this.m_bIsUniformScale) {
                kOutput.Div(this.GetUniformScale());
            } else {
                float fSXY = this.m_kScale.X * this.m_kScale.Y;
                float fSXZ = this.m_kScale.X * this.m_kScale.Z;
                float fSYZ = this.m_kScale.Y * this.m_kScale.Z;
                float fInvDet = 1.0f / (fSXY * this.m_kScale.Z);
                kOutput.X = kOutput.X * fInvDet * fSYZ;
                kOutput.Y = kOutput.Y * fInvDet * fSXZ;
                kOutput.Z = kOutput.Z * fInvDet * fSXY;
            }
        } else {
            if (this.m_bUpdateInverse) {
                this.m_bUpdateInverse = false;
                this.m_kMatrixInverse.Inverse(this.m_kMatrix);
            }
            this.m_kMatrixInverse.Mult(rkInput, kOutput);
        }
        return kOutput;
    }

    public final boolean IsIdentity() {
        return this.m_bIsIdentity;
    }

    public final boolean IsRSMatrix() {
        return this.m_bIsRSMatrix;
    }

    public final boolean IsUniformScale() {
        return this.m_bIsRSMatrix && this.m_bIsUniformScale;
    }

    public void MakeIdentity() {
        this.m_kMatrix.MakeIdentity();
        this.m_kTranslate.Set(0.0f, 0.0f, 0.0f);
        this.m_kScale.Set(1.0f, 1.0f, 1.0f);
        this.m_bIsIdentity = true;
        this.m_bIsRSMatrix = true;
        this.m_bIsUniformScale = true;
    }

    public void MakeUnitScale() {
        assert (this.m_bIsRSMatrix);
        this.m_kScale.Set(1.0f, 1.0f, 1.0f);
        this.m_bIsUniformScale = true;
    }

    public void Product(Transformation rkA, Transformation rkB) {
        if (rkA.IsIdentity()) {
            this.Copy(rkB);
            return;
        }
        if (rkB.IsIdentity()) {
            this.Copy(rkA);
            return;
        }
        if (rkA.m_bIsRSMatrix && rkB.m_bIsRSMatrix && rkA.m_bIsUniformScale) {
            Matrix3f kTempM = new Matrix3f(rkA.m_kMatrix);
            kTempM.Mult(rkB.m_kMatrix);
            this.SetRotate(kTempM);
            Vector3f kTemp = new Vector3f(rkB.m_kTranslate);
            rkA.m_kMatrix.Mult(kTemp, kTemp);
            kTemp.Add(rkA.m_kTranslate);
            kTemp.Scale(rkA.GetUniformScale());
            this.SetTranslate(kTemp);
            if (rkB.IsUniformScale()) {
                this.SetUniformScale(rkB.GetUniformScale() * rkA.GetUniformScale());
            } else {
                this.m_kScale.Copy(rkB.GetScale());
                this.m_kScale.Scale(rkA.GetUniformScale());
                this.SetScale(this.m_kScale);
            }
            return;
        }
        this.m_kMatrix.Copy(rkA.m_kMatrix);
        if (rkA.m_bIsRSMatrix) {
            this.m_kMatrix.TimesDiagonal(rkA.m_kScale);
        }
        Matrix3f kMB = new Matrix3f(rkB.m_kMatrix);
        if (rkB.m_bIsRSMatrix) {
            kMB.TimesDiagonal(rkB.m_kScale);
        }
        this.m_kTranslate.Copy(rkB.m_kTranslate);
        this.m_kMatrix.Mult(this.m_kTranslate, this.m_kTranslate);
        this.m_kTranslate.Add(rkA.m_kTranslate);
        this.m_kMatrix.Mult(kMB);
        this.m_bIsIdentity = false;
        this.m_bIsRSMatrix = false;
        this.m_bIsUniformScale = false;
        kMB = null;
    }

    public void SetIsIdentity(boolean bValue) {
        this.m_bIsIdentity = bValue;
    }

    public void SetIsRSMatrix(boolean bValue) {
        this.m_bIsRSMatrix = bValue;
    }

    public void SetIsUniformScale(boolean bValue) {
        this.m_bIsUniformScale = bValue;
    }

    public void SetMatrix(Matrix3f rkMatrix) {
        this.m_kMatrix = rkMatrix;
        this.m_bUpdateInverse = true;
        this.m_bIsIdentity = false;
        this.m_bIsRSMatrix = false;
        this.m_bIsUniformScale = false;
    }

    public void SetMatrixCopy(Matrix3f rkMatrix) {
        this.m_kMatrix.Copy(rkMatrix);
        this.m_bUpdateInverse = true;
        this.m_bIsIdentity = false;
        this.m_bIsRSMatrix = false;
        this.m_bIsUniformScale = false;
    }

    public void SetRotate(Matrix3f rkRotate) {
        this.m_kMatrix = rkRotate;
        this.m_bUpdateInverse = true;
        this.m_bIsIdentity = false;
        this.m_bIsRSMatrix = true;
    }

    public void SetRotateCopy(Matrix3f rkRotate) {
        this.m_kMatrix.Copy(rkRotate);
        this.m_bUpdateInverse = true;
        this.m_bIsIdentity = false;
        this.m_bIsRSMatrix = true;
    }

    public void SetScale(float fSx, float fSy, float fSz) {
        this.m_kScale.X = fSx;
        this.m_kScale.Y = fSy;
        this.m_kScale.Z = fSz;
        this.m_bIsIdentity = false;
        this.m_bIsUniformScale = false;
    }

    public void SetScale(Vector3f rkScale) {
        assert (this.m_bIsRSMatrix && rkScale.X != 0.0f && rkScale.Y != 0.0f && rkScale.Z != 0.0f);
        this.m_kScale = rkScale;
        this.m_bIsIdentity = false;
        this.m_bIsUniformScale = false;
    }

    public void SetTranslate(float fTx, float fTy, float fTz) {
        this.m_kTranslate.X = fTx;
        this.m_kTranslate.Y = fTy;
        this.m_kTranslate.Z = fTz;
        this.m_bIsIdentity = false;
    }

    public void SetTranslate(Vector3f rkTranslate) {
        this.m_kTranslate = rkTranslate;
        this.m_bIsIdentity = false;
    }

    public void SetUniformScale(float fScale) {
        assert (this.m_bIsRSMatrix && fScale != 0.0f);
        this.m_kScale.Set(fScale, fScale, fScale);
        this.m_bIsIdentity = false;
        this.m_bIsUniformScale = true;
    }
}

