/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.SceneGraph.BoundingVolume;
import WildMagic.LibGraphics.SceneGraph.Geometry;
import WildMagic.LibGraphics.SceneGraph.IndexBuffer;
import WildMagic.LibGraphics.SceneGraph.Triangles;
import WildMagic.LibGraphics.SceneGraph.VertexBuffer;
import java.io.Serializable;

public class TriMesh
extends Triangles
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = -6900908466084674890L;

    public TriMesh() {
        this.Type = Geometry.GeometryType.GT_TRIMESH;
    }

    public TriMesh(TriMesh kMesh) {
        super(kMesh);
        this.Type = Geometry.GeometryType.GT_TRIMESH;
        this.UpdateModelNormals();
    }

    public TriMesh(VertexBuffer pkVBuffer, IndexBuffer pkIBuffer) {
        super(pkVBuffer, pkIBuffer);
        this.Type = Geometry.GeometryType.GT_TRIMESH;
        if (pkIBuffer != null) {
            this.UpdateModelNormals();
        }
    }

    public TriMesh(VertexBuffer pkVBuffer, IndexBuffer pkIBuffer, boolean bUpdate) {
        super(pkVBuffer, pkIBuffer);
        this.Type = Geometry.GeometryType.GT_TRIMESH;
        if (bUpdate && pkIBuffer != null) {
            this.UpdateModelNormals();
        }
    }

    public TriMesh(VertexBuffer pkVBuffer, IndexBuffer pkIBuffer, BoundingVolume kBounds) {
        super(pkVBuffer, pkIBuffer, kBounds);
        this.Type = Geometry.GeometryType.GT_TRIMESH;
        this.UpdateModelNormals();
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion);
    }

    @Override
    public boolean GetTriangle(int i, int[] riV) {
        if (0 <= i && i < this.GetTriangleQuantity()) {
            int[] piIndex = this.IBuffer.GetData();
            riV[0] = piIndex[3 * i + 0];
            riV[1] = piIndex[3 * i + 1];
            riV[2] = piIndex[3 * i + 2];
            return true;
        }
        return false;
    }

    @Override
    public final int GetTriangleQuantity() {
        return this.IBuffer.GetIndexQuantity() / 3;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("TriMesh", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        return pkTree;
    }
}

