/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibFoundation.Mathematics.Triangle3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.SceneGraph.Attributes;
import WildMagic.LibGraphics.SceneGraph.BoundingVolume;
import WildMagic.LibGraphics.SceneGraph.Geometry;
import WildMagic.LibGraphics.SceneGraph.IndexBuffer;
import WildMagic.LibGraphics.SceneGraph.VertexBuffer;
import java.io.Serializable;

public abstract class Triangles
extends Geometry
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = -462884353223180197L;
    private boolean m_bInside;

    public Triangles() {
    }

    protected Triangles(Triangles kTris) {
        super(kTris);
    }

    protected Triangles(VertexBuffer pkVBuffer, IndexBuffer pkIBuffer) {
        super(pkVBuffer, pkIBuffer);
    }

    protected Triangles(VertexBuffer pkVBuffer, IndexBuffer pkIBuffer, BoundingVolume kBounds) {
        super(pkVBuffer, pkIBuffer, kBounds);
    }

    public void GenerateNormals() {
        if (!this.VBuffer.GetAttributes().HasNormal()) {
            Attributes kAttr = this.VBuffer.GetAttributes();
            kAttr.SetNChannels(3);
            VertexBuffer pkVBufferPlusNormals = new VertexBuffer(kAttr, this.VBuffer.GetVertexQuantity());
            this.VBuffer.BuildCompatibleArray(kAttr, pkVBufferPlusNormals);
            this.VBuffer = pkVBufferPlusNormals;
        }
        this.UpdateModelNormals();
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion);
    }

    public boolean GetModelTriangle(int i, Triangle3f rkMTri) {
        int[] aiTris = new int[3];
        if (this.GetTriangle(i, aiTris)) {
            int iV0 = aiTris[0];
            int iV1 = aiTris[1];
            int iV2 = aiTris[2];
            this.VBuffer.GetPosition3(iV0, rkMTri.V[0]);
            this.VBuffer.GetPosition3(iV1, rkMTri.V[1]);
            this.VBuffer.GetPosition3(iV2, rkMTri.V[2]);
            aiTris = null;
            return true;
        }
        aiTris = null;
        return false;
    }

    public abstract boolean GetTriangle(int var1, int[] var2);

    public abstract int GetTriangleQuantity();

    public boolean GetWorldTriangle(int i, Triangle3f rkWTri) {
        int[] aiTris = new int[3];
        if (this.GetTriangle(i, aiTris)) {
            int iV0 = aiTris[0];
            int iV1 = aiTris[1];
            int iV2 = aiTris[2];
            Vector3f kPos = new Vector3f();
            this.VBuffer.GetPosition3(iV0, kPos);
            this.World.ApplyForward(kPos, rkWTri.V[0]);
            this.VBuffer.GetPosition3(iV1, kPos);
            this.World.ApplyForward(kPos, rkWTri.V[1]);
            this.VBuffer.GetPosition3(iV2, kPos);
            this.World.ApplyForward(kPos, rkWTri.V[2]);
            kPos = null;
            return true;
        }
        return false;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("Triangles", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        return pkTree;
    }

    public void SetInside(boolean bInside) {
        this.m_bInside = bInside;
    }

    @Override
    protected void UpdateModelNormals() {
        int i;
        if (!this.VBuffer.GetAttributes().HasNormal()) {
            return;
        }
        int iVQuantity = this.VBuffer.GetVertexQuantity();
        for (i = 0; i < iVQuantity; ++i) {
            this.VBuffer.SetNormal3(i, Vector3f.ZERO);
        }
        int iTQuantity = this.GetTriangleQuantity();
        Vector3f rkV0 = new Vector3f();
        Vector3f rkV1 = new Vector3f();
        Vector3f rkV2 = new Vector3f();
        Vector3f rkN0 = new Vector3f();
        Vector3f rkN1 = new Vector3f();
        Vector3f rkN2 = new Vector3f();
        Vector3f kNormal = new Vector3f();
        for (i = 0; i < iTQuantity; ++i) {
            int[] aiTris = new int[3];
            if (!this.GetTriangle(i, aiTris)) continue;
            int iV0 = aiTris[0];
            int iV1 = aiTris[1];
            int iV2 = aiTris[2];
            rkV0.Set(this.VBuffer.GetPosition3fX(iV0), this.VBuffer.GetPosition3fY(iV0), this.VBuffer.GetPosition3fZ(iV0));
            rkV1.Set(this.VBuffer.GetPosition3fX(iV1), this.VBuffer.GetPosition3fY(iV1), this.VBuffer.GetPosition3fZ(iV1));
            rkV2.Set(this.VBuffer.GetPosition3fX(iV2), this.VBuffer.GetPosition3fY(iV2), this.VBuffer.GetPosition3fZ(iV2));
            rkV1.Sub(rkV0);
            rkV2.Sub(rkV0);
            rkV1.Cross(rkV2);
            kNormal.Copy(rkV1);
            rkN0.Set(this.VBuffer.GetNormal3fX(iV0), this.VBuffer.GetNormal3fY(iV0), this.VBuffer.GetNormal3fZ(iV0));
            rkN0.Add(kNormal);
            this.VBuffer.SetNormal3(iV0, rkN0);
            rkN1.Set(this.VBuffer.GetNormal3fX(iV1), this.VBuffer.GetNormal3fY(iV1), this.VBuffer.GetNormal3fZ(iV1));
            rkN1.Add(kNormal);
            this.VBuffer.SetNormal3(iV1, rkN1);
            rkN2.Set(this.VBuffer.GetNormal3fX(iV2), this.VBuffer.GetNormal3fY(iV2), this.VBuffer.GetNormal3fZ(iV2));
            rkN2.Add(kNormal);
            this.VBuffer.SetNormal3(iV2, rkN2);
        }
        rkV0 = null;
        rkV1 = null;
        rkV2 = null;
        rkN0 = null;
        rkN1 = null;
        rkN2 = null;
        Vector3f kNormalized = new Vector3f();
        for (i = 0; i < iVQuantity; ++i) {
            kNormalized.Set(this.VBuffer.GetNormal3fX(i), this.VBuffer.GetNormal3fY(i), this.VBuffer.GetNormal3fZ(i));
            if (this.m_bInside) {
                kNormalized.Neg();
            }
            kNormalized.Normalize();
            this.VBuffer.SetNormal3(i, kNormalized);
        }
        kNormalized = null;
    }
}

