/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibFoundation.Mathematics.ColorRGB;
import WildMagic.LibFoundation.Mathematics.ColorRGBA;
import WildMagic.LibFoundation.Mathematics.Vector2f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.Bindable;
import WildMagic.LibGraphics.SceneGraph.Attributes;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class VertexBuffer
extends Bindable
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 8156911541111303324L;
    private Attributes m_kAttributes;
    private int m_iVertexSize;
    private int m_iVertexQuantity;
    private int m_iChannelQuantity;
    private float[] m_afChannel;
    public Vector<Vector2f> SubVBuffer = null;
    protected boolean m_bLoadSub = false;

    public VertexBuffer() {
        this.m_kAttributes = new Attributes();
        this.m_iVertexQuantity = 0;
        this.m_iVertexSize = 0;
        this.m_iChannelQuantity = 0;
        this.m_afChannel = null;
    }

    public VertexBuffer(Attributes rkAttributes, int iVertexQuantity) {
        this.m_kAttributes = rkAttributes;
        assert (iVertexQuantity > 0);
        this.m_iVertexQuantity = iVertexQuantity;
        this.m_iVertexSize = this.m_kAttributes.GetChannelQuantity();
        this.m_iChannelQuantity = this.m_iVertexQuantity * this.m_iVertexSize;
        this.m_afChannel = new float[this.m_iChannelQuantity];
    }

    public VertexBuffer(Vector3f[] akPositions) {
        this.m_kAttributes = new Attributes();
        this.m_kAttributes.SetPChannels(3);
        this.m_kAttributes.SetNChannels(3);
        this.m_kAttributes.SetTChannels(0, 3);
        this.m_kAttributes.SetCChannels(0, 4);
        this.m_iVertexQuantity = akPositions.length;
        this.m_iVertexSize = this.m_kAttributes.GetChannelQuantity();
        this.m_iChannelQuantity = this.m_iVertexQuantity * this.m_iVertexSize;
        this.m_afChannel = new float[this.m_iChannelQuantity];
        for (int i = 0; i < akPositions.length; ++i) {
            this.SetPosition3(i, akPositions[i]);
            this.SetColor4(0, i, ColorRGBA.WHITE);
            this.SetTCoord3(0, i, akPositions[i]);
        }
    }

    public VertexBuffer(Vector<Vector3f> akPositions) {
        this.m_kAttributes = new Attributes();
        this.m_kAttributes.SetPChannels(3);
        this.m_kAttributes.SetNChannels(3);
        this.m_kAttributes.SetTChannels(0, 3);
        this.m_kAttributes.SetCChannels(0, 4);
        this.m_iVertexQuantity = akPositions.size();
        this.m_iVertexSize = this.m_kAttributes.GetChannelQuantity();
        this.m_iChannelQuantity = this.m_iVertexQuantity * this.m_iVertexSize;
        this.m_afChannel = new float[this.m_iChannelQuantity];
        for (int i = 0; i < akPositions.size(); ++i) {
            this.SetPosition3(i, akPositions.elementAt(i));
            this.SetColor4(0, i, ColorRGBA.WHITE);
            this.SetTCoord3(0, i, akPositions.elementAt(i));
        }
    }

    public VertexBuffer(VertexBuffer pkVBuffer) {
        assert (pkVBuffer != null);
        this.m_kAttributes = new Attributes(pkVBuffer.m_kAttributes);
        this.m_iVertexQuantity = pkVBuffer.m_iVertexQuantity;
        this.m_iVertexSize = this.m_kAttributes.GetChannelQuantity();
        this.m_iChannelQuantity = this.m_iVertexQuantity * this.m_iVertexSize;
        this.m_afChannel = new float[this.m_iChannelQuantity];
        for (int i = 0; i < this.m_iChannelQuantity; ++i) {
            this.m_afChannel[i] = pkVBuffer.m_afChannel[i];
        }
    }

    public float[] BuildCompatibleArray(Attributes rkIAttr) {
        int iVBChannels;
        int iUnit;
        int iIChannels;
        if (this.m_kAttributes.Matches(rkIAttr, true, true, true, true)) {
            return this.m_afChannel;
        }
        int iSize = 0;
        if (rkIAttr.HasPosition()) {
            iIChannels = rkIAttr.GetPChannels();
            iSize += iIChannels;
        }
        if (rkIAttr.HasNormal()) {
            iIChannels = rkIAttr.GetNChannels();
            iSize += iIChannels;
        }
        for (iUnit = 0; iUnit < rkIAttr.GetMaxColors(); ++iUnit) {
            if (!rkIAttr.HasColor(iUnit)) continue;
            iIChannels = rkIAttr.GetCChannels(iUnit);
            iSize += iIChannels;
        }
        for (iUnit = 0; iUnit < rkIAttr.GetMaxTCoords(); ++iUnit) {
            if (!rkIAttr.HasTCoord(iUnit)) continue;
            iIChannels = rkIAttr.GetTChannels(iUnit);
            iVBChannels = this.m_kAttributes.GetTChannels(iUnit);
            iSize += iIChannels;
        }
        int iReturn = 0;
        float[] afReturn = new float[iSize * this.m_iVertexQuantity];
        for (int i = 0; i < this.m_iVertexQuantity; ++i) {
            int j;
            int iIndex;
            if (rkIAttr.HasPosition()) {
                iIChannels = rkIAttr.GetPChannels();
                iVBChannels = this.m_kAttributes.GetPChannels();
                iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetPOffset();
                if (iVBChannels < iIChannels) {
                    for (j = 0; j < iVBChannels; ++j) {
                        afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                    }
                    for (j = iVBChannels; j < iIChannels; ++j) {
                        afReturn[iReturn++] = 1.0f;
                    }
                } else {
                    for (j = 0; j < iIChannels; ++j) {
                        afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                    }
                }
            }
            if (rkIAttr.HasNormal()) {
                iIChannels = rkIAttr.GetNChannels();
                iVBChannels = this.m_kAttributes.GetNChannels();
                iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetNOffset();
                if (iVBChannels < iIChannels) {
                    for (j = 0; j < iVBChannels; ++j) {
                        afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                    }
                    for (j = iVBChannels; j < iIChannels; ++j) {
                        afReturn[iReturn++] = 0.0f;
                    }
                } else {
                    for (j = 0; j < iIChannels; ++j) {
                        afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                    }
                }
            }
            for (iUnit = 0; iUnit < rkIAttr.GetMaxColors(); ++iUnit) {
                if (!rkIAttr.HasColor(iUnit)) continue;
                iIChannels = rkIAttr.GetCChannels(iUnit);
                iVBChannels = this.m_kAttributes.GetCChannels(iUnit);
                iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetCOffset(iUnit);
                if (iVBChannels < iIChannels) {
                    for (j = 0; j < iVBChannels; ++j) {
                        afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                    }
                    for (j = iVBChannels; j < iIChannels; ++j) {
                        afReturn[iReturn++] = 1.0f;
                    }
                    continue;
                }
                for (j = 0; j < iIChannels; ++j) {
                    afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                }
            }
            for (iUnit = 0; iUnit < rkIAttr.GetMaxTCoords(); ++iUnit) {
                if (!rkIAttr.HasTCoord(iUnit)) continue;
                iIChannels = rkIAttr.GetTChannels(iUnit);
                iVBChannels = this.m_kAttributes.GetTChannels(iUnit);
                iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetTOffset(iUnit);
                if (iVBChannels < iIChannels) {
                    for (j = 0; j < iVBChannels; ++j) {
                        afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                    }
                    for (j = iVBChannels; j < iIChannels; ++j) {
                        afReturn[iReturn++] = 0.0f;
                    }
                    continue;
                }
                for (j = 0; j < iIChannels; ++j) {
                    afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                }
            }
        }
        return afReturn;
    }

    public void BuildCompatibleArray(Attributes rkIAttr, VertexBuffer kVB) {
        int ikVBIndex = 0;
        for (int i = 0; i < this.m_iVertexQuantity; ++i) {
            int iUnit;
            int j;
            int iIndex;
            int iVBChannels;
            int iIChannels;
            if (rkIAttr.HasPosition()) {
                iIChannels = rkIAttr.GetPChannels();
                iVBChannels = this.m_kAttributes.GetPChannels();
                iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetPOffset();
                if (iVBChannels < iIChannels) {
                    for (j = 0; j < iVBChannels; ++j) {
                        kVB.m_afChannel[ikVBIndex++] = this.m_afChannel[iIndex + j];
                    }
                    for (j = iVBChannels; j < iIChannels; ++j) {
                        kVB.m_afChannel[ikVBIndex++] = 1.0f;
                    }
                } else {
                    for (j = 0; j < iIChannels; ++j) {
                        kVB.m_afChannel[ikVBIndex++] = this.m_afChannel[iIndex + j];
                    }
                }
            }
            if (rkIAttr.HasNormal()) {
                iIChannels = rkIAttr.GetNChannels();
                iVBChannels = this.m_kAttributes.GetNChannels();
                iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetNOffset();
                if (iVBChannels < iIChannels) {
                    for (j = 0; j < iVBChannels; ++j) {
                        kVB.m_afChannel[ikVBIndex++] = this.m_afChannel[iIndex + j];
                    }
                    for (j = iVBChannels; j < iIChannels; ++j) {
                        kVB.m_afChannel[ikVBIndex++] = 0.0f;
                    }
                } else {
                    for (j = 0; j < iIChannels; ++j) {
                        kVB.m_afChannel[ikVBIndex++] = this.m_afChannel[iIndex + j];
                    }
                }
            }
            for (iUnit = 0; iUnit < rkIAttr.GetMaxColors(); ++iUnit) {
                if (!rkIAttr.HasColor(iUnit)) continue;
                iIChannels = rkIAttr.GetCChannels(iUnit);
                iVBChannels = this.m_kAttributes.GetCChannels(iUnit);
                iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetCOffset(iUnit);
                if (iVBChannels < iIChannels) {
                    for (j = 0; j < iVBChannels; ++j) {
                        kVB.m_afChannel[ikVBIndex++] = this.m_afChannel[iIndex + j];
                    }
                    for (j = iVBChannels; j < iIChannels; ++j) {
                        kVB.m_afChannel[ikVBIndex++] = 1.0f;
                    }
                    continue;
                }
                for (j = 0; j < iIChannels; ++j) {
                    kVB.m_afChannel[ikVBIndex++] = this.m_afChannel[iIndex + j];
                }
            }
            for (iUnit = 0; iUnit < rkIAttr.GetMaxTCoords(); ++iUnit) {
                if (!rkIAttr.HasTCoord(iUnit)) continue;
                iIChannels = rkIAttr.GetTChannels(iUnit);
                iVBChannels = this.m_kAttributes.GetTChannels(iUnit);
                iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetTOffset(iUnit);
                if (iVBChannels < iIChannels) {
                    for (j = 0; j < iVBChannels; ++j) {
                        kVB.m_afChannel[ikVBIndex++] = this.m_afChannel[iIndex + j];
                    }
                    for (j = iVBChannels; j < iIChannels; ++j) {
                        kVB.m_afChannel[ikVBIndex++] = 0.0f;
                    }
                    continue;
                }
                for (j = 0; j < iIChannels; ++j) {
                    kVB.m_afChannel[ikVBIndex++] = this.m_afChannel[iIndex + j];
                }
            }
        }
    }

    public float[] BuildCompatibleSubArray(Attributes rkIAttr, int iMin, int iMax) {
        int iVBChannels;
        int iUnit;
        int iIChannels;
        int iSize = 0;
        if (rkIAttr.HasPosition()) {
            iIChannels = rkIAttr.GetPChannels();
            iSize += iIChannels;
        }
        if (rkIAttr.HasNormal()) {
            iIChannels = rkIAttr.GetNChannels();
            iSize += iIChannels;
        }
        for (iUnit = 0; iUnit < rkIAttr.GetMaxColors(); ++iUnit) {
            if (!rkIAttr.HasColor(iUnit)) continue;
            iIChannels = rkIAttr.GetCChannels(iUnit);
            iSize += iIChannels;
        }
        for (iUnit = 0; iUnit < rkIAttr.GetMaxTCoords(); ++iUnit) {
            if (!rkIAttr.HasTCoord(iUnit)) continue;
            iIChannels = rkIAttr.GetTChannels(iUnit);
            iVBChannels = this.m_kAttributes.GetTChannels(iUnit);
            iSize += iIChannels;
        }
        int iReturn = 0;
        float[] afReturn = new float[iSize * (1 + iMax - iMin)];
        for (int i = iMin; i <= iMax; ++i) {
            int j;
            int iIndex;
            if (rkIAttr.HasPosition()) {
                iIChannels = rkIAttr.GetPChannels();
                iVBChannels = this.m_kAttributes.GetPChannels();
                iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetPOffset();
                if (iVBChannels < iIChannels) {
                    for (j = 0; j < iVBChannels; ++j) {
                        afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                    }
                    for (j = iVBChannels; j < iIChannels; ++j) {
                        afReturn[iReturn++] = 1.0f;
                    }
                } else {
                    for (j = 0; j < iIChannels; ++j) {
                        afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                    }
                }
            }
            if (rkIAttr.HasNormal()) {
                iIChannels = rkIAttr.GetNChannels();
                iVBChannels = this.m_kAttributes.GetNChannels();
                iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetNOffset();
                if (iVBChannels < iIChannels) {
                    for (j = 0; j < iVBChannels; ++j) {
                        afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                    }
                    for (j = iVBChannels; j < iIChannels; ++j) {
                        afReturn[iReturn++] = 0.0f;
                    }
                } else {
                    for (j = 0; j < iIChannels; ++j) {
                        afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                    }
                }
            }
            for (iUnit = 0; iUnit < rkIAttr.GetMaxColors(); ++iUnit) {
                if (!rkIAttr.HasColor(iUnit)) continue;
                iIChannels = rkIAttr.GetCChannels(iUnit);
                iVBChannels = this.m_kAttributes.GetCChannels(iUnit);
                iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetCOffset(iUnit);
                if (iVBChannels < iIChannels) {
                    for (j = 0; j < iVBChannels; ++j) {
                        afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                    }
                    for (j = iVBChannels; j < iIChannels; ++j) {
                        afReturn[iReturn++] = 1.0f;
                    }
                    continue;
                }
                for (j = 0; j < iIChannels; ++j) {
                    afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                }
            }
            for (iUnit = 0; iUnit < rkIAttr.GetMaxTCoords(); ++iUnit) {
                if (!rkIAttr.HasTCoord(iUnit)) continue;
                iIChannels = rkIAttr.GetTChannels(iUnit);
                iVBChannels = this.m_kAttributes.GetTChannels(iUnit);
                iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetTOffset(iUnit);
                if (iVBChannels < iIChannels) {
                    for (j = 0; j < iVBChannels; ++j) {
                        afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                    }
                    for (j = iVBChannels; j < iIChannels; ++j) {
                        afReturn[iReturn++] = 0.0f;
                    }
                    continue;
                }
                for (j = 0; j < iIChannels; ++j) {
                    afReturn[iReturn++] = this.m_afChannel[iIndex + j];
                }
            }
        }
        return afReturn;
    }

    public void CopyData(float[] afChannel) {
        for (int i = 0; i < this.m_iChannelQuantity; ++i) {
            this.m_afChannel[i] = afChannel[i];
        }
    }

    @Override
    public void dispose() {
        if (this.m_kAttributes != null) {
            this.m_kAttributes.dispose();
            this.m_kAttributes = null;
        }
        this.m_afChannel = null;
        super.dispose();
    }

    public final Attributes GetAttributes() {
        return this.m_kAttributes;
    }

    public final int GetChannelQuantity() {
        return this.m_iChannelQuantity;
    }

    public float GetColor1(int iUnit, int i) {
        assert (this.m_kAttributes.GetCChannels(iUnit) == 1);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetCOffset(iUnit);
        return this.m_afChannel[iIndex];
    }

    public void GetColor3(int iUnit, int i, ColorRGB kResult) {
        assert (this.m_kAttributes.GetCChannels(iUnit) == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetCOffset(iUnit);
        kResult.R = this.m_afChannel[iIndex + 0];
        kResult.G = this.m_afChannel[iIndex + 1];
        kResult.B = this.m_afChannel[iIndex + 2];
    }

    public ColorRGBA GetColor4(int iUnit, int i) {
        assert (this.m_kAttributes.GetCChannels(iUnit) == 4);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetCOffset(iUnit);
        return new ColorRGBA(this.m_afChannel[iIndex + 0], this.m_afChannel[iIndex + 1], this.m_afChannel[iIndex + 2], this.m_afChannel[iIndex + 3]);
    }

    public void GetColor4(int iUnit, int i, ColorRGBA kResult) {
        assert (this.m_kAttributes.GetCChannels(iUnit) == 4);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetCOffset(iUnit);
        kResult.Set(this.m_afChannel[iIndex + 0], this.m_afChannel[iIndex + 1], this.m_afChannel[iIndex + 2], this.m_afChannel[iIndex + 3]);
    }

    public float[] GetData() {
        return this.m_afChannel;
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT + Stream.SIZEOF_INT + Stream.SIZEOF_INT + this.m_iChannelQuantity * Stream.SIZEOF_FLOAT + 4 * Stream.SIZEOF_INT + Stream.SIZEOF_INT * this.m_kAttributes.GetMaxColors() + Stream.SIZEOF_INT * this.m_kAttributes.GetMaxTCoords();
    }

    public int GetIndex(int i) {
        return this.m_iVertexSize * i;
    }

    public Vector3f GetNormal3(int i) {
        assert (this.m_kAttributes.GetNChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetNOffset();
        return new Vector3f(this.m_afChannel[iIndex + 0], this.m_afChannel[iIndex + 1], this.m_afChannel[iIndex + 2]);
    }

    public void GetNormal3(int i, Vector3f kResult) {
        assert (this.m_kAttributes.GetNChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetNOffset();
        kResult.Set(this.m_afChannel[iIndex + 0], this.m_afChannel[iIndex + 1], this.m_afChannel[iIndex + 2]);
    }

    public float GetNormal3fX(int i) {
        assert (this.m_kAttributes.GetNChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetNOffset();
        return this.m_afChannel[iIndex + 0];
    }

    public float GetNormal3fY(int i) {
        assert (this.m_kAttributes.GetNChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetNOffset();
        return this.m_afChannel[iIndex + 1];
    }

    public float GetNormal3fZ(int i) {
        assert (this.m_kAttributes.GetNChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetNOffset();
        return this.m_afChannel[iIndex + 2];
    }

    public Vector3f GetPosition3(int i) {
        assert (this.m_kAttributes.GetPChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetPOffset();
        return new Vector3f(this.m_afChannel[iIndex + 0], this.m_afChannel[iIndex + 1], this.m_afChannel[iIndex + 2]);
    }

    public void GetPosition3(int i, Vector3f kResult) {
        assert (this.m_kAttributes.GetPChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetPOffset();
        kResult.Set(this.m_afChannel[iIndex + 0], this.m_afChannel[iIndex + 1], this.m_afChannel[iIndex + 2]);
    }

    public float GetPosition3fX(int i) {
        assert (this.m_kAttributes.GetPChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetPOffset();
        return this.m_afChannel[iIndex + 0];
    }

    public float GetPosition3fY(int i) {
        assert (this.m_kAttributes.GetPChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetPOffset();
        return this.m_afChannel[iIndex + 1];
    }

    public float GetPosition3fZ(int i) {
        assert (this.m_kAttributes.GetPChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetPOffset();
        return this.m_afChannel[iIndex + 2];
    }

    public Vector3f[] GetPositionArray() {
        Vector3f[] akVerts = new Vector3f[this.m_iVertexQuantity];
        for (int i = 0; i < this.m_iVertexQuantity; ++i) {
            akVerts[i] = new Vector3f();
            this.GetPosition3(i, akVerts[i]);
        }
        return akVerts;
    }

    public float GetTCoord1(int iUnit, int i) {
        assert (this.m_kAttributes.GetTChannels(iUnit) == 1);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetTOffset(iUnit);
        return this.m_afChannel[iIndex];
    }

    public void GetTCoord2(int iUnit, int i, Vector2f kResult) {
        assert (this.m_kAttributes.GetTChannels(iUnit) == 2);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetTOffset(iUnit);
        kResult.Set(this.m_afChannel[iIndex + 0], this.m_afChannel[iIndex + 1]);
    }

    public float GetTCoord2fX(int iUnit, int i) {
        assert (this.m_kAttributes.GetTChannels(iUnit) == 2);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetTOffset(iUnit);
        return this.m_afChannel[iIndex + 0];
    }

    public float GetTCoord2fY(int iUnit, int i) {
        assert (this.m_kAttributes.GetTChannels(iUnit) == 2);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetTOffset(iUnit);
        return this.m_afChannel[iIndex + 1];
    }

    public Vector3f GetTCoord3(int iUnit, int i) {
        assert (this.m_kAttributes.GetTChannels(iUnit) == 2);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetTOffset(iUnit);
        return new Vector3f(this.m_afChannel[iIndex + 0], this.m_afChannel[iIndex + 1], this.m_afChannel[iIndex + 2]);
    }

    public void GetTCoord3(int iUnit, int i, Vector3f kResult) {
        assert (this.m_kAttributes.GetTChannels(iUnit) == 2);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetTOffset(iUnit);
        kResult.Set(this.m_afChannel[iIndex + 0], this.m_afChannel[iIndex + 1], this.m_afChannel[iIndex + 2]);
    }

    public float[] GetVertex(int i) {
        assert (this.m_kAttributes.GetPChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetPOffset();
        float[] afVertexData = new float[this.m_iVertexSize];
        for (int j = 0; j < this.m_iVertexSize; ++j) {
            afVertexData[j] = this.m_afChannel[iIndex + j];
        }
        return afVertexData;
    }

    public final int GetVertexQuantity() {
        return this.m_iVertexQuantity;
    }

    public final int GetVertexSize() {
        return this.m_iVertexSize;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.m_iVertexSize = rkStream.ReadInt();
        this.m_iVertexQuantity = rkStream.ReadInt();
        this.m_iChannelQuantity = rkStream.ReadInt();
        this.m_afChannel = new float[this.m_iChannelQuantity];
        rkStream.Read(this.m_iChannelQuantity, this.m_afChannel);
        int iPChannels = rkStream.ReadInt();
        this.m_kAttributes.SetPChannels(iPChannels);
        int iNChannels = rkStream.ReadInt();
        this.m_kAttributes.SetNChannels(iNChannels);
        int iMaxColors = rkStream.ReadInt();
        for (int i = 0; i < iMaxColors; ++i) {
            int iCChannels = rkStream.ReadInt();
            this.m_kAttributes.SetCChannels(i, iCChannels);
        }
        int iMaxTCoords = rkStream.ReadInt();
        for (int i = 0; i < iMaxTCoords; ++i) {
            int iTChannels = rkStream.ReadInt();
            this.m_kAttributes.SetTChannels(i, iTChannels);
        }
    }

    public boolean LoadSub() {
        return this.m_bLoadSub;
    }

    public void LoadSub(boolean bOn) {
        this.m_bLoadSub = bOn;
        if (!bOn) {
            this.SubVBuffer.clear();
        }
    }

    public void LoadSub(int iMin, int iMax) {
        this.m_bLoadSub = true;
        if (this.SubVBuffer == null) {
            this.SubVBuffer = new Vector();
        }
        this.SubVBuffer.add(new Vector2f(iMin, iMax));
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        int i;
        super.Save(rkStream);
        rkStream.Write(this.m_iVertexSize);
        rkStream.Write(this.m_iVertexQuantity);
        rkStream.Write(this.m_iChannelQuantity);
        rkStream.Write(this.m_iChannelQuantity, this.m_afChannel);
        rkStream.Write(this.m_kAttributes.GetPChannels());
        rkStream.Write(this.m_kAttributes.GetNChannels());
        rkStream.Write(this.m_kAttributes.GetMaxColors());
        for (i = 0; i < this.m_kAttributes.GetMaxColors(); ++i) {
            rkStream.Write(this.m_kAttributes.GetCChannels(i));
        }
        rkStream.Write(this.m_kAttributes.GetMaxTCoords());
        for (i = 0; i < this.m_kAttributes.GetMaxTCoords(); ++i) {
            rkStream.Write(this.m_kAttributes.GetTChannels(i));
        }
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        String kPrefix;
        int i;
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("VertexBuffer", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("vertex quantity = ", this.m_iVertexQuantity));
        pkTree.Append(StringTree.Format("vertex size = ", this.m_iVertexSize));
        pkTree.Append(StringTree.Format("p channels =", this.m_kAttributes.GetPChannels()));
        pkTree.Append(StringTree.Format("n channels =", this.m_kAttributes.GetNChannels()));
        pkTree.Append(StringTree.Format("c units =", this.m_kAttributes.GetMaxColors()));
        for (i = 0; i < this.m_kAttributes.GetMaxColors(); ++i) {
            kPrefix = new String("c[" + i + "] channels =");
            pkTree.Append(StringTree.Format(kPrefix, this.m_kAttributes.GetCChannels(i)));
        }
        pkTree.Append(StringTree.Format("t units =", this.m_kAttributes.GetMaxTCoords()));
        for (i = 0; i < this.m_kAttributes.GetMaxTCoords(); ++i) {
            kPrefix = new String("t[" + i + "] channels =");
            pkTree.Append(StringTree.Format(kPrefix, this.m_kAttributes.GetTChannels(i)));
        }
        pkTree.Append(StringTree.Format(acTitle, this.m_iChannelQuantity, this.m_afChannel));
        return pkTree;
    }

    public void SetColor1(int iUnit, int i, float fR) {
        assert (this.m_kAttributes.GetCChannels(iUnit) == 1);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetCOffset(iUnit);
        this.m_afChannel[iIndex] = fR;
    }

    public void SetColor3(int iUnit, int i, ColorRGB kC) {
        assert (this.m_kAttributes.GetCChannels(iUnit) == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetCOffset(iUnit);
        this.m_afChannel[iIndex + 0] = kC.R;
        this.m_afChannel[iIndex + 1] = kC.G;
        this.m_afChannel[iIndex + 2] = kC.B;
    }

    public void SetColor3(int iUnit, int i, float fR, float fG, float fB) {
        assert (this.m_kAttributes.GetCChannels(iUnit) == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetCOffset(iUnit);
        this.m_afChannel[iIndex + 0] = fR;
        this.m_afChannel[iIndex + 1] = fG;
        this.m_afChannel[iIndex + 2] = fB;
    }

    public void SetColor4(int iUnit, int i, ColorRGBA kC) {
        assert (this.m_kAttributes.GetCChannels(iUnit) == 4);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetCOffset(iUnit);
        this.m_afChannel[iIndex + 0] = kC.R;
        this.m_afChannel[iIndex + 1] = kC.G;
        this.m_afChannel[iIndex + 2] = kC.B;
        this.m_afChannel[iIndex + 3] = kC.A;
    }

    public void SetColor4(int iUnit, int i, float fR, float fG, float fB, float fA) {
        if (this.m_kAttributes.GetCChannels(iUnit) == 4) {
            int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetCOffset(iUnit);
            this.m_afChannel[iIndex + 0] = fR;
            this.m_afChannel[iIndex + 1] = fG;
            this.m_afChannel[iIndex + 2] = fB;
            this.m_afChannel[iIndex + 3] = fA;
        } else {
            System.err.println("NO COLOR4");
        }
    }

    public void SetNormal3(int i, float fX, float fY, float fZ) {
        assert (this.m_kAttributes.GetNChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetNOffset();
        this.m_afChannel[iIndex + 0] = fX;
        this.m_afChannel[iIndex + 1] = fY;
        this.m_afChannel[iIndex + 2] = fZ;
    }

    public void SetNormal3(int i, Vector3f kN) {
        assert (this.m_kAttributes.GetNChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetNOffset();
        this.m_afChannel[iIndex + 0] = kN.X;
        this.m_afChannel[iIndex + 1] = kN.Y;
        this.m_afChannel[iIndex + 2] = kN.Z;
    }

    public void SetPosition3(int i, float fX, float fY, float fZ) {
        assert (this.m_kAttributes.GetPChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetPOffset();
        this.m_afChannel[iIndex + 0] = fX;
        this.m_afChannel[iIndex + 1] = fY;
        this.m_afChannel[iIndex + 2] = fZ;
    }

    public void SetPosition3(int i, Vector3f kP) {
        assert (this.m_kAttributes.GetPChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetPOffset();
        this.m_afChannel[iIndex + 0] = kP.X;
        this.m_afChannel[iIndex + 1] = kP.Y;
        this.m_afChannel[iIndex + 2] = kP.Z;
    }

    public void SetTCoord1(int iUnit, int i, float fValue) {
        assert (this.m_kAttributes.GetTChannels(iUnit) == 1);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetTOffset(iUnit);
        this.m_afChannel[iIndex] = fValue;
    }

    public void SetTCoord2(int iUnit, int i, float fX, float fY) {
        assert (this.m_kAttributes.GetTChannels(iUnit) == 2);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetTOffset(iUnit);
        this.m_afChannel[iIndex + 0] = fX;
        this.m_afChannel[iIndex + 1] = fY;
    }

    public void SetTCoord2(int iUnit, int i, Vector2f kTC) {
        assert (this.m_kAttributes.GetTChannels(iUnit) == 2);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetTOffset(iUnit);
        this.m_afChannel[iIndex + 0] = kTC.X;
        this.m_afChannel[iIndex + 1] = kTC.Y;
    }

    public void SetTCoord3(int iUnit, int i, float fX, float fY, float fZ) {
        assert (this.m_kAttributes.GetTChannels(iUnit) == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetTOffset(iUnit);
        this.m_afChannel[iIndex + 0] = fX;
        this.m_afChannel[iIndex + 1] = fY;
        this.m_afChannel[iIndex + 2] = fZ;
    }

    public void SetTCoord3(int iUnit, int i, Vector3f kTC) {
        assert (this.m_kAttributes.GetTChannels(iUnit) == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetTOffset(iUnit);
        this.m_afChannel[iIndex + 0] = kTC.X;
        this.m_afChannel[iIndex + 1] = kTC.Y;
        this.m_afChannel[iIndex + 2] = kTC.Z;
    }

    public void SetVertex(int i, float[] afVertexData) {
        assert (this.m_kAttributes.GetPChannels() == 3);
        int iIndex = this.m_iVertexSize * i + this.m_kAttributes.GetPOffset();
        for (int j = 0; j < this.m_iVertexSize; ++j) {
            this.m_afChannel[iIndex + j] = afVertexData[j];
        }
    }

    public final void SetVertexQuantity(int iVQuantity) {
        this.m_iVertexQuantity = iVQuantity;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.m_kAttributes);
        out.writeInt(this.m_iVertexSize);
        out.writeInt(this.m_iVertexQuantity);
        out.writeInt(this.m_iChannelQuantity);
        out.writeObject(this.m_afChannel);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_kAttributes = (Attributes)in.readObject();
        this.m_iVertexSize = in.readInt();
        this.m_iVertexQuantity = in.readInt();
        this.m_iChannelQuantity = in.readInt();
        this.m_afChannel = (float[])in.readObject();
    }
}

