/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibGraphics.Effects.Effect;
import WildMagic.LibGraphics.SceneGraph.Spatial;
import WildMagic.LibGraphics.SceneGraph.VisibleObject;
import java.io.Serializable;

public class VisibleSet
implements Serializable {
    private static final long serialVersionUID = 9003814505081600191L;
    private static final int VS_DEFAULT_MAX_QUANTITY = 32;
    private static final int VS_DEFAULT_GROWBY = 32;
    private int m_iMaxQuantity;
    private int m_iGrowBy;
    private int m_iQuantity;
    private VisibleObject[] m_akVisible = null;

    public VisibleSet(int iMaxQuantity, int iGrowBy) {
        this.Resize(iMaxQuantity, iGrowBy);
    }

    public void Clear() {
        this.m_iQuantity = 0;
    }

    public void dispose() {
        for (int i = 0; i < this.m_iQuantity; ++i) {
            if (this.m_akVisible[i] == null) continue;
            this.m_akVisible[i].dispose();
            this.m_akVisible[i] = null;
        }
        this.m_akVisible = null;
    }

    public final int GetQuantity() {
        return this.m_iQuantity;
    }

    public final VisibleObject[] GetVisible() {
        return this.m_akVisible;
    }

    public VisibleObject GetVisible(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_akVisible[i];
    }

    public void Insert(Spatial pkObject, Effect pkGlobalEffect) {
        if (++this.m_iQuantity > this.m_iMaxQuantity) {
            int iNewMaxQuantity = this.m_iMaxQuantity + this.m_iGrowBy;
            VisibleObject[] akNewVisible = new VisibleObject[iNewMaxQuantity];
            for (int i = 0; i < iNewMaxQuantity; ++i) {
                akNewVisible[i] = i < this.m_iQuantity - 1 ? this.m_akVisible[i] : new VisibleObject();
            }
            this.m_akVisible = akNewVisible;
            this.m_iMaxQuantity = iNewMaxQuantity;
        }
        int iIndex = this.m_iQuantity - 1;
        this.m_akVisible[iIndex].Object = pkObject;
        this.m_akVisible[iIndex].GlobalEffect = pkGlobalEffect;
    }

    public void Resize(int iMaxQuantity, int iGrowBy) {
        this.m_iMaxQuantity = iMaxQuantity > 0 ? iMaxQuantity : 32;
        this.m_iGrowBy = iGrowBy > 0 ? iGrowBy : 32;
        this.m_akVisible = null;
        this.m_iQuantity = 0;
        this.m_akVisible = new VisibleObject[this.m_iMaxQuantity];
        for (int i = 0; i < this.m_iMaxQuantity; ++i) {
            this.m_akVisible[i] = new VisibleObject();
        }
    }
}

