/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Shaders;

import WildMagic.LibGraphics.Rendering.GraphicsImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ImageCatalog {
    private String m_kName;
    private String m_kDefaultDir;
    private HashMap<String, GraphicsImage> m_kEntry = new HashMap();
    private GraphicsImage m_spkDefaultImage;
    private static final String ms_kNullString = new String("");
    public static final String ms_kDefaultString = new String("Default");
    private static ImageCatalog ms_pkActive = null;

    public ImageCatalog(String rkName, String rkDefaultDir) {
        this.m_kName = new String(rkName);
        this.m_kDefaultDir = new String(rkDefaultDir);
        byte[] aucData = new byte[]{-1, 0, -1};
        this.m_spkDefaultImage = new GraphicsImage(GraphicsImage.FormatMode.IT_RGB888, 1, aucData, ms_kDefaultString);
    }

    public static final ImageCatalog GetActive() {
        return ms_pkActive;
    }

    public static void SetActive(ImageCatalog pkActive) {
        ms_pkActive = pkActive;
    }

    public void dispose() {
        this.m_kName = null;
        this.m_kDefaultDir = null;
        this.m_kEntry.clear();
        this.m_kEntry = null;
        if (this.m_spkDefaultImage != null) {
            this.m_spkDefaultImage.dispose();
            this.m_spkDefaultImage = null;
        }
    }

    public GraphicsImage Find(String rkImageName) {
        if (rkImageName == ms_kNullString || rkImageName == ms_kDefaultString) {
            return this.m_spkDefaultImage;
        }
        GraphicsImage pkImage = this.m_kEntry.get(rkImageName);
        if (pkImage != null) {
            return pkImage;
        }
        pkImage = GraphicsImage.Load(rkImageName, this.m_kDefaultDir);
        if (pkImage != null) {
            return pkImage;
        }
        return this.m_spkDefaultImage;
    }

    public final String GetDefaultDir() {
        return this.m_kDefaultDir;
    }

    public final String GetName() {
        return this.m_kName;
    }

    public boolean Insert(GraphicsImage pkImage) {
        if (pkImage == null) {
            assert (false);
            return false;
        }
        String kImageName = new String(pkImage.GetName());
        if (kImageName == ms_kNullString || kImageName == ms_kDefaultString || pkImage == this.m_spkDefaultImage) {
            return false;
        }
        if (this.m_kEntry.containsKey(kImageName)) {
            return true;
        }
        this.m_kEntry.put(kImageName, pkImage);
        return true;
    }

    public void PrintEntries() {
        System.err.println("");
        System.err.println("Image Catalog");
        Iterator<Map.Entry<String, GraphicsImage>> kEIter = this.m_kEntry.entrySet().iterator();
        Map.Entry<String, GraphicsImage> kEntry = null;
        while (kEIter.hasNext()) {
            kEntry = kEIter.next();
            System.err.println(kEntry.getKey());
        }
    }

    public boolean Remove(GraphicsImage pkImage) {
        if (this.m_kEntry == null) {
            return false;
        }
        if (pkImage == null) {
            assert (false);
            return false;
        }
        if (pkImage.GetName() == null) {
            return false;
        }
        String kImageName = new String(pkImage.GetName());
        if (kImageName == ms_kNullString || kImageName == ms_kDefaultString || pkImage == this.m_spkDefaultImage) {
            return false;
        }
        GraphicsImage kObj = this.m_kEntry.remove(kImageName);
        return kObj != null;
    }
}

