/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Shaders;

import java.io.Serializable;
import java.util.HashMap;

public class RendererConstant
implements Serializable {
    private static final long serialVersionUID = 6329418908253732039L;
    private static HashMap<String, Type> ms_pkTypeMap = new HashMap();
    private static Type m_eTypeStatic = Type.MAX_TYPES;
    private Type m_eType;
    private int m_iBaseRegister;
    private int m_iRegisterQuantity;
    private int m_iNumFloats;
    private float[] m_afData = new float[16];

    public RendererConstant(Type eType, int iBaseRegister, int iRegisterQuantity, int iNumFloats) {
        assert (iBaseRegister >= 0);
        assert (1 <= iRegisterQuantity && iRegisterQuantity <= 4);
        this.m_eType = eType;
        this.m_iBaseRegister = iBaseRegister;
        this.m_iRegisterQuantity = iRegisterQuantity;
        this.m_iNumFloats = iNumFloats;
    }

    public static final String GetName(Type eType) {
        return eType.Name();
    }

    public static Type GetType(String rkName) {
        Type kType = ms_pkTypeMap.get(rkName);
        if (kType != null) {
            return kType;
        }
        return Type.MAX_TYPES;
    }

    public void dispose() {
        this.m_afData = null;
    }

    public final int GetBaseRegister() {
        return this.m_iBaseRegister;
    }

    public final float[] GetData() {
        return this.m_afData;
    }

    public final int GetNumFloats() {
        return this.m_iNumFloats;
    }

    public final int GetRegisterQuantity() {
        return this.m_iRegisterQuantity;
    }

    public final Type GetType() {
        return this.m_eType;
    }

    public static enum Type {
        W_MATRIX("WMatrix"),
        V_MATRIX("VMatrix"),
        P_MATRIX("PMatrix"),
        WV_MATRIX("WVMatrix"),
        VP_MATRIX("VPMatrix"),
        WVP_MATRIX("WVPMatrix"),
        W_MATRIX_TRANSPOSE("WMatrixT"),
        V_MATRIX_TRANSPOSE("VMatrixT"),
        P_MATRIX_TRANSPOSE("PMatrixT"),
        WV_MATRIX_TRANSPOSE("WVMatrixT"),
        VP_MATRIX_TRANSPOSE("VPMatrixT"),
        WVP_MATRIX_TRANSPOSE("WVPMatrixT"),
        W_MATRIX_INVERSE("WMatrixI"),
        V_MATRIX_INVERSE("VMatrixI"),
        P_MATRIX_INVERSE("PMatrixI"),
        WV_MATRIX_INVERSE("WVMatrixI"),
        VP_MATRIX_INVERSE("VPMatrixI"),
        WVP_MATRIX_INVERSE("WVPMatrixI"),
        W_MATRIX_INVERSE_TRANSPOSE("WMatrixIT"),
        V_MATRIX_INVERSE_TRANSPOSE("VMatrixIT"),
        P_MATRIX_INVERSE_TRANSPOSE("PMatrixIT"),
        WV_MATRIX_INVERSE_TRANSPOSE("WVMatrixIT"),
        VP_MATRIX_INVERSE_TRANSPOSE("VPMatrixIT"),
        WVP_MATRIX_INVERSE_TRANSPOSE("WVPMatrixIT"),
        MATERIAL_EMISSIVE("MaterialEmissive"),
        MATERIAL_AMBIENT("MaterialAmbient"),
        MATERIAL_DIFFUSE("MaterialDiffuse"),
        MATERIAL_SPECULAR("MaterialSpecular"),
        CAMERA_MODEL_POSITION("CameraModelPosition"),
        CAMERA_MODEL_DIRECTION("CameraModelDirection"),
        CAMERA_MODEL_UP("CameraModelUp"),
        CAMERA_MODEL_RIGHT("CameraModelRight"),
        CAMERA_WORLD_POSITION("CameraWorldPosition"),
        CAMERA_WORLD_DIRECTION("CameraWorldDirection"),
        CAMERA_WORLD_UP("CameraWorldUp"),
        CAMERA_WORLD_RIGHT("CameraWorldRight"),
        PROJECTOR_MODEL_POSITION("ProjectorModelPosition"),
        PROJECTOR_MODEL_DIRECTION("ProjectorModelDirection"),
        PROJECTOR_MODEL_UP("ProjectorModelUp"),
        PROJECTOR_MODEL_RIGHT("ProjectorModelRight"),
        PROJECTOR_WORLD_POSITION("ProjectorWorldPosition"),
        PROJECTOR_WORLD_DIRECTION("ProjectorWorldDirection"),
        PROJECTOR_WORLD_UP("ProjectorWorldUp"),
        PROJECTOR_WORLD_RIGHT("ProjectorWorldRight"),
        PROJECTOR_MATRIX("ProjectorMatrix"),
        LIGHT0_MODEL_POSITION("Light0ModelPosition"),
        LIGHT0_MODEL_DIRECTION("Light0ModelDirection"),
        LIGHT0_WORLD_POSITION("Light0WorldPosition"),
        LIGHT0_WORLD_DIRECTION("Light0WorldDirection"),
        LIGHT0_AMBIENT("Light0Ambient"),
        LIGHT0_DIFFUSE("Light0Diffuse"),
        LIGHT0_SPECULAR("Light0Specular"),
        LIGHT0_SPOTCUTOFF("Light0SpotCutoff"),
        LIGHT0_ATTENUATION("Light0Attenuation"),
        LIGHT1_MODEL_POSITION("Light1ModelPosition"),
        LIGHT1_MODEL_DIRECTION("Light1ModelDirection"),
        LIGHT1_WORLD_POSITION("Light1WorldPosition"),
        LIGHT1_WORLD_DIRECTION("Light1WorldDirection"),
        LIGHT1_AMBIENT("Light1Ambient"),
        LIGHT1_DIFFUSE("Light1Diffuse"),
        LIGHT1_SPECULAR("Light1Specular"),
        LIGHT1_SPOTCUTOFF("Light1SpotCutoff"),
        LIGHT1_ATTENUATION("Light1Attenuation"),
        LIGHT2_MODEL_POSITION("Light2ModelPosition"),
        LIGHT2_MODEL_DIRECTION("Light2ModelDirection"),
        LIGHT2_WORLD_POSITION("Light2WorldPosition"),
        LIGHT2_WORLD_DIRECTION("Light2WorldDirection"),
        LIGHT2_AMBIENT("Light2Ambient"),
        LIGHT2_DIFFUSE("Light2Diffuse"),
        LIGHT2_SPECULAR("Light2Specular"),
        LIGHT2_SPOTCUTOFF("Light2SpotCutoff"),
        LIGHT2_ATTENUATION("Light2Attenuation"),
        LIGHT3_MODEL_POSITION("Light3ModelPosition"),
        LIGHT3_MODEL_DIRECTION("Light3ModelDirection"),
        LIGHT3_WORLD_POSITION("Light3WorldPosition"),
        LIGHT3_WORLD_DIRECTION("Light3WorldDirection"),
        LIGHT3_AMBIENT("Light3Ambient"),
        LIGHT3_DIFFUSE("Light3Diffuse"),
        LIGHT3_SPECULAR("Light3Specular"),
        LIGHT3_SPOTCUTOFF("Light3SpotCutoff"),
        LIGHT3_ATTENUATION("Light3Attenuation"),
        LIGHT4_MODEL_POSITION("Light4ModelPosition"),
        LIGHT4_MODEL_DIRECTION("Light4ModelDirection"),
        LIGHT4_WORLD_POSITION("Light4WorldPosition"),
        LIGHT4_WORLD_DIRECTION("Light4WorldDirection"),
        LIGHT4_AMBIENT("Light4Ambient"),
        LIGHT4_DIFFUSE("Light4Diffuse"),
        LIGHT4_SPECULAR("Light4Specular"),
        LIGHT4_SPOTCUTOFF("Light4SpotCutoff"),
        LIGHT4_ATTENUATION("Light4Attenuation"),
        LIGHT5_MODEL_POSITION("Light5ModelPosition"),
        LIGHT5_MODEL_DIRECTION("Light5ModelDirection"),
        LIGHT5_WORLD_POSITION("Light5WorldPosition"),
        LIGHT5_WORLD_DIRECTION("Light5WorldDirection"),
        LIGHT5_AMBIENT("Light5Ambient"),
        LIGHT5_DIFFUSE("Light5Diffuse"),
        LIGHT5_SPECULAR("Light5Specular"),
        LIGHT5_SPOTCUTOFF("Light5SpotCutoff"),
        LIGHT5_ATTENUATION("Light5Attenuation"),
        LIGHT6_MODEL_POSITION("Light6ModelPosition"),
        LIGHT6_MODEL_DIRECTION("Light6ModelDirection"),
        LIGHT6_WORLD_POSITION("Light6WorldPosition"),
        LIGHT6_WORLD_DIRECTION("Light6WorldDirection"),
        LIGHT6_AMBIENT("Light6Ambient"),
        LIGHT6_DIFFUSE("Light6Diffuse"),
        LIGHT6_SPECULAR("Light6Specular"),
        LIGHT6_SPOTCUTOFF("Light6SpotCutoff"),
        LIGHT6_ATTENUATION("Light6Attenuation"),
        LIGHT7_MODEL_POSITION("Light7ModelPosition"),
        LIGHT7_MODEL_DIRECTION("Light7ModelDirection"),
        LIGHT7_WORLD_POSITION("Light7WorldPosition"),
        LIGHT7_WORLD_DIRECTION("Light7WorldDirection"),
        LIGHT7_AMBIENT("Light7Ambient"),
        LIGHT7_DIFFUSE("Light7Diffuse"),
        LIGHT7_SPECULAR("Light7Specular"),
        LIGHT7_SPOTCUTOFF("Light7SpotCutoff"),
        LIGHT7_ATTENUATION("Light7Attenuation"),
        MAX_TYPES("MaxTypes");

        private String m_kName;
        private int m_iValue;
        private static int m_iInitValue;

        private Type(String kName) {
            this.m_kName = kName;
            this.m_iValue = this.Init();
            ms_pkTypeMap.put(this.m_kName, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }
}

