/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Shaders;

import java.io.Serializable;

public class UserConstant
implements Serializable {
    private static final long serialVersionUID = -9071032596441369552L;
    private String m_kName;
    private int m_iBaseRegister;
    private int m_iRegisterQuantity;
    private float[] m_afData;
    private int m_iNumFloats;

    public UserConstant(String kProgramName, String rkName, int iBaseRegister, int iRegisterQuantity, int iNumFloats) {
        this.m_kName = new String(rkName);
        assert (iBaseRegister >= 0);
        assert (iRegisterQuantity > 0);
        this.m_iBaseRegister = iBaseRegister;
        this.m_iRegisterQuantity = iRegisterQuantity;
        int iSize = 4 * this.m_iRegisterQuantity;
        this.m_afData = new float[iSize];
        this.m_iNumFloats = iNumFloats;
    }

    public void dispose() {
        this.m_kName = null;
        this.m_afData = null;
    }

    public final int GetBaseRegister() {
        return this.m_iBaseRegister;
    }

    public final float[] GetData() {
        return this.m_afData;
    }

    public float GetData(int iPos) {
        if (this.m_afData != null && iPos >= 0 && iPos < this.m_afData.length) {
            return this.m_afData[iPos];
        }
        return 0.0f;
    }

    public final int GetDataSize() {
        return this.m_iNumFloats;
    }

    public final String GetName() {
        return this.m_kName;
    }

    public final int GetRegisterQuantity() {
        return this.m_iRegisterQuantity;
    }

    public void SetData(int iPos, float fValue) {
        if (this.m_afData != null && iPos >= 0 && iPos < this.m_afData.length) {
            this.m_afData[iPos] = fValue;
        }
    }

    public void SetDataSource(float[] afData) {
        assert (afData != null);
        this.m_afData = afData;
    }
}

