/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.applications.hexplorer;

import hypergraph.graphApi.AttributeManager;
import hypergraph.graphApi.Element;
import hypergraph.graphApi.GraphException;
import hypergraph.graphApi.Group;
import hypergraph.graphApi.io.CSSColourParser;
import java.awt.Color;
import java.net.URL;
import javax.swing.ImageIcon;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GraphXMLContentHandler
extends hypergraph.graphApi.io.GraphXMLContentHandler {
    private URL baseUrl;

    public GraphXMLContentHandler(URL uRL) {
        this.baseUrl = uRL;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        if (string3.equals("line")) {
            this.startElementLine(attributes);
            return;
        }
        if (string3.equals("fill")) {
            this.startElementFill(attributes);
            return;
        }
        if (string3.equals("ref")) {
            this.startElementRef(attributes);
            return;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        if (string3.equals("line")) {
            this.endElementLine();
            return;
        }
        if (string3.equals("fill")) {
            this.endElementFill();
            return;
        }
    }

    protected void startElementLine(Attributes attributes) {
        String string;
        Group group = null;
        Color color = null;
        String string2 = "";
        float[] fArray = new float[]{5.0f, 3.0f};
        float[] fArray2 = new float[]{1.0f, 4.0f};
        float[] fArray3 = new float[]{5.0f, 3.0f, 1.0f, 3.0f};
        float[] fArray4 = new float[]{};
        float[] fArray5 = null;
        Float f = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getQName(i).equals("class")) {
                string = attributes.getValue(i);
                group = (Group)this.graph.getElement(string);
                if (group != null) continue;
                try {
                    group = this.graph.createGroup(string);
                }
                catch (GraphException graphException) {
                    graphException.printStackTrace();
                }
                continue;
            }
            if (attributes.getQName(i).equals("colour") || attributes.getQName(i).equals("color")) {
                color = CSSColourParser.stringToColor(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("linewidth")) {
                f = new Float(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("linestyle")) {
                if (attributes.getValue(i).equalsIgnoreCase("dashed")) {
                    fArray5 = fArray;
                }
                if (attributes.getValue(i).equalsIgnoreCase("dotted")) {
                    fArray5 = fArray2;
                }
                if (attributes.getValue(i).equalsIgnoreCase("dash-dotted")) {
                    fArray5 = fArray3;
                }
                if (!attributes.getValue(i).equalsIgnoreCase("none")) continue;
                fArray5 = fArray4;
                continue;
            }
            if (!attributes.getQName(i).equals("tag")) continue;
            string2 = attributes.getValue(i);
        }
        Element element = this.currentElement;
        if (element == null) {
            element = group == null ? this.graph : group;
        }
        string = null;
        AttributeManager attributeManager = this.graph.getAttributeManager();
        if (color != null) {
            if (element.getElementType() == 1 || string2.equals("node")) {
                attributeManager.setAttribute("node.color", element, color);
            }
            if (string == null && (element.getElementType() == 2 || string2.equals("edge"))) {
                attributeManager.setAttribute("edge.linecolor", element, color);
            }
        }
        if (f != null && (element.getElementType() == 2 || string2.equals("edge"))) {
            attributeManager.setAttribute("edge.linewidth", element, f);
        }
        if (fArray5 != null && (element.getElementType() == 2 || string2.equals("edge"))) {
            attributeManager.setAttribute("edge.stroke", element, fArray5);
        }
    }

    protected void endElementLine() {
    }

    protected void startElementFill(Attributes attributes) {
        Group group = null;
        Color color = null;
        String string = "";
        ImageIcon imageIcon = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            URL uRL;
            Object object;
            if (attributes.getQName(i).equals("class")) {
                object = attributes.getValue(i);
                group = (Group)this.graph.getElement((String)object);
                if (group != null) continue;
                try {
                    group = this.graph.createGroup((String)object);
                }
                catch (GraphException graphException) {
                    graphException.printStackTrace();
                }
                continue;
            }
            if (attributes.getQName(i).equals("colour") || attributes.getQName(i).equals("color")) {
                color = CSSColourParser.stringToColor(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("xlink:href")) {
                object = attributes.getValue(i);
                try {
                    uRL = new URL(this.baseUrl, (String)object);
                    imageIcon = new ImageIcon(uRL);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
                continue;
            }
            if (attributes.getQName(i).equals("tag")) {
                string = attributes.getValue(i);
            }
            if ((object = this.currentElement) == null) {
                object = group == null ? this.graph : group;
            }
            uRL = null;
            AttributeManager attributeManager = this.graph.getAttributeManager();
            if (color != null && (object.getElementType() == 1 || string.equals("node"))) {
                attributeManager.setAttribute("node.bkcolor", (Element)object, color);
            }
            if (imageIcon == null || object.getElementType() != 1 && !string.equals("node")) continue;
            attributeManager.setAttribute("node.icon", (Element)object, imageIcon);
        }
    }

    protected void endElementFill() {
    }

    protected void startElementRef(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            AttributeManager attributeManager;
            String string;
            if (attributes.getQName(i).equals("xlink:href")) {
                if (this.currentElement == null) {
                    return;
                }
                string = attributes.getValue(i);
                attributeManager = this.graph.getAttributeManager();
                attributeManager.setAttribute("xlink:href", this.currentElement, string);
            }
            if (!attributes.getQName(i).equals("xlink:show")) continue;
            if (this.currentElement == null) {
                return;
            }
            string = attributes.getValue(i);
            attributeManager = this.graph.getAttributeManager();
            attributeManager.setAttribute("xlink:show", this.currentElement, string);
        }
    }
}

