/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.hyperbolic;

import hypergraph.graphApi.io.CSSColourParser;
import hypergraph.hyperbolic.EmptyComponent;
import hypergraph.hyperbolic.ModelPanel;
import hypergraph.hyperbolic.ModelPoint;
import hypergraph.hyperbolic.TextRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DefaultTextRenderer
extends JComponent
implements TextRenderer {
    protected ModelPanel modelPanel;
    protected String text;
    protected JComponent stubRenderer = new EmptyComponent();
    protected boolean useStubRenderer;
    private int maxTextLength = -1;
    private Color color;
    private Color background;
    private Font font1;
    private Font font2;
    private Font font3;
    private Font font4;
    private double scale1;
    private double scale2;
    private double scale3;
    private double scale4;
    private double optimalRatio = 8.0;
    private List lines;

    public DefaultTextRenderer() {
        this.setOpaque(false);
        this.useStubRenderer = true;
        this.lines = new ArrayList();
    }

    public void configure(ModelPanel modelPanel) {
        this.configure(modelPanel, null, null);
    }

    public int getMaxTextLength() {
        return this.maxTextLength;
    }

    public void setMaxTextLength(int n) {
        this.maxTextLength = n;
    }

    @Override
    public Font getScaledFont(Point2D point2D) {
        double d = Math.max(point2D.getX(), point2D.getY());
        Font font = null;
        if (d > this.scale1) {
            font = this.font1;
        }
        if (d <= this.scale1 && d > this.scale2) {
            font = this.font2;
        }
        if (d <= this.scale2 && d > this.scale3) {
            font = this.font3;
        }
        if (d <= this.scale3) {
            font = this.font4;
        }
        return font;
    }

    protected boolean isDelimiter(char c) {
        return c == ' ' || c == ',' || c == ';' || c == '-' || c == '/' || c == '\\';
    }

    @Override
    public void configure(ModelPanel modelPanel, ModelPoint modelPoint, String string) {
        Font font;
        Object object;
        this.modelPanel = modelPanel;
        this.setColor(null);
        if (modelPoint == null || string == null) {
            this.useStubRenderer = true;
            return;
        }
        String string2 = (String)modelPanel.getPropertyManager().getProperty("hypergraph.hyperbolic.text.maxLength");
        if (this.maxTextLength == -1 && string2 != null) {
            this.maxTextLength = Integer.parseInt(string2);
        }
        if (this.font1 == null) {
            object = modelPanel.getPropertyManager().getString("hypergraph.hyperbolic.text.fontName");
            if (object == null) {
                object = "Arial";
            }
            font = new Font((String)object, 0, 1);
            float f = (float)modelPanel.getPropertyManager().getDouble("hypergraph.hyperbolic.text.size1", new Double(12.0)).doubleValue();
            this.font1 = font.deriveFont(f);
            f = (float)modelPanel.getPropertyManager().getDouble("hypergraph.hyperbolic.text.size2", new Double(10.0)).doubleValue();
            this.font2 = font.deriveFont(f);
            f = (float)modelPanel.getPropertyManager().getDouble("hypergraph.hyperbolic.text.size3", new Double(8.0)).doubleValue();
            this.font3 = font.deriveFont(f);
            f = (float)modelPanel.getPropertyManager().getDouble("hypergraph.hyperbolic.text.size4", new Double(0.0)).doubleValue();
            this.font4 = font.deriveFont(f);
            this.scale1 = modelPanel.getPropertyManager().getDouble("hypergraph.hyperbolic.text.scale1", new Double(0.75));
            this.scale2 = modelPanel.getPropertyManager().getDouble("hypergraph.hyperbolic.text.scale2", new Double(0.5));
            this.scale3 = modelPanel.getPropertyManager().getDouble("hypergraph.hyperbolic.text.scale3", new Double(0.25));
        }
        Point point = modelPanel.project(modelPoint);
        object = modelPanel.getScale(modelPoint);
        font = this.getScaledFont((Point2D)object);
        if (font == null) {
            this.useStubRenderer = true;
            return;
        }
        this.useStubRenderer = false;
        this.setFont(font);
        string = string.trim();
        if (this.maxTextLength >= 2 && string.length() > this.maxTextLength) {
            string = string.substring(0, this.maxTextLength - 2) + "..";
        }
        this.text = string;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont().deriveFont(1));
        double d = SwingUtilities.computeStringWidth(fontMetrics, string);
        double d2 = fontMetrics.getHeight();
        double d3 = 0.0;
        this.lines.clear();
        if (d / d2 < this.optimalRatio) {
            this.lines.add(0, string);
            d3 = d;
        } else {
            double d4 = d * d2;
            d = Math.sqrt(d4 * this.optimalRatio);
            int n = 0;
            double d5 = 0.0;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!this.isDelimiter(c)) continue;
                String string3 = string.substring(n, i + 1);
                n = i + 1;
                double d6 = SwingUtilities.computeStringWidth(fontMetrics, string3);
                if (d6 + d5 > d) {
                    this.lines.add(stringBuffer.toString().trim());
                    stringBuffer.setLength(0);
                    d5 = 0.0;
                }
                stringBuffer.append(string3);
                d5 += d6;
                if (!(d5 > d3)) continue;
                d3 = d5;
            }
            if (stringBuffer.length() == 0) {
                stringBuffer.append(string);
                d3 = SwingUtilities.computeStringWidth(fontMetrics, string);
            } else {
                String string4 = string.substring(n, string.length());
                double d7 = SwingUtilities.computeStringWidth(fontMetrics, string4);
                if (d7 + d5 > d) {
                    this.lines.add(stringBuffer.toString().trim());
                    stringBuffer.setLength(0);
                    d5 = 0.0;
                }
                stringBuffer.append(string4);
                d5 += d7;
                if (d5 > d3) {
                    d3 = d5;
                }
            }
            this.lines.add(stringBuffer.toString().trim());
        }
        d2 = fontMetrics.getHeight() * this.lines.size();
        this.setSize(new Dimension((int)Math.round(d3), (int)Math.round(d2)));
        point.translate(-this.getWidth() / 2, -this.getHeight() / 2);
        this.setLocation(point);
    }

    public Color getColor() {
        if (this.color != null) {
            return this.color;
        }
        String string = this.modelPanel.getPropertyManager().getString("hypergraph.hyperbolic.text.color");
        return CSSColourParser.stringToColor(string);
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        String string = this.modelPanel.getPropertyManager().getString("hypergraph.hyperbolic.text.backgroundColor");
        if (string == null) {
            return null;
        }
        return CSSColourParser.stringToColor(string);
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getColor());
        if (this.getBackground() != null) {
            ((Graphics2D)graphics).setBackground(this.getBackground());
            graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = 0;
        for (String string : this.lines) {
            int n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
            graphics.drawString(string, (this.getWidth() - n2) / 2, n += fontMetrics.getAscent());
        }
    }

    @Override
    public Component getComponent() {
        if (this.useStubRenderer) {
            return this.stubRenderer;
        }
        return this;
    }
}

