/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.test;

import hypergraph.graphApi.AttributeManager;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphSystem;
import hypergraph.graphApi.GraphSystemFactory;
import hypergraph.graphApi.Node;
import hypergraph.graphApi.algorithms.GraphUtilities;
import hypergraph.graphApi.io.ContentHandlerFactory;
import hypergraph.graphApi.io.SAXReader;
import hypergraph.visualnet.GraphPanel;
import hypergraph.visualnet.GraphSelectionEvent;
import hypergraph.visualnet.GraphSelectionListener;
import hypergraph.visualnet.GraphSelectionModel;
import java.applet.AppletContext;
import java.awt.Component;
import java.net.URL;
import java.util.Iterator;
import javax.swing.JApplet;
import javax.swing.UIManager;

public class NetApplet
extends JApplet
implements GraphSelectionListener {
    static Graph graph;

    @Override
    public void valueChanged(GraphSelectionEvent graphSelectionEvent) {
        GraphSelectionModel graphSelectionModel = (GraphSelectionModel)graphSelectionEvent.getSource();
        Iterator iterator = graphSelectionModel.getSelectionElementIterator();
        if (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            AttributeManager attributeManager = graph.getAttributeManager();
            String string = (String)attributeManager.getAttribute("xlink:href", node);
            AppletContext appletContext = this.getAppletContext();
            try {
                URL uRL = new URL(string);
                appletContext.showDocument(uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void init() {
        Object object;
        String string = this.getParameter("file");
        UIManager.put("ModelPanelUI", "hypergraph.hyperbolic.ModelPanelUI");
        GraphSystem graphSystem = null;
        try {
            graphSystem = GraphSystemFactory.createGraphSystem("hypergraph.graph.GraphSystemImpl", null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(8);
        }
        graph = null;
        URL uRL = null;
        try {
            uRL = new URL(this.getCodeBase(), string);
            object = new SAXReader(graphSystem, uRL);
            ((SAXReader)object).setContentHandlerFactory(new ContentHandlerFactory());
            graph = ((SAXReader)object).parse();
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
            exception.printStackTrace(System.out);
        }
        if (graph == null) {
            graph = GraphUtilities.createTree(graphSystem, 3, 3);
        }
        object = new GraphPanel(graph);
        ((GraphPanel)object).getSelectionModel().addSelectionEventListener(this);
        this.getContentPane().add((Component)object);
    }
}

