/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.visualnet;

import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphEvent;
import hypergraph.hyperbolic.Model;
import hypergraph.hyperbolic.PropertyManager;
import hypergraph.visualnet.GraphLayout;
import hypergraph.visualnet.GraphLayoutModel;

public abstract class AbstractGraphLayout
implements GraphLayout {
    private Graph graph;
    private GraphLayoutModel graphLayoutModel;
    private PropertyManager properties;
    private Model model;

    @Override
    public void setGraph(Graph graph) {
        if (this.graph != null) {
            this.graph.removeGraphListener(this);
        }
        this.graph = graph;
        if (this.graph != null) {
            this.graph.addGraphListener(this);
        }
        this.invalidate();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public void setModel(Model model) {
        this.model = model;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void invalidate() {
        if (this.graphLayoutModel != null) {
            this.graphLayoutModel.setValid(false);
        }
    }

    @Override
    public boolean isValid() {
        if (this.graphLayoutModel != null) {
            return this.graphLayoutModel.isValid();
        }
        return false;
    }

    @Override
    public void setGraphLayoutModel(GraphLayoutModel graphLayoutModel) {
        this.graphLayoutModel = graphLayoutModel;
    }

    @Override
    public GraphLayoutModel getGraphLayoutModel() {
        return this.graphLayoutModel;
    }

    @Override
    public void setProperties(PropertyManager propertyManager) {
        this.properties = propertyManager;
    }

    protected PropertyManager getProperties() {
        return this.properties;
    }

    @Override
    public void elementsAdded(GraphEvent graphEvent) {
        this.invalidate();
    }

    @Override
    public void elementsRemoved(GraphEvent graphEvent) {
        this.invalidate();
    }

    @Override
    public void structureChanged(GraphEvent graphEvent) {
        this.invalidate();
    }
}

