/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.visualnet;

import hypergraph.hyperbolic.DefaultLineRenderer;
import hypergraph.hyperbolic.ModelPanelUI;
import hypergraph.hyperbolic.ModelPoint;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class ArrowLineRenderer
extends DefaultLineRenderer {
    private boolean _showArrows = true;

    public void setShowArrows(boolean bl) {
        this._showArrows = bl;
    }

    public boolean isShowArrows() {
        return this._showArrows;
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        if (this.start == null || this.end == null) {
            return;
        }
        graphics.setColor(this.getColor());
        ModelPanelUI modelPanelUI = this.panel.getUI();
        Point[] pointArray = this.panel.getProjector().getLineSegments(this.start, this.end, this.panel);
        int[] nArray = new int[pointArray.length];
        int[] nArray2 = new int[pointArray.length];
        for (n = 0; n < pointArray.length; ++n) {
            nArray[n] = pointArray[n].x;
            nArray2[n] = pointArray[n].y;
        }
        graphics.drawPolyline(nArray, nArray2, pointArray.length);
        if (this._showArrows) {
            n = pointArray.length / 2;
            int n2 = n + 1;
            if (n2 >= pointArray.length) {
                return;
            }
            ModelPoint modelPoint = this.panel.unProject(pointArray[n2]);
            this.drawArrow(graphics, nArray[n], nArray2[n], nArray[n2], nArray2[n2], this.panel.getScale(modelPoint).getX(), this.panel.getScale(modelPoint).getY());
        }
    }

    protected void drawArrow(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2) {
        int n5 = (int)Math.round(15.0 * d);
        int n6 = (int)Math.round(15.0 * d2);
        Color color = this.getColor();
        Color color2 = this.getColor();
        int n7 = 60;
        graphics.drawLine(n, n2, n3, n4);
        double d3 = n3 - n;
        double d4 = n4 - n2;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        int n8 = (int)Math.toDegrees(Math.asin(d4 / d5));
        n8 = d3 > 0.0 ? 180 - n8 - 30 : (n8 -= 30);
        graphics.setColor(color);
        graphics.fillArc(n3 - n5 / 2, n4 - n6 / 2 + 1, n5, n6, n8, n7);
        graphics.setColor(color2);
    }
}

