/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.visualnet;

import hypergraph.graphApi.AttributeManager;
import hypergraph.graphApi.Edge;
import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphException;
import hypergraph.graphApi.Node;
import hypergraph.graphApi.io.CSSColourParser;
import hypergraph.hyperbolic.ModelPanel;
import hypergraph.hyperbolic.ModelPoint;
import hypergraph.visualnet.DefaultEdgeRenderer;
import hypergraph.visualnet.DefaultGraphLayoutModel;
import hypergraph.visualnet.DefaultGraphSelectionModel;
import hypergraph.visualnet.DefaultNodeRenderer;
import hypergraph.visualnet.EdgeRenderer;
import hypergraph.visualnet.GraphLayout;
import hypergraph.visualnet.GraphLayoutEvent;
import hypergraph.visualnet.GraphLayoutListener;
import hypergraph.visualnet.GraphLayoutModel;
import hypergraph.visualnet.GraphSelectionEvent;
import hypergraph.visualnet.GraphSelectionListener;
import hypergraph.visualnet.GraphSelectionModel;
import hypergraph.visualnet.NodeRenderer;
import hypergraph.visualnet.TreeLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import javax.swing.JComponent;

public class GraphPanel
extends ModelPanel
implements MouseListener,
GraphLayoutListener,
GraphSelectionListener {
    public static final String NODE_FOREGROUND = "node.color";
    public static final String NODE_BACKGROUND = "node.bkcolor";
    public static final String NODE_ICON = "node.icon";
    public static final String EDGE_TEXTCOLOR = "edge.textcolor";
    public static final String EDGE_LINECOLOR = "edge.linecolor";
    public static final String EDGE_LINEWIDTH = "edge.linewidth";
    public static final String EDGE_STROKE = "edge.stroke";
    public static final String NODE_EXPANDED = "NODE_EXPANDED";
    public final ExpandAction expandAction = new ExpandAction(true);
    public final ExpandAction shrinkAction = new ExpandAction(false);
    Graph graph;
    GraphLayout graphLayout;
    GraphSelectionModel selectionModel;
    private Image logo;
    private Image smallLogo;
    private Element hoverElement;
    private Node lastMouseClickNode;
    private NodeRenderer nodeRenderer;
    private EdgeRenderer edgeRenderer;

    public GraphPanel(Graph graph) {
        this.setGraph(graph);
        this.createGraphLayout();
        this.createGraphSelectionModel();
        this.selectionModel.addSelectionEventListener(this);
        this.setNodeRenderer(new DefaultNodeRenderer());
        this.setEdgeRenderer(new DefaultEdgeRenderer());
        this.initDefaultAttributes();
        URL uRL = this.getClass().getResource("/hypergraph/visualnet/logo.png");
        if (uRL != null) {
            this.logo = Toolkit.getDefaultToolkit().createImage(uRL);
        }
        if ((uRL = this.getClass().getResource("/hypergraph/visualnet/logo_small.png")) != null) {
            this.smallLogo = Toolkit.getDefaultToolkit().createImage(uRL);
        }
    }

    protected void initDefaultAttributes() {
        AttributeManager attributeManager = this.graph.getAttributeManager();
        String string = this.getPropertyManager().getString("hypergraph.hyperbolic.line.color");
        Color color = CSSColourParser.stringToColor(string);
        if (color == null || string == null) {
            color = Color.LIGHT_GRAY;
        }
        attributeManager.setAttribute(EDGE_LINECOLOR, this.graph, color);
        attributeManager.setAttribute(EDGE_STROKE, this.graph, null);
        attributeManager.setAttribute(EDGE_LINEWIDTH, this.graph, new Float(1.0f));
    }

    public void createGraphLayout() {
        GraphLayout graphLayout;
        try {
            Class clazz = this.getPropertyManager().getClass("hypergraph.visualnet.layout.class");
            graphLayout = (GraphLayout)clazz.newInstance();
        }
        catch (Exception exception) {
            graphLayout = new TreeLayout(this.getGraph(), this.getModel(), this.getPropertyManager());
        }
        this.setGraphLayout(graphLayout);
    }

    @Override
    public void loadProperties(InputStream inputStream) throws IOException {
        super.loadProperties(inputStream);
        this.createGraphLayout();
        this.initDefaultAttributes();
    }

    public void setGraphLayout(GraphLayout graphLayout) {
        if (this.graphLayout != null) {
            this.graphLayout.getGraphLayoutModel().removeLayoutEventListener(this);
        }
        this.graphLayout = graphLayout;
        this.graphLayout.setGraph(this.graph);
        this.graphLayout.setProperties(this.getPropertyManager());
        this.graphLayout.setModel(this.getModel());
        DefaultGraphLayoutModel defaultGraphLayoutModel = new DefaultGraphLayoutModel();
        this.graphLayout.setGraphLayoutModel(defaultGraphLayoutModel);
        this.graphLayout.layout();
        this.graphLayout.getGraphLayoutModel().addLayoutEventListener(this);
    }

    public GraphLayout getGraphLayout() {
        return this.graphLayout;
    }

    void createGraphSelectionModel() {
        this.setGraphSelectionModel(new DefaultGraphSelectionModel(this.getGraph()));
    }

    public void setGraphSelectionModel(GraphSelectionModel graphSelectionModel) {
        this.selectionModel = graphSelectionModel;
    }

    public GraphSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
        if (this.graphLayout != null) {
            this.graphLayout.setGraph(this.graph);
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void valueChanged(GraphLayoutEvent graphLayoutEvent) {
        this.repaint();
    }

    protected void checkLayout() {
        if (!this.getGraphLayout().isValid()) {
            this.getGraphLayout().layout();
        }
    }

    public Iterator getVisibleNodeIterator() {
        return this.graphLayout.getGraph().getNodes().iterator();
    }

    public Iterator getVisibleEdgeIterator() {
        return this.graphLayout.getGraph().getEdges().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        Graph graph = this.graph;
        synchronized (graph) {
            Element element;
            this.checkLayout();
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.getUI().isDraft()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            super.paint(graphics);
            GraphLayoutModel graphLayoutModel = this.getGraphLayout().getGraphLayoutModel();
            Object object = this.getVisibleEdgeIterator();
            while (object.hasNext()) {
                element = (Edge)object.next();
                if (element == this.hoverElement) continue;
                this.edgeRenderer.configure(this, (Edge)element);
                this.paintRenderer(graphics, this.edgeRenderer);
            }
            object = this.getVisibleNodeIterator();
            while (object.hasNext()) {
                element = (Node)object.next();
                if (element == this.hoverElement) continue;
                ModelPoint modelPoint = graphLayoutModel.getNodePosition((Node)element);
                this.nodeRenderer.configure(this, modelPoint, (Node)element);
                this.paintRenderer(graphics, this.nodeRenderer);
            }
            if (this.hoverElement != null) {
                if (this.hoverElement.getElementType() == 2) {
                    this.edgeRenderer.configure(this, (Edge)this.hoverElement);
                    this.paintRenderer(graphics, this.edgeRenderer);
                }
                if (this.hoverElement.getElementType() == 1) {
                    object = graphLayoutModel.getNodePosition((Node)this.hoverElement);
                    this.nodeRenderer.configure(this, (ModelPoint)object, (Node)this.hoverElement);
                    this.paintRenderer(graphics, this.nodeRenderer);
                }
            }
        }
        if (this.getWidth() > 300 && this.getHeight() > 300) {
            if (this.logo != null) {
                graphics.drawImage(this.logo, this.getWidth() - this.logo.getWidth(this), this.getHeight() - this.logo.getHeight(this), this);
            }
        } else if (this.smallLogo != null) {
            graphics.drawImage(this.smallLogo, this.getWidth() - this.smallLogo.getWidth(this), this.getHeight() - this.smallLogo.getHeight(this), this);
        }
    }

    public Element getHoverElement() {
        return this.hoverElement;
    }

    protected void setHoverElement(Element element, boolean bl) {
        this.hoverElement = element;
        if (bl) {
            this.repaint();
        }
    }

    public void setLogo(Image image) {
        this.logo = image;
    }

    public void setSmallLogo(Image image) {
        this.smallLogo = image;
    }

    protected boolean isOnLogo(Point point) {
        if (this.logo != null) {
            return point.getX() > (double)(this.getWidth() - this.logo.getWidth(this)) && point.getY() > (double)(this.getHeight() - this.logo.getHeight(this));
        }
        return false;
    }

    protected void logoClicked(MouseEvent mouseEvent) {
    }

    public boolean hasExpander(Node node) {
        if (!this.getGraphLayout().isExpandingEnabled()) {
            return false;
        }
        AttributeManager attributeManager = this.graphLayout.getGraph().getAttributeManager();
        ExpandAction expandAction = (ExpandAction)attributeManager.getAttribute(NODE_EXPANDED, node);
        return expandAction != null;
    }

    public boolean isExpanded(Node node) {
        AttributeManager attributeManager = this.graphLayout.getGraph().getAttributeManager();
        ExpandAction expandAction = (ExpandAction)attributeManager.getAttribute(NODE_EXPANDED, node);
        if (expandAction == null) {
            return false;
        }
        return expandAction == this.shrinkAction;
    }

    public void expandNode(Node node) {
        AttributeManager attributeManager = this.graphLayout.getGraph().getAttributeManager();
        for (Edge edge : this.graph.getEdges(node)) {
            Node node2;
            if (edge.getSource() != node) continue;
            try {
                this.graphLayout.getGraph().addElement(edge);
            }
            catch (GraphException graphException) {
                // empty catch block
            }
            if (this.graph.getEdges(node2 = edge.getOtherNode(node)).size() == 0) continue;
            attributeManager.setAttribute(NODE_EXPANDED, node2, this.expandAction);
        }
        attributeManager.setAttribute(NODE_EXPANDED, node, this.shrinkAction);
    }

    public void shrinkNode(Node node) {
        AttributeManager attributeManager = this.graphLayout.getGraph().getAttributeManager();
        for (Edge edge : this.graph.getEdges(node)) {
            if (edge.getSource() != node) continue;
            Node node2 = edge.getOtherNode(node);
            this.graphLayout.getGraph().removeElement(node2);
        }
        attributeManager.setAttribute(NODE_EXPANDED, node, this.expandAction);
    }

    public void centerNode(Node node) {
        GraphLayoutModel graphLayoutModel = this.getGraphLayout().getGraphLayoutModel();
        this.getUI().center(graphLayoutModel.getNodePosition(node), (JComponent)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getElement(Point point) {
        GraphLayoutModel graphLayoutModel = this.getGraphLayout().getGraphLayoutModel();
        Graph graph = this.graph;
        synchronized (graph) {
            GraphLayoutModel graphLayoutModel2 = graphLayoutModel;
            synchronized (graphLayoutModel2) {
                Object object;
                Element element;
                NodeRenderer nodeRenderer = this.getNodeRenderer();
                Point point2 = new Point();
                Iterator iterator = this.getVisibleNodeIterator();
                while (iterator.hasNext()) {
                    element = (Node)iterator.next();
                    nodeRenderer.configure(this, graphLayoutModel.getNodePosition((Node)element), (Node)element);
                    object = nodeRenderer.getComponent();
                    point2.setLocation(point.getX() - (double)((Component)object).getX(), point.getY() - (double)((Component)object).getY());
                    if (!((Component)object).contains(point2)) continue;
                    return element;
                }
                iterator = this.getVisibleEdgeIterator();
                while (iterator.hasNext()) {
                    element = (Edge)iterator.next();
                    object = graphLayoutModel.getNodePosition(element.getSource());
                    ModelPoint modelPoint = graphLayoutModel.getNodePosition(element.getTarget());
                    ModelPoint modelPoint2 = this.unProject(point);
                    if (modelPoint2 == null || !(this.getModel().getDistance(modelPoint2, (ModelPoint)object, modelPoint, true, true) < 0.025)) continue;
                    return element;
                }
            }
        }
        return null;
    }

    public void nodeClicked(int n, Node node) {
        if (n == 1) {
            this.lastMouseClickNode = node;
            if (this.lastMouseClickNode != null) {
                this.centerNode(this.lastMouseClickNode);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isOnLogo(mouseEvent.getPoint())) {
            this.logoClicked(mouseEvent);
            return;
        }
        this.setHoverElement(null, false);
        Element element = this.getElement(mouseEvent.getPoint());
        if (element != null && element.getElementType() == 1) {
            if (mouseEvent.getClickCount() == 1) {
                this.nodeClicked(1, (Node)element);
                return;
            }
            if (mouseEvent.getClickCount() == 2 && this.lastMouseClickNode != null) {
                this.nodeClicked(2, this.lastMouseClickNode);
                return;
            }
            NodeRenderer nodeRenderer = this.getNodeRenderer();
            GraphLayoutModel graphLayoutModel = this.getGraphLayout().getGraphLayoutModel();
            nodeRenderer.configure(this, graphLayoutModel.getNodePosition((Node)element), (Node)element);
        }
        super.mouseClicked(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Element element = this.getElement(mouseEvent.getPoint());
        this.setHoverElement(element, true);
    }

    @Override
    public void valueChanged(GraphSelectionEvent graphSelectionEvent) {
        Iterator iterator = this.getSelectionModel().getSelectionElementIterator();
        this.repaint();
    }

    public EdgeRenderer getEdgeRenderer() {
        return this.edgeRenderer;
    }

    public void setEdgeRenderer(EdgeRenderer edgeRenderer) {
        this.edgeRenderer = edgeRenderer;
    }

    public void setNodeRenderer(NodeRenderer nodeRenderer) {
        this.nodeRenderer = nodeRenderer;
    }

    public NodeRenderer getNodeRenderer() {
        return this.nodeRenderer;
    }

    public class ExpandAction
    implements ActionListener {
        private boolean expand;

        public ExpandAction(boolean bl) {
            this.expand = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Node node = (Node)actionEvent.getSource();
            if (this.expand) {
                GraphPanel.this.expandNode(node);
            } else {
                GraphPanel.this.shrinkNode(node);
            }
            GraphPanel.this.repaint();
        }
    }
}

