/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.visualnet;

import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphEvent;
import hypergraph.graphApi.Node;
import hypergraph.hyperbolic.Complex;
import hypergraph.visualnet.AbstractGraphLayout;
import hypergraph.visualnet.DefaultGraphLayoutModel;

public class RandomLayout
extends AbstractGraphLayout {
    public RandomLayout() {
    }

    public RandomLayout(Graph graph) {
        this.setGraph(graph);
    }

    @Override
    public void elementsAdded(GraphEvent graphEvent) {
        this.invalidate();
        Element element = graphEvent.getElement();
        if (element instanceof Node) {
            this.getGraphLayoutModel().setNodePosition((Node)element, new Complex(Math.random() * 1.4 - 0.7, Math.random() * 1.4 - 0.7));
        }
    }

    @Override
    public void layout() {
        if (this.getGraphLayoutModel() == null) {
            this.setGraphLayoutModel(new DefaultGraphLayoutModel());
        }
        for (Node node : this.getGraph().getNodes()) {
            this.getGraphLayoutModel().setNodePosition(node, new Complex(Math.random() * 1.4 - 0.7, Math.random() * 1.4 - 0.7));
        }
        this.getGraphLayoutModel().setValid(true);
    }

    @Override
    public boolean isExpandingEnabled() {
        return false;
    }
}

