/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.visualnet;

import hypergraph.graphApi.Edge;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.Node;
import hypergraph.hyperbolic.Functions;
import hypergraph.hyperbolic.Isometry;
import hypergraph.hyperbolic.Model;
import hypergraph.hyperbolic.ModelPoint;
import hypergraph.hyperbolic.ModelVector;
import hypergraph.hyperbolic.PropertyManager;
import hypergraph.visualnet.AbstractGraphLayout;
import hypergraph.visualnet.DefaultGraphLayoutModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class TreeLayout
extends AbstractGraphLayout {
    private double maxAngle;
    private double minDistance;
    private double defaultSize;
    private double rootAngle = Math.PI;
    Map properties;
    Node root;
    private Boolean expandingEnabled;

    public TreeLayout(Graph graph, Model model, PropertyManager propertyManager) {
        this.setGraphLayoutModel(new DefaultGraphLayoutModel());
        this.setGraph(graph);
        this.setModel(model);
        this.setProperties(propertyManager);
        this.setRootAngle(Math.PI);
        this.setRoot(this.root);
    }

    @Override
    public void setProperties(PropertyManager propertyManager) {
        super.setProperties(propertyManager);
        Double d = propertyManager.getDouble("hypergraph.visualnet.TreeLayout.maxangle", new Double(180.0));
        this.setMaxAngle(d * Math.PI / 360.0);
        d = propertyManager.getDouble("hypergraph.visualnet.TreeLayout.mindistance", new Double(0.3));
        this.setMinDistance(d);
        d = propertyManager.getDouble("hypergraph.visualnet.TreeLayout.defaultSize", new Double(0.3));
        this.setDefaultSize(d);
        this.invalidate();
    }

    private double getDistance(double d, double d2, double d3) {
        double d4 = Functions.arsinh(Functions.sinh(d3) / Math.sin(d));
        if (Math.abs(d2) < 0.001) {
            return d4;
        }
        double d5 = Functions.arcosh((1.0 + Math.cos(d) * Math.cos(Math.PI - d2)) / (Math.sin(d) * Math.sin(Math.PI - d2)));
        return Math.max(d4, d5);
    }

    private double getAngle(double d, double d2, double d3) {
        double d4 = Math.asin(Functions.sinh(d3) / Functions.sinh(d));
        double d5 = Math.asin(Math.sin(Math.PI - d2) / (Functions.cosh(d) - Functions.sinh(d) * Math.cos(Math.PI - d2)));
        return Math.max(d4, d5);
    }

    private double getSize(Node node) {
        return this.defaultSize;
    }

    private void computeNodeProperties(Node node) {
        double d;
        NodeProperties nodeProperties = new NodeProperties();
        this.properties.put(node, nodeProperties);
        nodeProperties.angle2 = 0.0;
        Collection collection = this.getGraph().getSpanningTree().getEdges(node);
        if (collection.size() == 0) {
            return;
        }
        int n = 0;
        for (Edge edge : collection) {
            if (node != edge.getSource()) continue;
            ++n;
            Node node2 = edge.getTarget();
            this.computeNodeProperties(node2);
            Object object = (NodeProperties)this.properties.get(node2);
            ((NodeProperties)object).distance = Math.max(this.minDistance, this.getSize(node) + this.getSize(node2));
            ((NodeProperties)object).angle1 = this.getAngle(((NodeProperties)object).distance, ((NodeProperties)object).angle2, this.getSize(node2));
            nodeProperties.angle2 += ((NodeProperties)object).angle1;
        }
        if (node.equals(this.root) && n > 1) {
            d = this.rootAngle / nodeProperties.angle2;
        } else {
            if (nodeProperties.angle2 < this.maxAngle) {
                return;
            }
            d = this.maxAngle / nodeProperties.angle2;
            nodeProperties.angle2 = this.maxAngle;
        }
        for (Object object : collection) {
            if (!node.equals(object.getSource())) continue;
            Node node3 = object.getTarget();
            NodeProperties nodeProperties2 = (NodeProperties)this.properties.get(node3);
            nodeProperties2.angle1 *= d;
            nodeProperties2.distance = this.getDistance(nodeProperties2.angle1, nodeProperties2.angle2, this.getSize(node3));
            nodeProperties2.distance = Math.max(this.minDistance, nodeProperties2.distance);
        }
    }

    protected void layoutSubTree(Node node, ModelVector modelVector) {
        this.getGraphLayoutModel().setNodePosition(node, (ModelPoint)modelVector.getBase().clone());
        NodeProperties nodeProperties = (NodeProperties)this.properties.get(node);
        Collection collection = this.getGraph().getSpanningTree().getEdges(node);
        if (collection.size() == 0) {
            return;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Edge element : collection) {
            if (!node.equals(element.getSource())) continue;
            arrayList.add(element.getTarget());
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Node)object).getName().compareTo(((Node)object2).getName());
            }
        });
        this.getModel().getRotation(modelVector.getBase(), -nodeProperties.angle2).apply(modelVector);
        for (Node node2 : arrayList) {
            NodeProperties nodeProperties2 = (NodeProperties)this.properties.get(node2);
            Isometry isometry = this.getModel().getRotation(modelVector.getBase(), nodeProperties2.angle1);
            isometry.apply(modelVector);
            ModelVector modelVector2 = (ModelVector)modelVector.clone();
            this.getModel().getTranslation(modelVector, nodeProperties2.distance).apply(modelVector2);
            this.layoutSubTree(node2, modelVector2);
            isometry.apply(modelVector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layout() {
        Graph graph;
        this.getGraphLayoutModel().clearNodePositions();
        ModelVector modelVector = this.getModel().getDefaultVector();
        if (this.root == null) {
            graph = this.getGraph().getSpanningTree();
            this.root = (Node)graph.getAttributeManager().getAttribute("GRAPH_ROOT", graph);
        }
        this.getGraph().getSpanningTree(this.root);
        graph = this.getGraph();
        synchronized (graph) {
            this.properties = new HashMap();
            this.computeNodeProperties(this.root);
            this.layoutSubTree(this.root, modelVector);
        }
        this.getGraphLayoutModel().setValid(true);
    }

    public void setExpandingEnabled(boolean bl) {
        this.expandingEnabled = new Boolean(bl);
    }

    @Override
    public boolean isExpandingEnabled() {
        if (this.expandingEnabled != null) {
            return this.expandingEnabled;
        }
        String string = this.getProperties().getString("visualnet.layout.expandingEnabled");
        return string != null && string.equalsIgnoreCase("true");
    }

    public double getMaxAngle() {
        return this.maxAngle;
    }

    public double getMinDistance() {
        return this.minDistance;
    }

    public double getRootAngle() {
        return this.rootAngle;
    }

    public void setMaxAngle(double d) {
        this.maxAngle = d;
    }

    public void setMinDistance(double d) {
        this.minDistance = d;
    }

    public void setRootAngle(double d) {
        this.rootAngle = d;
    }

    public double getDefaultSize() {
        return this.defaultSize;
    }

    public void setDefaultSize(double d) {
        this.defaultSize = d;
    }

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node node) {
        this.root = node;
    }

    private class EdgeComparator
    implements Comparator {
        private EdgeComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            Edge edge = (Edge)object;
            Edge edge2 = (Edge)object2;
            int n = edge.getSource().getName().compareTo(edge2.getSource().getName());
            if (n != 0) {
                return n;
            }
            n = edge.getTarget().getName().compareTo(edge2.getTarget().getName());
            return n;
        }
    }

    protected class NodeProperties {
        double distance;
        double angle1;
        double angle2;

        protected NodeProperties() {
        }

        public String toString() {
            return "[ TreeLayout.NodeProperties : \n angle1    = " + this.angle1 + " \n" + "angle2    = " + this.angle2 + " \n" + "distance    = " + this.distance + "]\n";
        }
    }
}

