/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;

public interface JavacOption {
    public OptionKind getKind();

    public boolean hasArg();

    public boolean matches(String var1);

    public boolean process(Options var1, String var2, String var3);

    public boolean process(Options var1, String var2);

    public OptionName getName();

    public static class HiddenOption
    extends Option {
        HiddenOption(OptionName optionName) {
            super(optionName, null, null);
        }

        HiddenOption(OptionName optionName, String string) {
            super(optionName, string, null);
        }

        void help(PrintWriter printWriter) {
        }

        void xhelp(PrintWriter printWriter) {
        }

        public OptionKind getKind() {
            return OptionKind.HIDDEN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XOption
    extends Option {
        XOption(OptionName optionName, String string, String string2) {
            super(optionName, string, string2);
        }

        XOption(OptionName optionName, String string) {
            this(optionName, null, string);
        }

        XOption(OptionName optionName, String string, ChoiceKind choiceKind, String ... stringArray) {
            super(optionName, string, choiceKind, stringArray);
        }

        XOption(OptionName optionName, String string, ChoiceKind choiceKind, Collection<String> collection) {
            super(optionName, string, choiceKind, collection);
        }

        @Override
        void help(PrintWriter printWriter) {
        }

        @Override
        void xhelp(PrintWriter printWriter) {
            super.help(printWriter);
        }

        @Override
        public OptionKind getKind() {
            return OptionKind.EXTENDED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Option
    implements JavacOption {
        OptionName name;
        String argsNameKey;
        String descrKey;
        boolean hasSuffix;
        ChoiceKind choiceKind;
        Collection<String> choices;

        Option(OptionName optionName, String string, String string2) {
            this.name = optionName;
            this.argsNameKey = string;
            this.descrKey = string2;
            char c = optionName.optionName.charAt(optionName.optionName.length() - 1);
            this.hasSuffix = c == ':' || c == '=';
        }

        Option(OptionName optionName, String string) {
            this(optionName, null, string);
        }

        Option(OptionName optionName, String string, ChoiceKind choiceKind, String ... stringArray) {
            this(optionName, string, choiceKind, Arrays.asList(stringArray));
        }

        Option(OptionName optionName, String string, ChoiceKind choiceKind, Collection<String> collection) {
            this(optionName, null, string);
            if (choiceKind == null || collection == null) {
                throw new NullPointerException();
            }
            this.choiceKind = choiceKind;
            this.choices = collection;
        }

        public String toString() {
            return this.name.optionName;
        }

        @Override
        public boolean hasArg() {
            return this.argsNameKey != null && !this.hasSuffix;
        }

        @Override
        public boolean matches(String string) {
            if (!this.hasSuffix) {
                return string.equals(this.name.optionName);
            }
            if (!string.startsWith(this.name.optionName)) {
                return false;
            }
            if (this.choices != null) {
                String string2 = string.substring(this.name.optionName.length());
                if (this.choiceKind == ChoiceKind.ONEOF) {
                    return this.choices.contains(string2);
                }
                for (String string3 : string2.split(",+")) {
                    if (this.choices.contains(string3)) continue;
                    return false;
                }
            }
            return true;
        }

        void help(PrintWriter printWriter) {
            String string = "  " + this.helpSynopsis();
            printWriter.print(string);
            for (int i = Math.min(string.length(), 28); i < 29; ++i) {
                printWriter.print(" ");
            }
            Log.printLines(printWriter, Main.getLocalizedString(this.descrKey, new Object[0]));
        }

        String helpSynopsis() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((Object)this.name);
            if (this.argsNameKey == null) {
                if (this.choices != null) {
                    String string = "{";
                    for (String string2 : this.choices) {
                        stringBuilder.append(string);
                        stringBuilder.append(string2);
                        string = ",";
                    }
                    stringBuilder.append("}");
                }
            } else {
                if (!this.hasSuffix) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(Main.getLocalizedString(this.argsNameKey, new Object[0]));
            }
            return stringBuilder.toString();
        }

        void xhelp(PrintWriter printWriter) {
        }

        @Override
        public boolean process(Options options, String string, String string2) {
            if (options != null) {
                if (this.choices != null) {
                    if (this.choiceKind == ChoiceKind.ONEOF) {
                        String string32;
                        for (String string32 : this.choices) {
                            options.remove(string + string32);
                        }
                        String string4 = string + string2;
                        options.put(string4, string4);
                        string32 = string.substring(0, string.length() - 1);
                        options.put(string32, string2);
                    } else {
                        for (String string5 : string2.split(",+")) {
                            String string6 = string + string5;
                            options.put(string6, string6);
                        }
                    }
                }
                options.put(string, string2);
            }
            return false;
        }

        @Override
        public boolean process(Options options, String string) {
            if (this.hasSuffix) {
                return this.process(options, this.name.optionName, string.substring(this.name.optionName.length()));
            }
            return this.process(options, string, string);
        }

        @Override
        public OptionKind getKind() {
            return OptionKind.NORMAL;
        }

        @Override
        public OptionName getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChoiceKind {
        ONEOF,
        ANYOF;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionKind {
        NORMAL,
        EXTENDED,
        HIDDEN;

    }
}

