/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ndar.ws.accession;

import gov.nih.ndar.ws.client.Codebook;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class DataValidationProperties {
    public static String REPO_DIR = String.valueOf(System.getProperty("user.home")) + File.separator + "NDAR" + File.separator;
    private Properties connectionProps;
    private static final String PROP_GUID_USER = "property_name";
    private static final String PROP_GUID_PASSWORD = "property_name1pwd";
    private static final String PROP_GUID_PATHTOAXIS = "property_name2ptoaxis";
    private static final String PROP_GUID_URL = "property_name3ptourl";
    private String guidUser;
    private String guidPassword;
    private String pathToAxis;
    private String guidUrl;
    private Codebook useCodebook;

    public DataValidationProperties(String path) throws FileNotFoundException, IOException, NumberFormatException {
        this.connectionProps = new Properties();
        String tREPO_DIR = String.valueOf(REPO_DIR) + path;
        this.connectionProps.load(new FileInputStream(String.valueOf(tREPO_DIR) + "datavalidation.properties"));
        this.guidUser = Codebook.decrypt(this.connectionProps.getProperty(PROP_GUID_USER));
        this.guidPassword = Codebook.decrypt(this.connectionProps.getProperty(PROP_GUID_PASSWORD));
        this.pathToAxis = String.valueOf(tREPO_DIR) + "repository";
        this.guidUrl = Codebook.decrypt(this.connectionProps.getProperty(PROP_GUID_URL));
    }

    public DataValidationProperties() {
    }

    public Properties getConnectionProps() {
        return this.connectionProps;
    }

    public String getGuidUser() {
        return this.guidUser;
    }

    public void setGuidUser(String guidUser) {
        this.guidUser = guidUser;
    }

    public String getGuidPassword() {
        return this.guidPassword;
    }

    public void setGuidPassword(String guidPassword) {
        this.guidPassword = guidPassword;
    }

    public String getPathToAxis() {
        return this.pathToAxis;
    }

    public void setPathToAxis(String pathToAxis) {
        this.pathToAxis = pathToAxis;
    }

    public void setConnectionProps(Properties connectionProps) {
        this.connectionProps = connectionProps;
    }

    public String getGuidUrl() {
        return this.guidUrl;
    }

    public void setGuidUrl(String guidUrl) {
        this.guidUrl = guidUrl;
    }

    public Codebook getUseCodebook() {
        return this.useCodebook;
    }

    public void setUseCodebook(Codebook useCodebook) {
        this.useCodebook = useCodebook;
    }
}

