/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.cluster.ClusterManager;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.AxisDataLocator;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.phaseresolver.PhaseResolver;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.util.TargetResolver;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisConfiguration
extends AxisDescription {
    private static final Log log = LogFactory.getLog((Class)AxisConfiguration.class);
    private HashMap dataLocators = new HashMap();
    private HashMap dataLocatorClassNames = new HashMap();
    private final HashMap allModules = new HashMap();
    private final HashMap nameToversionMap = new HashMap();
    private final HashMap transportsIn = new HashMap();
    private final HashMap transportsOut = new HashMap();
    private final HashMap policySupportedModules = new HashMap();
    private final ArrayList localPolicyAssertions = new ArrayList();
    private ArrayList observersList = null;
    private URL axis2Repository = null;
    private HashMap allServices = new HashMap();
    private HashMap allEndpoints = new HashMap();
    private List globalModuleList;
    private final List engagedModules;
    private Hashtable faultyModules;
    private Hashtable faultyServices;
    private ArrayList inFaultPhases;
    private ArrayList inPhasesUptoAndIncludingPostDispatch;
    private HashMap messageReceivers;
    private HashMap messageBuilders;
    private HashMap messageFormatters;
    private ClassLoader moduleClassLoader;
    private HashMap moduleConfigmap = new HashMap();
    private ArrayList outFaultPhases;
    private ArrayList outPhases;
    protected PhasesInfo phasesinfo;
    private ClassLoader serviceClassLoader;
    private ClassLoader systemClassLoader;
    private boolean start;
    private ArrayList targetResolvers;
    private ClusterManager clusterManager;

    public AxisConfiguration() {
        this.engagedModules = new ArrayList();
        this.globalModuleList = new ArrayList();
        this.messageReceivers = new HashMap();
        this.messageBuilders = new HashMap();
        this.messageFormatters = new HashMap();
        this.outPhases = new ArrayList();
        this.inFaultPhases = new ArrayList();
        this.outFaultPhases = new ArrayList();
        this.faultyServices = new Hashtable();
        this.faultyModules = new Hashtable();
        this.observersList = new ArrayList();
        this.inPhasesUptoAndIncludingPostDispatch = new ArrayList();
        this.serviceClassLoader = this.systemClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        this.moduleClassLoader = this.systemClassLoader;
        this.phasesinfo = new PhasesInfo();
        this.targetResolvers = new ArrayList();
    }

    public void addMessageReceiver(String mepURL, MessageReceiver messageReceiver) {
        this.messageReceivers.put(mepURL, messageReceiver);
    }

    public void addMessageBuilder(String contentType, Builder messageBuilder) {
        this.messageBuilders.put(contentType, messageBuilder);
    }

    public void addMessageFormatter(String contentType, MessageFormatter messageFormatter) {
        this.messageFormatters.put(contentType, messageFormatter);
    }

    public void addModule(AxisModule module) throws AxisFault {
        module.setParent(this);
        this.notifyObservers(4, module);
        String moduleName = module.getName();
        if (moduleName.endsWith("SNAPSHOT")) {
            moduleName = moduleName.substring(0, moduleName.indexOf("SNAPSHOT") - 1);
            module.setName(moduleName);
            this.allModules.put(moduleName, module);
        } else {
            this.allModules.put(module.getName(), module);
        }
        this.registerModulePolicySupport(module);
        this.registerLocalPolicyAssertions(module);
    }

    public void removeModule(String module) {
        this.allModules.remove(module);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    public void addObservers(AxisObserver axisObserver) {
        this.observersList.add(axisObserver);
    }

    public synchronized void addService(AxisService service) throws AxisFault {
        AxisServiceGroup axisServiceGroup = new AxisServiceGroup();
        axisServiceGroup.setServiceGroupName(service.getName());
        axisServiceGroup.setParent(this);
        axisServiceGroup.addService(service);
        this.addServiceGroup(axisServiceGroup);
    }

    public synchronized void addServiceGroup(AxisServiceGroup axisServiceGroup) throws AxisFault {
        AxisService axisService;
        this.notifyObservers(1, axisServiceGroup);
        axisServiceGroup.setParent(this);
        Iterator services = axisServiceGroup.getServices();
        while (services.hasNext()) {
            axisService = (AxisService)services.next();
            String serviceName = axisService.getName();
            if (this.allServices.get(serviceName) != null) {
                throw new AxisFault(Messages.getMessage("twoservicecannothavesamename", axisService.getName()));
            }
            if (axisService.getSchematargetNamespace() != null) continue;
            axisService.setSchematargetNamespace("http://org.apache.axis2/xsd");
        }
        services = axisServiceGroup.getServices();
        while (services.hasNext()) {
            axisService = (AxisService)services.next();
            if (!axisService.isUseDefaultChains()) continue;
            Iterator operations = axisService.getOperations();
            while (operations.hasNext()) {
                AxisOperation operation = (AxisOperation)operations.next();
                this.phasesinfo.setOperationPhases(operation);
            }
        }
        Iterator enModule = this.engagedModules.iterator();
        while (enModule.hasNext()) {
            String moduleName = (String)enModule.next();
            axisServiceGroup.engageModule(this.getModule(moduleName), this);
        }
        services = axisServiceGroup.getServices();
        while (services.hasNext()) {
            axisService = (AxisService)services.next();
            Map endpoints = axisService.getEndpoints();
            String serviceName = axisService.getName();
            this.addToAllServicesMap(serviceName, axisService);
            if (endpoints != null) {
                Iterator endpointNameIter = endpoints.keySet().iterator();
                while (endpointNameIter.hasNext()) {
                    String endpointName = (String)endpointNameIter.next();
                    this.allEndpoints.put(serviceName + "." + endpointName, axisService);
                }
            }
            if (axisService.isClientSide()) continue;
            this.notifyObservers(1, axisService);
        }
        this.addChild(axisServiceGroup);
    }

    public void addToAllServicesMap(String serviceName, AxisService axisService) {
        this.allServices.put(serviceName, axisService);
    }

    public AxisServiceGroup removeServiceGroup(String serviceGroupName) throws AxisFault {
        AxisServiceGroup axisServiceGroup = (AxisServiceGroup)this.getChild(serviceGroupName);
        if (axisServiceGroup == null) {
            throw new AxisFault(Messages.getMessage("invalidservicegroupname", serviceGroupName));
        }
        Iterator services = axisServiceGroup.getServices();
        while (services.hasNext()) {
            AxisService axisService = (AxisService)services.next();
            this.allServices.remove(axisService.getName());
            if (axisService.isClientSide()) continue;
            this.notifyObservers(0, axisService);
        }
        this.removeChild(serviceGroupName);
        this.notifyObservers(0, axisServiceGroup);
        return axisServiceGroup;
    }

    public void addTransportIn(TransportInDescription transport) throws AxisFault {
        if (transport.getReceiver() == null) {
            throw new AxisFault("Transport Receiver can not be null for the transport " + transport.getName());
        }
        this.transportsIn.put(transport.getName(), transport);
    }

    public void addTransportOut(TransportOutDescription transport) throws AxisFault {
        if (transport.getSender() == null) {
            throw new AxisFault("Transport sender can not be null for the transport " + transport.getName());
        }
        this.transportsOut.put(transport.getName(), transport);
    }

    public void engageModule(QName moduleref) throws AxisFault {
        this.engageModule(moduleref.getLocalPart());
    }

    public void engageModule(String moduleref) throws AxisFault {
        AxisModule module = this.getModule(moduleref);
        if (module == null) {
            throw new AxisFault(Messages.getMessage("modulenotavailble", moduleref));
        }
        this.engageModule(module);
    }

    public void engageModule(String moduleName, String versionID) throws AxisFault {
        String actualName = Utils.getModuleName(moduleName, versionID);
        AxisModule module = this.getModule(actualName);
        if (module == null) {
            throw new AxisFault(Messages.getMessage("refertoinvalidmodule"));
        }
        this.engageModule(module);
    }

    public void engageModule(AxisModule axisModule, AxisConfiguration axisConfig) throws AxisFault {
        this.engageModule(axisModule);
    }

    private void engageModule(AxisModule module) throws AxisFault {
        if (module != null) {
            String moduleName = module.getName();
            Iterator iterator = this.engagedModules.iterator();
            while (iterator.hasNext()) {
                String thisModule = (String)iterator.next();
                boolean isEngagable = Utils.checkVersion(moduleName, thisModule);
                if (isEngagable) continue;
                return;
            }
        } else {
            throw new AxisFault(Messages.getMessage("refertoinvalidmodule"));
        }
        Iterator servicegroups = this.getServiceGroups();
        while (servicegroups.hasNext()) {
            AxisServiceGroup serviceGroup = (AxisServiceGroup)servicegroups.next();
            serviceGroup.engageModule(module, this);
        }
        this.engagedModules.add(module.getName());
    }

    public void disengageModule(AxisModule module) {
        if (module != null && this.isEngaged(module.getName())) {
            PhaseResolver phaseResolver = new PhaseResolver(this);
            phaseResolver.disengageModuleFromGlobalChains(module);
            Iterator serviceItr = this.getServices().values().iterator();
            while (serviceItr.hasNext()) {
                AxisService axisService = (AxisService)serviceItr.next();
                axisService.disengageModule(module);
            }
            Iterator serviceGroups = this.getServiceGroups();
            while (serviceGroups.hasNext()) {
                AxisServiceGroup axisServiceGroup = (AxisServiceGroup)serviceGroups.next();
                axisServiceGroup.removeFromEngageList(module.getName());
            }
            this.engagedModules.remove(module.getName());
        }
    }

    public void notifyObservers(int event_type, AxisService service) {
        AxisEvent event = new AxisEvent(event_type);
        for (int i = 0; i < this.observersList.size(); ++i) {
            AxisObserver axisObserver = (AxisObserver)this.observersList.get(i);
            try {
                if (service.isClientSide()) continue;
                axisObserver.serviceUpdate(event, service);
                continue;
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
    }

    public void notifyObservers(int event_type, AxisModule moule) {
        AxisEvent event = new AxisEvent(event_type);
        for (int i = 0; i < this.observersList.size(); ++i) {
            AxisObserver axisObserver = (AxisObserver)this.observersList.get(i);
            try {
                axisObserver.moduleUpdate(event, moule);
                continue;
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
    }

    public void notifyObservers(int event_type, AxisServiceGroup serviceGroup) {
        AxisEvent event = new AxisEvent(event_type);
        for (int i = 0; i < this.observersList.size(); ++i) {
            AxisObserver axisObserver = (AxisObserver)this.observersList.get(i);
            try {
                axisObserver.serviceGroupUpdate(event, serviceGroup);
                continue;
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
    }

    public synchronized void removeService(String name) throws AxisFault {
        AxisService service = (AxisService)this.allServices.remove(name);
        if (service != null) {
            AxisServiceGroup serviceGroup = (AxisServiceGroup)service.getParent();
            serviceGroup.removeService(name);
            log.debug((Object)Messages.getMessage("serviceremoved", name));
        }
    }

    public Collection getEngagedModules() {
        return this.engagedModules;
    }

    public List getGlobalModules() {
        return this.globalModuleList;
    }

    public Hashtable getFaultyModules() {
        return this.faultyModules;
    }

    public Hashtable getFaultyServices() {
        return this.faultyServices;
    }

    public void removeFaultyService(String key) {
        Iterator itr = this.faultyServices.keySet().iterator();
        while (itr.hasNext()) {
            String fullFileName = (String)itr.next();
            if (fullFileName.indexOf(key) <= 0) continue;
            this.faultyServices.remove(fullFileName);
            return;
        }
    }

    public ArrayList getGlobalOutPhases() {
        return this.outPhases;
    }

    public ArrayList getInFaultFlow() {
        return this.inFaultPhases;
    }

    public ArrayList getGlobalInFlow() {
        return this.inPhasesUptoAndIncludingPostDispatch;
    }

    public MessageReceiver getMessageReceiver(String mepURL) {
        return (MessageReceiver)this.messageReceivers.get(mepURL);
    }

    public Builder getMessageBuilder(String contentType) {
        return (Builder)this.messageBuilders.get(contentType);
    }

    public MessageFormatter getMessageFormatter(String contentType) {
        return (MessageFormatter)this.messageFormatters.get(contentType);
    }

    public AxisModule getModule(String name) {
        AxisModule module = (AxisModule)this.allModules.get(name);
        if (module != null) {
            return module;
        }
        String moduleName = name;
        String defaultModuleVersion = this.getDefaultModuleVersion(moduleName);
        if (defaultModuleVersion != null && (module = (AxisModule)this.allModules.get(Utils.getModuleName(moduleName, defaultModuleVersion))) != null) {
            return module;
        }
        return null;
    }

    public ClassLoader getModuleClassLoader() {
        return this.moduleClassLoader;
    }

    public ModuleConfiguration getModuleConfig(String moduleName) {
        return (ModuleConfiguration)this.moduleConfigmap.get(moduleName);
    }

    public HashMap getModules() {
        return this.allModules;
    }

    public ArrayList getOutFaultFlow() {
        return this.outFaultPhases;
    }

    public PhasesInfo getPhasesInfo() {
        return this.phasesinfo;
    }

    public URL getRepository() {
        return this.axis2Repository;
    }

    public AxisService getService(String name) throws AxisFault {
        AxisService axisService = (AxisService)this.allServices.get(name);
        if (axisService != null) {
            if (axisService.isActive()) {
                return axisService;
            }
            throw new AxisFault(Messages.getMessage("serviceinactive", name));
        }
        axisService = (AxisService)this.allEndpoints.get(name);
        if (axisService != null) {
            if (axisService.isActive()) {
                return axisService;
            }
            throw new AxisFault(Messages.getMessage("serviceinactive", name));
        }
        return null;
    }

    public AxisService getServiceForActivation(String serviceName) {
        AxisService axisService = (AxisService)this.allServices.get(serviceName);
        if (axisService != null) {
            return axisService;
        }
        return null;
    }

    public ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }

    public AxisServiceGroup getServiceGroup(String serviceNameAndGroupString) {
        return (AxisServiceGroup)this.getChild(serviceNameAndGroupString);
    }

    public Iterator getServiceGroups() {
        return this.getChildren();
    }

    public HashMap getServices() {
        Iterator sgs = this.getServiceGroups();
        while (sgs.hasNext()) {
            AxisServiceGroup axisServiceGroup = (AxisServiceGroup)sgs.next();
            Iterator servics = axisServiceGroup.getServices();
            while (servics.hasNext()) {
                AxisService axisService = (AxisService)servics.next();
                this.addToAllServicesMap(axisService.getName(), axisService);
            }
        }
        return this.allServices;
    }

    public ClassLoader getSystemClassLoader() {
        return this.systemClassLoader;
    }

    public TransportInDescription getTransportIn(String name) {
        return (TransportInDescription)this.transportsIn.get(name);
    }

    public TransportOutDescription getTransportOut(String name) {
        return (TransportOutDescription)this.transportsOut.get(name);
    }

    public HashMap getTransportsIn() {
        return this.transportsIn;
    }

    public HashMap getTransportsOut() {
        return this.transportsOut;
    }

    public boolean isEngaged(String moduleName) {
        boolean b = this.engagedModules.contains(moduleName);
        return b ? b : this.engagedModules.contains(this.getDefaultModule(moduleName).getName());
    }

    public void setGlobalOutPhase(ArrayList outPhases) {
        this.outPhases = outPhases;
    }

    public void setInFaultPhases(ArrayList list) {
        this.inFaultPhases = list;
    }

    public void setInPhasesUptoAndIncludingPostDispatch(ArrayList inPhasesUptoAndIncludingPostDispatch) {
        this.inPhasesUptoAndIncludingPostDispatch = inPhasesUptoAndIncludingPostDispatch;
    }

    public void setModuleClassLoader(ClassLoader classLoader) {
        this.moduleClassLoader = classLoader;
    }

    public void setOutFaultPhases(ArrayList list) {
        this.outFaultPhases = list;
    }

    public void setPhasesInfo(PhasesInfo phasesInfo) {
        this.phasesinfo = phasesInfo;
    }

    public void setRepository(URL axis2Repository) {
        this.axis2Repository = axis2Repository;
    }

    public void setServiceClassLoader(ClassLoader classLoader) {
        this.serviceClassLoader = classLoader;
    }

    public void setSystemClassLoader(ClassLoader classLoader) {
        this.systemClassLoader = classLoader;
    }

    public void addDefaultModuleVersion(String moduleName, String moduleVersion) {
        if (this.nameToversionMap.get(moduleName) == null) {
            this.nameToversionMap.put(moduleName, moduleVersion);
        }
    }

    public String getDefaultModuleVersion(String moduleName) {
        return (String)this.nameToversionMap.get(moduleName);
    }

    public AxisModule getDefaultModule(String moduleName) {
        String defaultModuleVersion = this.getDefaultModuleVersion(moduleName);
        if (defaultModuleVersion == null) {
            return (AxisModule)this.allModules.get(moduleName);
        }
        return (AxisModule)this.allModules.get(moduleName + "-" + defaultModuleVersion);
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public Object getKey() {
        return this.toString();
    }

    public void stopService(String serviceName) throws AxisFault {
        AxisService service = (AxisService)this.allServices.get(serviceName);
        if (service == null) {
            throw new AxisFault(Messages.getMessage("servicenamenotvalid", serviceName));
        }
        service.setActive(false);
        this.notifyObservers(2, service);
    }

    public void startService(String serviceName) throws AxisFault {
        AxisService service = (AxisService)this.allServices.get(serviceName);
        if (service == null) {
            throw new AxisFault(Messages.getMessage("servicenamenotvalid", serviceName));
        }
        service.setActive(true);
        this.notifyObservers(3, service);
    }

    public List getModulesForPolicyNamesapce(String namesapce) {
        return (List)this.policySupportedModules.get(namesapce);
    }

    public void registerModulePolicySupport(AxisModule axisModule) {
        String[] namespaces = axisModule.getSupportedPolicyNamespaces();
        if (namespaces == null) {
            return;
        }
        for (int i = 0; i < namespaces.length; ++i) {
            ArrayList<AxisModule> modulesList = (ArrayList<AxisModule>)this.policySupportedModules.get(namespaces[i]);
            if (modulesList != null) {
                modulesList.add(axisModule);
                continue;
            }
            modulesList = new ArrayList<AxisModule>();
            modulesList.add(axisModule);
            this.policySupportedModules.put(namespaces[i], modulesList);
        }
    }

    public void registerLocalPolicyAssertions(AxisModule axisModule) {
        QName[] localPolicyAssertions = axisModule.getLocalPolicyAssertions();
        if (localPolicyAssertions == null) {
            return;
        }
        for (int i = 0; i < localPolicyAssertions.length; ++i) {
            this.addLocalPolicyAssertion(localPolicyAssertions[i]);
        }
    }

    public ArrayList getObserversList() {
        return this.observersList;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public TargetResolver getTargetResolverChain() {
        if (this.targetResolvers.isEmpty()) {
            return null;
        }
        return new TargetResolver(){

            public void resolveTarget(MessageContext messageContext) {
                Iterator iter = AxisConfiguration.this.targetResolvers.iterator();
                while (iter.hasNext()) {
                    TargetResolver tr = (TargetResolver)iter.next();
                    tr.resolveTarget(messageContext);
                }
            }
        };
    }

    public void addTargetResolver(TargetResolver tr) {
        this.targetResolvers.add(tr);
    }

    public void addLocalPolicyAssertion(QName name) {
        this.localPolicyAssertions.add(name);
    }

    public List getLocalPolicyAssertions() {
        return this.localPolicyAssertions;
    }

    public void removeLocalPolicyAssertion(QName name) {
        this.localPolicyAssertions.remove(name);
    }

    public boolean isAssertionLocal(QName name) {
        return this.localPolicyAssertions.contains(name);
    }

    public void addDataLocatorClassNames(String dialect, String classname) {
        this.dataLocatorClassNames.put(dialect, classname);
    }

    public void addDataLocator(String dialect, AxisDataLocator dataLocator) {
        this.dataLocators.put(dialect, dataLocator);
    }

    public AxisDataLocator getDataLocator(String dialect) {
        return (AxisDataLocator)this.dataLocators.get(dialect);
    }

    public String getDataLocatorClassName(String dialect) {
        return (String)this.dataLocatorClassNames.get(dialect);
    }

    public void validateSystemPredefinedPhases() throws DeploymentException {
        PhasesInfo phasesInfo = this.getPhasesInfo();
        this.setInPhasesUptoAndIncludingPostDispatch(phasesInfo.getGlobalInflow());
        this.setInFaultPhases(phasesInfo.getGlobalInFaultPhases());
        this.setGlobalOutPhase(phasesInfo.getGlobalOutPhaseList());
        this.setOutFaultPhases(phasesInfo.getOUT_FaultPhases());
    }
}

