/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.ApplicationXMLFormatter;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.SOAPMessageFormatter;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportUtils {
    private static final Log log = LogFactory.getLog((Class)TransportUtils.class);

    public static SOAPEnvelope createSOAPMessage(MessageContext msgContext) throws AxisFault {
        try {
            InputStream inStream = (InputStream)msgContext.getProperty("TRANSPORT_IN");
            msgContext.setProperty("TRANSPORT_IN", null);
            if (inStream == null) {
                throw new AxisFault(Messages.getMessage("inputstreamNull"));
            }
            String contentType = (String)msgContext.getProperty("ContentType");
            String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
            if (charSetEnc == null && contentType != null) {
                charSetEnc = BuilderUtil.getCharSetEncoding(contentType);
            } else if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
            msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
            return TransportUtils.createSOAPMessage(msgContext, inStream, contentType);
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (OMException e) {
            throw new AxisFault(e);
        }
        catch (XMLStreamException e) {
            throw new AxisFault(e);
        }
        catch (FactoryConfigurationError e) {
            throw new AxisFault(e);
        }
    }

    public static SOAPEnvelope createSOAPMessage(MessageContext msgContext, InputStream inStream, String contentType) throws AxisFault, OMException, XMLStreamException, FactoryConfigurationError {
        SOAPEnvelope envelope;
        OMElement documentElement = null;
        String charsetEncoding = null;
        if (contentType != null) {
            Builder builder;
            int index = contentType.indexOf(59);
            String type = index > 0 ? contentType.substring(0, index) : contentType;
            if ("text/xml".equals(type)) {
                if (msgContext.isServerSide()) {
                    if (msgContext.getSoapAction() == null) {
                        type = "application/xml";
                    }
                } else if (msgContext.isDoingREST() && !JavaUtils.isTrueExplicitly(msgContext.getProperty("soapResponseMEP"))) {
                    type = "application/xml";
                }
            }
            if ((builder = BuilderUtil.getBuilderFromSelector(type, msgContext)) != null) {
                documentElement = builder.processDocument(inStream, contentType, msgContext);
            }
        }
        if (documentElement == null) {
            if (msgContext.isDoingREST()) {
                StAXBuilder builder = BuilderUtil.getPOXBuilder(inStream, charsetEncoding);
                documentElement = builder.getDocumentElement();
            } else {
                String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
                StAXBuilder builder = BuilderUtil.getSOAPBuilder(inStream, charSetEnc);
                documentElement = builder.getDocumentElement();
                charsetEncoding = builder.getDocument().getCharsetEncoding();
            }
        }
        if (documentElement instanceof SOAPEnvelope) {
            envelope = (SOAPEnvelope)documentElement;
        } else {
            SOAP11Factory soapFactory = new SOAP11Factory();
            envelope = soapFactory.getDefaultEnvelope();
            envelope.getBody().addChild((OMNode)documentElement);
        }
        return envelope;
    }

    public static String getCharSetEncoding(String contentType) {
        int index = contentType.indexOf(HTTPConstants.CHAR_SET_ENCODING);
        if (index == -1) {
            return "UTF-8";
        }
        int indexOfEq = contentType.indexOf("=", index);
        int indexOfSemiColon = contentType.indexOf(";", indexOfEq);
        String value = indexOfSemiColon > 0 ? contentType.substring(indexOfEq + 1, indexOfSemiColon) : contentType.substring(indexOfEq + 1, contentType.length()).trim();
        if (value.indexOf(34) != -1) {
            value = value.replaceAll("\"", "");
        }
        return value.trim();
    }

    public static void writeMessage(MessageContext msgContext, OutputStream out) throws AxisFault {
        SOAPEnvelope envelope;
        SOAPEnvelope outputMessage = envelope = msgContext.getEnvelope();
        if (envelope != null && msgContext.isDoingREST()) {
            outputMessage = envelope.getBody().getFirstElement();
        }
        if (outputMessage != null) {
            try {
                OMOutputFormat format = new OMOutputFormat();
                String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
                format.setDoOptimize(false);
                format.setDoingSWA(false);
                format.setCharSetEncoding(charSetEnc);
                outputMessage.serializeAndConsume(out, format);
                out.flush();
            }
            catch (Exception e) {
                throw new AxisFault(e);
            }
        } else {
            throw new AxisFault(Messages.getMessage("outMessageNull"));
        }
    }

    public static MessageFormatter getMessageFormatter(MessageContext msgContext) throws AxisFault {
        MessageFormatter messageFormatter = null;
        String messageFormatString = TransportUtils.getMessageFormatterProperty(msgContext);
        if (messageFormatString != null) {
            messageFormatter = msgContext.getConfigurationContext().getAxisConfiguration().getMessageFormatter(messageFormatString);
        }
        if (messageFormatter == null) {
            messageFormatter = msgContext.isDoingREST() ? new ApplicationXMLFormatter() : new SOAPMessageFormatter();
        }
        return messageFormatter;
    }

    private static String getSOAPNamespaceFromContentType(String contentType, String defaultSOAPNamespace) {
        String returnNS = defaultSOAPNamespace;
        if (contentType != null) {
            if (JavaUtils.indexOfIgnoreCase(contentType, "application/soap+xml") > -1) {
                returnNS = "http://www.w3.org/2003/05/soap-envelope";
            } else if (JavaUtils.indexOfIgnoreCase(contentType, "text/xml") > -1) {
                returnNS = "http://schemas.xmlsoap.org/soap/envelope/";
            }
        }
        if (returnNS == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No content-type or \"type=\" parameter was found in the content-type header and no default was specified, thus defaulting to SOAP 1.1.");
            }
            returnNS = "http://schemas.xmlsoap.org/soap/envelope/";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("content-type: " + contentType));
            log.debug((Object)("defaultSOAPNamespace: " + defaultSOAPNamespace));
            log.debug((Object)("Returned namespace: " + returnNS));
        }
        return returnNS;
    }

    public static void processContentTypeForAction(String contentType, MessageContext msgContext) {
        int index = contentType.indexOf("action");
        if (index > -1) {
            String transientString = contentType.substring(index, contentType.length());
            int equal = transientString.indexOf("=");
            int firstSemiColon = transientString.indexOf(";");
            String soapAction = firstSemiColon > -1 ? transientString.substring(equal + 1, firstSemiColon) : transientString.substring(equal + 1, transientString.length());
            if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
                soapAction = soapAction.substring(1, soapAction.length() - 1);
            }
            msgContext.setSoapAction(soapAction);
        }
    }

    private static String getMessageFormatterProperty(MessageContext msgContext) {
        Parameter parameter;
        String messageFormatterProperty = null;
        Object property = msgContext.getProperty("messageType");
        if (property != null) {
            messageFormatterProperty = (String)property;
        }
        if (messageFormatterProperty == null && (parameter = msgContext.getParameter("messageType")) != null) {
            messageFormatterProperty = (String)parameter.getValue();
        }
        return messageFormatterProperty;
    }
}

