/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.http.CommonsTransportHeaders;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHTTPSender {
    protected static final String ANONYMOUS = "anonymous";
    protected static final String PROXY_HOST_NAME = "proxy_host";
    protected static final String PROXY_PORT = "proxy_port";
    protected boolean chunked = false;
    protected String httpVersion = "HTTP/1.1";
    private static final Log log = LogFactory.getLog((Class)AbstractHTTPSender.class);
    int soTimeout = 60000;
    protected static final String PROTOCOL_HTTP = "http";
    protected static final String PROTOCOL_HTTPS = "https";
    protected TransportOutDescription proxyOutSetting = null;
    protected OMOutputFormat format = new OMOutputFormat();
    int connectionTimeout = 60000;
    protected boolean isAllowedRetry = false;

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public void setHttpVersion(String version) throws AxisFault {
        if (version != null) {
            if ("HTTP/1.1".equals(version)) {
                this.httpVersion = "HTTP/1.1";
            } else if ("HTTP/1.0".equals(version)) {
                this.httpVersion = "HTTP/1.0";
                this.chunked = false;
            } else {
                throw new AxisFault("Parameter PROTOCOL Can have values only HTTP/1.0 or HTTP/1.1");
            }
        }
    }

    protected void configProxyAuthentication(HttpClient client, TransportOutDescription proxySetting, HostConfiguration config, MessageContext msgCtx) throws AxisFault {
        HttpTransportProperties.ProxyProperties proxyProperties;
        Parameter proxyParam = proxySetting.getParameter("PROXY");
        Object proxyCred = null;
        String proxyHostName = null;
        int proxyPort = -1;
        if (proxyParam != null) {
            String value = (String)proxyParam.getValue();
            String[] split = value.split(":");
            String usrName = split[0];
            String domain = split[1];
            String passwd = split[2];
            OMElement proxyParamElement = proxyParam.getParameterElement();
            Iterator ite = proxyParamElement.getAllAttributes();
            while (ite.hasNext()) {
                OMAttribute att = (OMAttribute)ite.next();
                if (att.getLocalName().equalsIgnoreCase(PROXY_HOST_NAME)) {
                    proxyHostName = att.getAttributeValue();
                }
                if (!att.getLocalName().equalsIgnoreCase(PROXY_PORT)) continue;
                proxyPort = Integer.parseInt(att.getAttributeValue());
            }
            proxyCred = domain.length() == 0 || domain.equals(ANONYMOUS) ? (usrName.equals(ANONYMOUS) && passwd.equals(ANONYMOUS) ? new UsernamePasswordCredentials("", "") : new UsernamePasswordCredentials(usrName, passwd)) : new NTCredentials(usrName, passwd, proxyHostName, domain);
        }
        if ((proxyProperties = (HttpTransportProperties.ProxyProperties)msgCtx.getProperty("PROXY")) != null) {
            if (proxyProperties.getProxyPort() != -1) {
                proxyPort = proxyProperties.getProxyPort();
            }
            if ((proxyHostName = proxyProperties.getProxyHostName()) == null || proxyHostName.length() == 0) {
                throw new AxisFault("Proxy Name is not valid");
            }
            if (proxyProperties.getUserName().equals(ANONYMOUS) || proxyProperties.getPassWord().equals(ANONYMOUS)) {
                proxyCred = new UsernamePasswordCredentials("", "");
            }
            if (!proxyProperties.getUserName().equals(ANONYMOUS) && !proxyProperties.getPassWord().equals(ANONYMOUS)) {
                proxyCred = new UsernamePasswordCredentials(proxyProperties.getUserName().trim(), proxyProperties.getPassWord().trim());
            }
            if (!(proxyProperties.getDomain().equals(ANONYMOUS) || proxyProperties.getUserName().equals(ANONYMOUS) || proxyProperties.getPassWord().equals(ANONYMOUS) || proxyProperties.getDomain().equals(ANONYMOUS))) {
                proxyCred = new NTCredentials(proxyProperties.getUserName().trim(), proxyProperties.getPassWord().trim(), proxyHostName, proxyProperties.getDomain().trim());
            }
        }
        client.getState().setProxyCredentials(AuthScope.ANY, proxyCred);
        config.setProxy(proxyHostName, proxyPort);
    }

    protected void obtainHTTPHeaderInformation(HttpMethodBase method, MessageContext msgContext) throws AxisFault {
        HeaderElement element;
        int e;
        HeaderElement[] elements;
        int i;
        CommonsTransportHeaders transportHeaders = new CommonsTransportHeaders(method.getResponseHeaders());
        msgContext.setProperty("TRANSPORT_HEADERS", transportHeaders);
        Header header = method.getResponseHeader("Content-Type");
        if (header != null) {
            HeaderElement[] headers = header.getElements();
            MessageContext inMessageContext = msgContext.getOperationContext().getMessageContext("In");
            String contentType = header.getValue();
            String charSetEnc = null;
            for (int i2 = 0; i2 < headers.length; ++i2) {
                NameValuePair charsetEnc = headers[i2].getParameterByName(HTTPConstants.CHAR_SET_ENCODING);
                if (charsetEnc == null) continue;
                charSetEnc = charsetEnc.getValue();
            }
            if (inMessageContext != null) {
                inMessageContext.setProperty("ContentType", contentType);
                inMessageContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
            } else {
                HashMap<String, String> transportInfoMap = new HashMap<String, String>();
                transportInfoMap.put("ContentType", contentType);
                transportInfoMap.put("CHARACTER_SET_ENCODING", charSetEnc);
                msgContext.setProperty("TransportInfoMap", transportInfoMap);
            }
        }
        String sessionCookie = null;
        Header[] cookieHeaders = method.getResponseHeaders("Set-Cookie");
        for (i = 0; i < cookieHeaders.length; ++i) {
            elements = cookieHeaders[i].getElements();
            for (e = 0; e < elements.length; ++e) {
                element = elements[e];
                if (!"axis_session".equalsIgnoreCase(element.getName()) && !"JSESSIONID".equalsIgnoreCase(element.getName())) continue;
                sessionCookie = element.getValue();
            }
        }
        cookieHeaders = method.getResponseHeaders("Set-Cookie2");
        for (i = 0; i < cookieHeaders.length; ++i) {
            elements = cookieHeaders[i].getElements();
            for (e = 0; e < elements.length; ++e) {
                element = elements[e];
                if (!"axis_session".equalsIgnoreCase(element.getName()) && !"JSESSIONID".equalsIgnoreCase(element.getName())) continue;
                sessionCookie = element.getValue();
            }
        }
        if (sessionCookie != null) {
            msgContext.getServiceContext().setProperty("Cookie", sessionCookie);
        }
    }

    protected void processResponse(HttpMethodBase httpMethod, MessageContext msgContext) throws IOException {
        this.obtainHTTPHeaderInformation(httpMethod, msgContext);
        InputStream in = httpMethod.getResponseBodyAsStream();
        if (in == null) {
            throw new AxisFault(Messages.getMessage("canNotBeNull", "InputStream"));
        }
        Header contentEncoding = httpMethod.getResponseHeader("Content-Encoding");
        if (contentEncoding != null) {
            if (contentEncoding.getValue().equalsIgnoreCase("gzip")) {
                in = new GZIPInputStream(in);
            } else {
                throw new AxisFault("HTTP :unsupported content-encoding of '" + contentEncoding.getValue() + "' found");
            }
        }
        if (msgContext.getOperationContext() != null) {
            msgContext.getOperationContext().setProperty("TRANSPORT_IN", in);
        }
    }

    public abstract void send(MessageContext var1, URL var2, String var3) throws AxisFault, IOException;

    protected HostConfiguration getHostConfiguration(HttpClient client, MessageContext msgCtx, URL targetURL) throws AxisFault {
        boolean isProxyListed = this.isProxyListed(msgCtx);
        boolean isAuthenticationEnabled = this.isAuthenticationEnabled(msgCtx);
        int port = targetURL.getPort();
        String protocal = targetURL.getProtocol();
        if (port == -1) {
            if (PROTOCOL_HTTP.equals(protocal)) {
                port = 80;
            } else if (PROTOCOL_HTTPS.equals(protocal)) {
                port = 443;
            }
        }
        HostConfiguration config = new HostConfiguration();
        config.setHost(targetURL.getHost(), port, targetURL.getProtocol());
        if (isAuthenticationEnabled) {
            this.setAuthenticationInfo(client, msgCtx, config);
        }
        if (isProxyListed) {
            this.configProxyAuthentication(client, this.proxyOutSetting, config, msgCtx);
        }
        return config;
    }

    protected boolean isAuthenticationEnabled(MessageContext msgCtx) {
        return msgCtx.getProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_") != null;
    }

    protected void setAuthenticationInfo(HttpClient agent, MessageContext msgCtx, HostConfiguration config) throws AxisFault {
        Object obj = msgCtx.getProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_");
        if (obj != null) {
            if (obj instanceof HttpTransportProperties.Authenticator) {
                Object creds;
                HttpTransportProperties.Authenticator authenticator = (HttpTransportProperties.Authenticator)obj;
                String username = authenticator.getUsername();
                String password = authenticator.getPassword();
                String host = authenticator.getHost();
                String domain = authenticator.getDomain();
                int port = authenticator.getPort();
                String realm = authenticator.getRealm();
                this.isAllowedRetry = authenticator.isAllowedRetry();
                agent.getParams().setAuthenticationPreemptive(authenticator.getPreemptiveAuthentication());
                if (host != null) {
                    creds = domain != null ? new NTCredentials(username, password, host, domain) : new UsernamePasswordCredentials(username, password);
                    agent.getState().setCredentials(new AuthScope(host, port, realm), (Credentials)creds);
                } else if (domain != null) {
                    creds = new NTCredentials(username, password, AuthScope.ANY_HOST, domain);
                    agent.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, port, realm), (Credentials)creds);
                } else {
                    creds = new UsernamePasswordCredentials(username, password);
                    agent.getState().setCredentials(new AuthScope(AuthScope.ANY), (Credentials)creds);
                }
                List schemes = authenticator.getAuthSchemes();
                if (schemes != null && schemes.size() > 0) {
                    ArrayList authPrefs = new ArrayList(3);
                    for (int i = 0; i < schemes.size(); ++i) {
                        if (schemes.get(i) instanceof AuthPolicy) {
                            authPrefs.add(schemes.get(i));
                            continue;
                        }
                        String scheme = (String)schemes.get(i);
                        if ("Basic".equals(scheme)) {
                            authPrefs.add("Basic");
                            continue;
                        }
                        if ("NTLM".equals(scheme)) {
                            authPrefs.add("NTLM");
                            continue;
                        }
                        if (!"Digest".equals(scheme)) continue;
                        authPrefs.add("Digest");
                    }
                    agent.getParams().setParameter("http.auth.scheme-priority", authPrefs);
                }
            } else {
                throw new AxisFault("HttpTransportProperties.Authenticator class cast exception");
            }
        }
    }

    protected void getTimeoutValues(MessageContext msgContext) {
        try {
            Integer tempSoTimeoutProperty = (Integer)msgContext.getProperty("SO_TIMEOUT");
            Integer tempConnTimeoutProperty = (Integer)msgContext.getProperty("CONNECTION_TIMEOUT");
            if (tempSoTimeoutProperty != null) {
                this.soTimeout = tempSoTimeoutProperty;
            }
            if (tempConnTimeoutProperty != null) {
                this.connectionTimeout = tempConnTimeoutProperty;
            }
        }
        catch (NumberFormatException nfe) {
            log.error((Object)"Invalid timeout value format: not a number", (Throwable)nfe);
        }
    }

    private boolean isProxyListed(MessageContext msgCtx) throws AxisFault {
        HttpTransportProperties.ProxyProperties proxyProperties;
        boolean returnValue = false;
        Parameter par = null;
        this.proxyOutSetting = msgCtx.getConfigurationContext().getAxisConfiguration().getTransportOut(PROTOCOL_HTTP);
        if (this.proxyOutSetting != null) {
            par = this.proxyOutSetting.getParameter("PROXY");
        }
        OMElement hostElement = null;
        if (par != null) {
            hostElement = par.getParameterElement();
        }
        if (hostElement != null) {
            Iterator ite = hostElement.getAllAttributes();
            while (ite.hasNext()) {
                OMAttribute attribute = (OMAttribute)ite.next();
                if (!attribute.getLocalName().equalsIgnoreCase(PROXY_HOST_NAME)) continue;
                returnValue = true;
            }
        }
        if ((proxyProperties = (HttpTransportProperties.ProxyProperties)msgCtx.getProperty("PROXY")) != null && proxyProperties.getProxyHostName() != null) {
            returnValue = true;
        }
        return returnValue;
    }

    public void setFormat(OMOutputFormat format) {
        this.format = format;
    }

    protected HttpClient getHttpClient(MessageContext msgContext) {
        HttpClient httpClient;
        Object reuse = msgContext.getOptions().getProperty("REUSE_HTTP_CLIENT");
        if (reuse != null && JavaUtils.isTrueExplicitly(reuse)) {
            httpClient = (HttpClient)msgContext.getConfigurationContext().getProperty("CACHED_HTTP_CLIENT");
            if (httpClient == null) {
                MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
                httpClient = new HttpClient((HttpConnectionManager)connectionManager);
                msgContext.getConfigurationContext().setProperty("CACHED_HTTP_CLIENT", httpClient);
            }
        } else {
            httpClient = new HttpClient();
        }
        this.getTimeoutValues(msgContext);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(this.soTimeout);
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(this.connectionTimeout);
        return httpClient;
    }

    protected void executeMethod(HttpClient httpClient, MessageContext msgContext, URL url, HttpMethod method) throws IOException {
        HostConfiguration config = this.getHostConfiguration(httpClient, msgContext, url);
        msgContext.setProperty("HTTP_METHOD_OBJECT", method);
        this.addCustomHeaders(method, msgContext);
        if (Utils.isExplicitlyTrue(msgContext, "transport.http.acceptGzip")) {
            method.addRequestHeader("Accept-Encoding", "gzip");
        }
        if (Utils.isExplicitlyTrue(msgContext, "transport.http.gzipRequest")) {
            method.addRequestHeader("Content-Encoding", "gzip");
        }
        httpClient.executeMethod(config, method);
    }

    public void addCustomHeaders(HttpMethod method, MessageContext msgContext) {
        boolean isCustomUserAgentSet = false;
        Object httpHeadersObj = msgContext.getProperty("HTTP_HEADERS");
        if (httpHeadersObj != null && httpHeadersObj instanceof ArrayList) {
            ArrayList httpHeaders = (ArrayList)httpHeadersObj;
            for (int i = 0; i < httpHeaders.size(); ++i) {
                Header header = (Header)httpHeaders.get(i);
                if ("User-Agent".equals(header.getName())) {
                    isCustomUserAgentSet = true;
                }
                method.addRequestHeader(header);
            }
        }
        if (!isCustomUserAgentSet) {
            String userAgentString = this.getUserAgent(msgContext);
            method.setRequestHeader("User-Agent", userAgentString);
        }
    }

    private String getUserAgent(MessageContext messageContext) {
        String userAgentString = "Axis2";
        boolean locked = false;
        if (messageContext.getParameter("userAgent") != null) {
            OMElement userAgentElement = messageContext.getParameter("userAgent").getParameterElement();
            userAgentString = userAgentElement.getText().trim();
            OMAttribute lockedAttribute = userAgentElement.getAttribute(new QName("locked"));
            if (lockedAttribute != null && lockedAttribute.getAttributeValue().equalsIgnoreCase("true")) {
                locked = true;
            }
        }
        if (!locked && messageContext.getProperty("userAgent") != null) {
            userAgentString = (String)messageContext.getProperty("userAgent");
        }
        return userAgentString;
    }
}

