/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.AbstractHTTPSender;
import org.apache.axis2.transport.http.AxisRequestEntity;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class HTTPSender
extends AbstractHTTPSender {
    public void send(MessageContext msgContext, URL url, String soapActionString) throws MalformedURLException, AxisFault, IOException {
        String httpMethod = (String)msgContext.getProperty("HTTP_METHOD");
        if (httpMethod != null) {
            if ("GET".equalsIgnoreCase(httpMethod)) {
                this.sendViaGet(msgContext, url, soapActionString);
                return;
            }
            if ("DELETE".equalsIgnoreCase(httpMethod)) {
                this.sendViaDelete(msgContext, url, soapActionString);
                return;
            }
            if ("PUT".equalsIgnoreCase(httpMethod)) {
                this.sendViaPut(msgContext, url, soapActionString);
                return;
            }
        }
        this.sendViaPost(msgContext, url, soapActionString);
    }

    private void sendViaGet(MessageContext msgContext, URL url, String soapActiionString) throws AxisFault {
        GetMethod getMethod = new GetMethod();
        HttpClient httpClient = this.getHttpClient(msgContext);
        MessageFormatter messageFormatter = this.populateCommonProperties(msgContext, url, (HttpMethodBase)getMethod, httpClient, soapActiionString);
        String soapAction = messageFormatter.formatSOAPAction(msgContext, this.format, soapActiionString);
        if (soapAction != null) {
            getMethod.setRequestHeader("SOAPAction", soapAction);
        }
        try {
            this.executeMethod(httpClient, msgContext, url, (HttpMethod)getMethod);
            this.handleResponse(msgContext, (HttpMethodBase)getMethod);
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    private void sendViaDelete(MessageContext msgContext, URL url, String soapActiionString) throws AxisFault {
        DeleteMethod deleteMethod = new DeleteMethod();
        HttpClient httpClient = this.getHttpClient(msgContext);
        this.populateCommonProperties(msgContext, url, (HttpMethodBase)deleteMethod, httpClient, soapActiionString);
        try {
            this.executeMethod(httpClient, msgContext, url, (HttpMethod)deleteMethod);
            this.handleResponse(msgContext, (HttpMethodBase)deleteMethod);
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    private void sendViaPost(MessageContext msgContext, URL url, String soapActionString) throws AxisFault {
        String soapAction;
        HttpClient httpClient = this.getHttpClient(msgContext);
        String charEncoding = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
        if (charEncoding == null) {
            charEncoding = "UTF-8";
        }
        PostMethod postMethod = new PostMethod();
        MessageFormatter messageFormatter = this.populateCommonProperties(msgContext, url, (HttpMethodBase)postMethod, httpClient, soapActionString);
        postMethod.setRequestEntity((RequestEntity)new AxisRequestEntity(messageFormatter, msgContext, this.format, soapActionString, this.chunked, this.isAllowedRetry));
        if (!this.httpVersion.equals("HTTP/1.0") && this.chunked) {
            postMethod.setContentChunked(true);
        }
        if ((soapAction = messageFormatter.formatSOAPAction(msgContext, this.format, soapActionString)) != null) {
            postMethod.setRequestHeader("SOAPAction", soapAction);
        }
        try {
            this.executeMethod(httpClient, msgContext, url, (HttpMethod)postMethod);
            this.handleResponse(msgContext, (HttpMethodBase)postMethod);
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    private void sendViaPut(MessageContext msgContext, URL url, String soapActionString) throws AxisFault {
        String soapAction;
        HttpClient httpClient = this.getHttpClient(msgContext);
        String charEncoding = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
        if (charEncoding == null) {
            charEncoding = "UTF-8";
        }
        PutMethod putMethod = new PutMethod();
        MessageFormatter messageFormatter = this.populateCommonProperties(msgContext, url, (HttpMethodBase)putMethod, httpClient, soapActionString);
        putMethod.setRequestEntity((RequestEntity)new AxisRequestEntity(messageFormatter, msgContext, this.format, soapActionString, this.chunked, this.isAllowedRetry));
        if (!this.httpVersion.equals("HTTP/1.0") && this.chunked) {
            putMethod.setContentChunked(true);
        }
        if ((soapAction = messageFormatter.formatSOAPAction(msgContext, this.format, soapActionString)) != null) {
            putMethod.setRequestHeader("SOAPAction", soapAction);
        }
        try {
            this.executeMethod(httpClient, msgContext, url, (HttpMethod)putMethod);
            this.handleResponse(msgContext, (HttpMethodBase)putMethod);
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    private MessageFormatter populateCommonProperties(MessageContext msgContext, URL url, HttpMethodBase httpMethod, HttpClient httpClient, String soapActionString) throws AxisFault {
        long timeout;
        if (this.isAuthenticationEnabled(msgContext)) {
            httpMethod.setDoAuthentication(true);
        }
        MessageFormatter messageFormatter = TransportUtils.getMessageFormatter(msgContext);
        url = messageFormatter.getTargetAddress(msgContext, this.format, url);
        httpMethod.setPath(url.getPath());
        httpMethod.setQueryString(url.getQuery());
        httpMethod.setRequestHeader("Content-Type", messageFormatter.getContentType(msgContext, this.format, soapActionString));
        httpMethod.setRequestHeader("Host", url.getHost());
        Object cookieString = msgContext.getProperty("Cookie");
        if (cookieString != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("JSESSIONID");
            buffer.append("=");
            buffer.append(cookieString);
            httpMethod.setRequestHeader("Cookie", buffer.toString());
        }
        if (this.httpVersion.equals("HTTP/1.0")) {
            httpClient.getParams().setVersion(HttpVersion.HTTP_1_0);
        }
        if ((timeout = msgContext.getOptions().getTimeOutInMilliSeconds()) != 0L) {
            httpClient.getParams().setSoTimeout((int)timeout);
        }
        return messageFormatter;
    }

    private void handleResponse(MessageContext msgContext, HttpMethodBase method) throws IOException {
        if (method.getStatusCode() == 200) {
            this.processResponse(method, msgContext);
        } else if (method.getStatusCode() != 202) {
            if (method.getStatusCode() == 500) {
                Header contenttypeHeader = method.getResponseHeader("Content-Type");
                String value = null;
                if (contenttypeHeader != null) {
                    value = contenttypeHeader.getValue();
                }
                if (value != null) {
                    this.processResponse(method, msgContext);
                }
            } else {
                throw new AxisFault(Messages.getMessage("transportError", String.valueOf(method.getStatusCode()), method.getStatusText()));
            }
        }
    }
}

