/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.http.HTTPTransportReceiver;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.server.AxisHttpRequest;
import org.apache.axis2.transport.http.server.AxisHttpResponse;
import org.apache.axis2.transport.http.server.HttpUtils;
import org.apache.axis2.transport.http.server.Worker;
import org.apache.axis2.transport.http.util.RESTUtil;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EncodingUtils;
import org.apache.ws.commons.schema.XmlSchema;

public class HTTPWorker
implements Worker {
    public void service(AxisHttpRequest request, AxisHttpResponse response, MessageContext msgContext) throws HttpException, IOException {
        Handler.InvocationResponse pi;
        String contentType;
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        String servicePath = configurationContext.getServiceContextPath();
        String contextPath = (servicePath.startsWith("/") ? servicePath : "/" + servicePath) + "/";
        String uri = request.getRequestURI();
        String method = request.getMethod();
        String soapAction = HttpUtils.getSoapAction(request);
        if (method.equals("GET")) {
            int index;
            AxisService service;
            HashMap services;
            String serviceName;
            if (uri.equals("/favicon.ico")) {
                response.setStatus(301);
                response.addHeader((Header)new BasicHeader("Location", "http://ws.apache.org/favicon.ico"));
                return;
            }
            if (!uri.startsWith(contextPath)) {
                response.setStatus(301);
                response.addHeader((Header)new BasicHeader("Location", contextPath));
                return;
            }
            if (uri.endsWith("axis2/services/")) {
                String s = HTTPTransportReceiver.getServicesHTML(configurationContext);
                response.setStatus(200);
                response.setContentType("text/html");
                OutputStream out = response.getOutputStream();
                out.write(EncodingUtils.getBytes((String)s, (String)"ISO-8859-1"));
                return;
            }
            if (uri.indexOf("?") < 0 && !uri.endsWith(contextPath) && (serviceName = uri.replaceAll(contextPath, "")).indexOf("/") < 0) {
                String s = HTTPTransportReceiver.printServiceHTML(serviceName, configurationContext);
                response.setStatus(200);
                response.setContentType("text/html");
                OutputStream out = response.getOutputStream();
                out.write(EncodingUtils.getBytes((String)s, (String)"ISO-8859-1"));
                return;
            }
            if (uri.endsWith("?wsdl2")) {
                serviceName = uri.substring(uri.lastIndexOf("/") + 1, uri.length() - 6);
                services = configurationContext.getAxisConfiguration().getServices();
                service = (AxisService)services.get(serviceName);
                if (service != null) {
                    String ip = this.getHostAddress(request);
                    response.setStatus(200);
                    response.setContentType("text/xml");
                    service.printWSDL2(response.getOutputStream(), ip, servicePath);
                    return;
                }
            }
            if (uri.endsWith("?wsdl")) {
                serviceName = uri.substring(uri.lastIndexOf("/") + 1, uri.length() - 5);
                services = configurationContext.getAxisConfiguration().getServices();
                service = (AxisService)services.get(serviceName);
                if (service != null) {
                    String ip = this.getHostAddress(request);
                    response.setStatus(200);
                    response.setContentType("text/xml");
                    service.printWSDL(response.getOutputStream(), ip, servicePath);
                    return;
                }
            }
            if (uri.endsWith("?xsd")) {
                serviceName = uri.substring(uri.lastIndexOf("/") + 1, uri.length() - 4);
                services = configurationContext.getAxisConfiguration().getServices();
                service = (AxisService)services.get(serviceName);
                if (service != null) {
                    response.setStatus(200);
                    response.setContentType("text/xml");
                    service.printSchema(response.getOutputStream());
                    return;
                }
            }
            if (uri.indexOf("?xsd=") > 0) {
                serviceName = uri.substring(uri.lastIndexOf("/") + 1, uri.lastIndexOf("?xsd="));
                String schemaName = uri.substring(uri.lastIndexOf("=") + 1);
                HashMap services2 = configurationContext.getAxisConfiguration().getServices();
                AxisService service2 = (AxisService)services2.get(serviceName);
                if (service2 != null) {
                    service2.populateSchemaMappings();
                    Map schemaTable = service2.getSchemaMappingTable();
                    XmlSchema schema = (XmlSchema)schemaTable.get(schemaName);
                    if (schema != null) {
                        response.setStatus(200);
                        response.setContentType("text/xml");
                        schema.write(response.getOutputStream());
                        return;
                    }
                    InputStream instream = service2.getClassLoader().getResourceAsStream("META-INF/" + schemaName);
                    if (instream != null) {
                        response.setStatus(200);
                        response.setContentType("text/xml");
                        OutputStream outstream = response.getOutputStream();
                        boolean checkLength = true;
                        int length = Integer.MAX_VALUE;
                        int nextValue = instream.read();
                        if (checkLength) {
                            --length;
                        }
                        while (-1 != nextValue && length >= 0) {
                            outstream.write(nextValue);
                            nextValue = instream.read();
                            if (!checkLength) continue;
                            --length;
                        }
                        outstream.flush();
                        return;
                    }
                    response.sendError(404, "Schema Not Found!");
                    return;
                }
            }
            contentType = null;
            Header[] headers = request.getHeaders("Content-Type");
            if (headers != null && headers.length > 0 && (index = (contentType = headers[0].getValue()).indexOf(59)) > 0) {
                contentType = contentType.substring(0, index);
            }
            pi = RESTUtil.processURLRequest(msgContext, response.getOutputStream(), contentType);
        } else if (method.equals("POST")) {
            contentType = request.getContentType();
            if (HTTPTransportUtils.isRESTRequest(contentType)) {
                pi = RESTUtil.processXMLRequest(msgContext, request.getInputStream(), response.getOutputStream(), contentType);
            } else {
                String ip = (String)msgContext.getProperty("TRANSPORT_ADDR");
                if (ip != null) {
                    uri = ip + uri;
                }
                pi = HTTPTransportUtils.processHTTPPostRequest(msgContext, request.getInputStream(), response.getOutputStream(), contentType, soapAction, uri);
            }
        } else if (method.equals("PUT")) {
            contentType = request.getContentType();
            msgContext.setProperty("ContentType", contentType);
            pi = RESTUtil.processXMLRequest(msgContext, request.getInputStream(), response.getOutputStream(), contentType);
        } else if (method.equals("DELETE")) {
            pi = RESTUtil.processURLRequest(msgContext, response.getOutputStream(), null);
        } else {
            throw new MethodNotSupportedException(method + " method not supported");
        }
        Boolean holdResponse = (Boolean)msgContext.getProperty("HoldResponse");
        if (pi.equals(Handler.InvocationResponse.SUSPEND) || holdResponse != null && Boolean.TRUE.equals(holdResponse)) {
            try {
                ((RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl")).awaitResponse();
            }
            catch (InterruptedException e) {
                throw new IOException("We were interrupted, so this may not function correctly:" + e.getMessage());
            }
        }
        OperationContext operationContext = msgContext.getOperationContext();
        Object contextWritten = null;
        Object isTwoChannel = null;
        if (operationContext != null) {
            contextWritten = operationContext.getProperty("CONTENT_WRITTEN");
            isTwoChannel = operationContext.getProperty("DIFFERENT_EPR");
        }
        if (contextWritten != null && "true".equals(contextWritten)) {
            if (isTwoChannel != null && "true".equals(isTwoChannel)) {
                response.setStatus(202);
            }
        } else {
            response.setStatus(202);
        }
    }

    public String getHostAddress(AxisHttpRequest request) throws SocketException {
        try {
            Header hostHeader = request.getFirstHeader("host");
            if (hostHeader != null) {
                String host = hostHeader.getValue();
                return new URI("http://" + host).getHost();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return HttpUtils.getIpAddress();
    }
}

