/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.tcp;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.server.HttpUtils;
import org.apache.axis2.transport.tcp.TCPWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TCPServer
implements Runnable,
TransportListener {
    private int port = 8000;
    private boolean started = false;
    private static final Log log = LogFactory.getLog((Class)TCPServer.class);
    private ConfigurationContext configContext;
    private ServerSocket serversocket;
    private String hostAddress = null;
    private String contextPath;

    public TCPServer() {
    }

    public TCPServer(int port, ConfigurationContext configContext) throws AxisFault {
        try {
            this.configContext = configContext;
            this.serversocket = new ServerSocket(port);
            ListenerManager listenerManager = configContext.getListenerManager();
            TransportInDescription trsIn = new TransportInDescription("tcp");
            trsIn.setReceiver(this);
            if (listenerManager == null) {
                listenerManager = new ListenerManager();
                listenerManager.init(configContext);
            }
            listenerManager.addListener(trsIn, true);
            this.contextPath = configContext.getServiceContextPath();
        }
        catch (IOException e1) {
            throw new AxisFault(e1);
        }
    }

    public TCPServer(int port, String dir) throws AxisFault {
        this(port, ConfigurationContextFactory.createConfigurationContextFromFileSystem(dir, null));
    }

    public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) throws AxisFault {
        this.configContext = axisConf;
        Parameter param = transprtIn.getParameter("port");
        if (param != null) {
            this.port = Integer.parseInt((String)param.getValue());
        }
        if ((param = transprtIn.getParameter("hostname")) != null) {
            this.hostAddress = ((String)param.getValue()).trim();
        }
        this.contextPath = this.configContext.getServiceContextPath();
    }

    public static void main(String[] args) throws AxisFault, NumberFormatException {
        if (args.length != 2) {
            System.out.println("TCPServer repositoryLocation port");
        } else {
            File repository = new File(args[0]);
            if (!repository.exists()) {
                System.out.print("Repository file does not exists .. initializing repository");
            }
            TCPServer tcpServer = new TCPServer(Integer.parseInt(args[1]), repository.getAbsolutePath());
            System.out.println("[Axis2] Using the Repository " + repository.getAbsolutePath());
            System.out.println("[Axis2] Starting the TCP Server on port " + args[1]);
            tcpServer.start();
            Runtime.getRuntime().addShutdownHook(new Thread(tcpServer));
        }
    }

    public void run() {
        while (this.started) {
            Socket socket = null;
            try {
                socket = this.serversocket.accept();
            }
            catch (InterruptedIOException iie) {
            }
            catch (Exception e) {
                log.debug((Object)e);
                break;
            }
            if (socket == null) continue;
            this.configContext.getThreadPool().execute(new TCPWorker(this.configContext, socket));
        }
    }

    public synchronized void start() throws AxisFault {
        if (this.serversocket == null) {
            this.serversocket = this.openSocket(this.port);
        }
        this.started = true;
        this.configContext.getThreadPool().execute(this);
    }

    public ServerSocket openSocket(int port) throws AxisFault {
        for (int i = 0; i < 5; ++i) {
            try {
                return new ServerSocket(port + i);
            }
            catch (IOException iOException) {
                continue;
            }
        }
        throw new AxisFault(Messages.getMessage("failedToOpenSocket"));
    }

    public void stop() throws AxisFault {
        try {
            this.serversocket.close();
            this.started = false;
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configContext;
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        EndpointReference[] epRsForService = this.getEPRsForService(serviceName, ip);
        return epRsForService != null ? epRsForService[0] : null;
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        if (this.hostAddress != null) {
            if (this.serversocket != null) {
                return new EndpointReference[]{new EndpointReference(this.hostAddress + "/" + this.contextPath + serviceName)};
            }
            log.debug((Object)"Unable to generate EPR for the transport tcp");
            return null;
        }
        if (ip == null) {
            try {
                ip = HttpUtils.getIpAddress();
            }
            catch (SocketException e) {
                throw AxisFault.makeFault(e);
            }
        }
        if (this.serversocket != null) {
            return new EndpointReference[]{new EndpointReference("tcp://" + ip + ":" + this.serversocket.getLocalPort() + "/" + this.contextPath + "/" + serviceName)};
        }
        log.debug((Object)"Unable to generate EPR for the transport tcp");
        return null;
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    public void destroy() {
        this.configContext = null;
    }
}

