/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;

public class ExternalPolicySerializer {
    private List assertions2Filter = new ArrayList();

    public void addAssertionToFilter(QName name) {
        this.assertions2Filter.add(name);
    }

    public void setAssertionsToFilter(List assertions2Filter) {
        this.assertions2Filter = assertions2Filter;
    }

    public List getAssertionsToFilter() {
        return this.assertions2Filter;
    }

    public void serialize(Policy policy, OutputStream os) {
        try {
            String id;
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(os);
            policy = (Policy)policy.normalize(false);
            String prefix = writer.getPrefix("wsp");
            String wsuPrefix = writer.getPrefix("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            if (prefix == null) {
                prefix = "wsp";
                writer.setPrefix(prefix, "http://schemas.xmlsoap.org/ws/2004/09/policy");
            }
            if (wsuPrefix == null) {
                wsuPrefix = "wsu";
                writer.setPrefix(wsuPrefix, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            }
            writer.writeStartElement(prefix, "Policy", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            writer.writeNamespace(prefix, "http://schemas.xmlsoap.org/ws/2004/09/policy");
            String name = policy.getName();
            if (name != null) {
                writer.writeAttribute("Name", name);
            }
            if ((id = policy.getId()) != null) {
                writer.writeAttribute("Id", id);
            }
            writer.writeStartElement("wsp", "ExactlyOne", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            Iterator iterator = policy.getAlternatives();
            while (iterator.hasNext()) {
                List assertionList = (List)iterator.next();
                writer.writeStartElement("wsp", "All", "http://schemas.xmlsoap.org/ws/2004/09/policy");
                Iterator assertions = assertionList.iterator();
                while (assertions.hasNext()) {
                    Assertion assertion = (Assertion)assertions.next();
                    if (this.assertions2Filter.contains(assertion.getName())) continue;
                    assertion.serialize(writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.flush();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

