/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.util.AxisPolicyLocator;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.axis2.util.XMLUtils;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.apache.woden.internal.util.dom.DOM2Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PolicyUtil {
    public static String getSafeString(String unsafeString) {
        StringBuffer sbuf = new StringBuffer();
        char[] chars = unsafeString.toCharArray();
        block6: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\\': {
                    sbuf.append('\\');
                    sbuf.append('\\');
                    continue block6;
                }
                case '\"': {
                    sbuf.append('\\');
                    sbuf.append('\"');
                    continue block6;
                }
                case '\n': {
                    sbuf.append('\\');
                    sbuf.append('n');
                    continue block6;
                }
                case '\r': {
                    sbuf.append('\\');
                    sbuf.append('r');
                    continue block6;
                }
                default: {
                    sbuf.append(c);
                }
            }
        }
        return sbuf.toString();
    }

    public static OMElement getPolicyComponentAsOMElement(PolicyComponent policyComponent, ExternalPolicySerializer externalPolicySerializer) throws XMLStreamException, FactoryConfigurationError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (policyComponent instanceof Policy) {
            externalPolicySerializer.serialize((Policy)policyComponent, baos);
        } else {
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
            policyComponent.serialize(writer);
            writer.flush();
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return (OMElement)XMLUtils.toOM(bais);
    }

    public static OMElement getPolicyComponentAsOMElement(PolicyComponent component) throws XMLStreamException, FactoryConfigurationError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
        component.serialize(writer);
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return (OMElement)XMLUtils.toOM(bais);
    }

    public static PolicyComponent getPolicyComponentFromOMElement(OMElement policyComponent) throws IllegalArgumentException {
        if (policyComponent instanceof Policy) {
            return PolicyEngine.getPolicy((OMElement)policyComponent);
        }
        if (policyComponent instanceof PolicyReference) {
            return PolicyEngine.getPolicyReference((OMElement)policyComponent);
        }
        throw new IllegalArgumentException("Agrument is neither a <wsp:Policy> nor a <wsp:PolicyReference> element");
    }

    public static PolicyComponent getPolicyComponent(Element element) {
        if ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(element.getNamespaceURI())) {
            if ("Policy".equals(element.getLocalName())) {
                String xmlString = DOM2Writer.nodeToString((Node)element);
                ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
                return PolicyEngine.getPolicy((InputStream)bais);
            }
            if ("PolicyReference".equals(element.getLocalName())) {
                String xmlString = DOM2Writer.nodeToString((Node)element);
                ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
                return PolicyEngine.getPolicyReferene((InputStream)bais);
            }
        }
        throw new IllegalArgumentException("Agrument is neither a <wsp:Policy> nor a <wsp:PolicyReference> element");
    }

    public static String policyComponentToString(PolicyComponent policyComponent) throws XMLStreamException, FactoryConfigurationError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
        policyComponent.serialize(writer);
        writer.flush();
        return baos.toString();
    }

    public static String generateId(AxisDescription description) {
        PolicyInclude policyInclude = description.getPolicyInclude();
        String identifier = "-policy-1";
        if (description instanceof AxisMessage) {
            identifier = "msg-" + ((AxisMessage)description).getName() + identifier;
            description = description.getParent();
        }
        if (description instanceof AxisOperation) {
            identifier = "op-" + ((AxisOperation)description).getName() + identifier;
            description = description.getParent();
        }
        if (description instanceof AxisService) {
            identifier = "service-" + ((AxisService)description).getName() + identifier;
        }
        int index = 49;
        while (policyInclude.getPolicy(identifier) != null) {
            identifier = identifier.replace((char)index, (char)(index + 1));
            ++index;
        }
        return identifier;
    }

    public static Policy getMergedPolicy(List policies, AxisDescription description) {
        Policy policy = null;
        Iterator iterator = policies.iterator();
        while (iterator.hasNext()) {
            Object policyElement = iterator.next();
            if (policyElement instanceof Policy) {
                policy = policy == null ? (Policy)policyElement : policy.merge((Policy)policyElement);
                continue;
            }
            PolicyReference policyReference = (PolicyReference)policyElement;
            Policy policy2 = (Policy)policyReference.normalize((PolicyRegistry)new AxisPolicyLocator(description), false);
            policy = policy == null ? policy2 : policy.merge(policy2);
        }
        if (policy != null) {
            policy = (Policy)policy.normalize((PolicyRegistry)new AxisPolicyLocator(description), false);
        }
        return policy;
    }
}

