/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudformation.model.StackStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListStacksRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String nextToken;
    private ListWithAutoConstructFlag<String> stackStatusFilters;

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListStacksRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public List<String> getStackStatusFilters() {
        if (this.stackStatusFilters == null) {
            this.stackStatusFilters = new ListWithAutoConstructFlag();
            this.stackStatusFilters.setAutoConstruct(true);
        }
        return this.stackStatusFilters;
    }

    public void setStackStatusFilters(Collection<String> stackStatusFilters) {
        if (stackStatusFilters == null) {
            this.stackStatusFilters = null;
            return;
        }
        ListWithAutoConstructFlag stackStatusFiltersCopy = new ListWithAutoConstructFlag(stackStatusFilters.size());
        stackStatusFiltersCopy.addAll(stackStatusFilters);
        this.stackStatusFilters = stackStatusFiltersCopy;
    }

    public ListStacksRequest withStackStatusFilters(String ... stackStatusFilters) {
        if (this.getStackStatusFilters() == null) {
            this.setStackStatusFilters(new ArrayList<String>(stackStatusFilters.length));
        }
        for (String value : stackStatusFilters) {
            this.getStackStatusFilters().add(value);
        }
        return this;
    }

    public ListStacksRequest withStackStatusFilters(Collection<String> stackStatusFilters) {
        if (stackStatusFilters == null) {
            this.stackStatusFilters = null;
        } else {
            ListWithAutoConstructFlag stackStatusFiltersCopy = new ListWithAutoConstructFlag(stackStatusFilters.size());
            stackStatusFiltersCopy.addAll(stackStatusFilters);
            this.stackStatusFilters = stackStatusFiltersCopy;
        }
        return this;
    }

    public ListStacksRequest withStackStatusFilters(StackStatus ... stackStatusFilters) {
        ArrayList<String> stackStatusFiltersCopy = new ArrayList<String>(stackStatusFilters.length);
        for (StackStatus member : stackStatusFilters) {
            stackStatusFiltersCopy.add(member.toString());
        }
        if (this.getStackStatusFilters() == null) {
            this.setStackStatusFilters(stackStatusFiltersCopy);
        } else {
            this.getStackStatusFilters().addAll(stackStatusFiltersCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getStackStatusFilters() != null) {
            sb.append("StackStatusFilters: " + this.getStackStatusFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getStackStatusFilters() == null ? 0 : this.getStackStatusFilters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStacksRequest)) {
            return false;
        }
        ListStacksRequest other = (ListStacksRequest)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getStackStatusFilters() == null ^ this.getStackStatusFilters() == null) {
            return false;
        }
        return other.getStackStatusFilters() == null || other.getStackStatusFilters().equals(this.getStackStatusFilters());
    }

    @Override
    public ListStacksRequest clone() {
        return (ListStacksRequest)super.clone();
    }
}

