/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.codedeploy.model.RegistrationStatus;
import com.amazonaws.services.codedeploy.model.TagFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListOnPremisesInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String registrationStatus;
    private ListWithAutoConstructFlag<TagFilter> tagFilters;
    private String nextToken;

    public String getRegistrationStatus() {
        return this.registrationStatus;
    }

    public void setRegistrationStatus(String registrationStatus) {
        this.registrationStatus = registrationStatus;
    }

    public ListOnPremisesInstancesRequest withRegistrationStatus(String registrationStatus) {
        this.registrationStatus = registrationStatus;
        return this;
    }

    public void setRegistrationStatus(RegistrationStatus registrationStatus) {
        this.registrationStatus = registrationStatus.toString();
    }

    public ListOnPremisesInstancesRequest withRegistrationStatus(RegistrationStatus registrationStatus) {
        this.registrationStatus = registrationStatus.toString();
        return this;
    }

    public List<TagFilter> getTagFilters() {
        if (this.tagFilters == null) {
            this.tagFilters = new ListWithAutoConstructFlag();
            this.tagFilters.setAutoConstruct(true);
        }
        return this.tagFilters;
    }

    public void setTagFilters(Collection<TagFilter> tagFilters) {
        if (tagFilters == null) {
            this.tagFilters = null;
            return;
        }
        ListWithAutoConstructFlag tagFiltersCopy = new ListWithAutoConstructFlag(tagFilters.size());
        tagFiltersCopy.addAll(tagFilters);
        this.tagFilters = tagFiltersCopy;
    }

    public ListOnPremisesInstancesRequest withTagFilters(TagFilter ... tagFilters) {
        if (this.getTagFilters() == null) {
            this.setTagFilters(new ArrayList<TagFilter>(tagFilters.length));
        }
        for (TagFilter value : tagFilters) {
            this.getTagFilters().add(value);
        }
        return this;
    }

    public ListOnPremisesInstancesRequest withTagFilters(Collection<TagFilter> tagFilters) {
        if (tagFilters == null) {
            this.tagFilters = null;
        } else {
            ListWithAutoConstructFlag tagFiltersCopy = new ListWithAutoConstructFlag(tagFilters.size());
            tagFiltersCopy.addAll(tagFilters);
            this.tagFilters = tagFiltersCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListOnPremisesInstancesRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRegistrationStatus() != null) {
            sb.append("RegistrationStatus: " + this.getRegistrationStatus() + ",");
        }
        if (this.getTagFilters() != null) {
            sb.append("TagFilters: " + this.getTagFilters() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRegistrationStatus() == null ? 0 : this.getRegistrationStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTagFilters() == null ? 0 : this.getTagFilters().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOnPremisesInstancesRequest)) {
            return false;
        }
        ListOnPremisesInstancesRequest other = (ListOnPremisesInstancesRequest)obj;
        if (other.getRegistrationStatus() == null ^ this.getRegistrationStatus() == null) {
            return false;
        }
        if (other.getRegistrationStatus() != null && !other.getRegistrationStatus().equals(this.getRegistrationStatus())) {
            return false;
        }
        if (other.getTagFilters() == null ^ this.getTagFilters() == null) {
            return false;
        }
        if (other.getTagFilters() != null && !other.getTagFilters().equals(this.getTagFilters())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    @Override
    public ListOnPremisesInstancesRequest clone() {
        return (ListOnPremisesInstancesRequest)super.clone();
    }
}

