/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.ClassicLinkInstance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeClassicLinkInstancesResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<ClassicLinkInstance> instances;
    private String nextToken;

    public List<ClassicLinkInstance> getInstances() {
        if (this.instances == null) {
            this.instances = new ListWithAutoConstructFlag();
            this.instances.setAutoConstruct(true);
        }
        return this.instances;
    }

    public void setInstances(Collection<ClassicLinkInstance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        ListWithAutoConstructFlag instancesCopy = new ListWithAutoConstructFlag(instances.size());
        instancesCopy.addAll(instances);
        this.instances = instancesCopy;
    }

    public DescribeClassicLinkInstancesResult withInstances(ClassicLinkInstance ... instances) {
        if (this.getInstances() == null) {
            this.setInstances(new ArrayList<ClassicLinkInstance>(instances.length));
        }
        for (ClassicLinkInstance value : instances) {
            this.getInstances().add(value);
        }
        return this;
    }

    public DescribeClassicLinkInstancesResult withInstances(Collection<ClassicLinkInstance> instances) {
        if (instances == null) {
            this.instances = null;
        } else {
            ListWithAutoConstructFlag instancesCopy = new ListWithAutoConstructFlag(instances.size());
            instancesCopy.addAll(instances);
            this.instances = instancesCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeClassicLinkInstancesResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstances() != null) {
            sb.append("Instances: " + this.getInstances() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClassicLinkInstancesResult)) {
            return false;
        }
        DescribeClassicLinkInstancesResult other = (DescribeClassicLinkInstancesResult)obj;
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public DescribeClassicLinkInstancesResult clone() {
        try {
            return (DescribeClassicLinkInstancesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

