/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.Resource;
import com.amazonaws.services.ecs.model.VersionInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RegisterContainerInstanceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private String instanceIdentityDocument;
    private String instanceIdentityDocumentSignature;
    private ListWithAutoConstructFlag<Resource> totalResources;
    private VersionInfo versionInfo;

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public RegisterContainerInstanceRequest withCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    public String getInstanceIdentityDocument() {
        return this.instanceIdentityDocument;
    }

    public void setInstanceIdentityDocument(String instanceIdentityDocument) {
        this.instanceIdentityDocument = instanceIdentityDocument;
    }

    public RegisterContainerInstanceRequest withInstanceIdentityDocument(String instanceIdentityDocument) {
        this.instanceIdentityDocument = instanceIdentityDocument;
        return this;
    }

    public String getInstanceIdentityDocumentSignature() {
        return this.instanceIdentityDocumentSignature;
    }

    public void setInstanceIdentityDocumentSignature(String instanceIdentityDocumentSignature) {
        this.instanceIdentityDocumentSignature = instanceIdentityDocumentSignature;
    }

    public RegisterContainerInstanceRequest withInstanceIdentityDocumentSignature(String instanceIdentityDocumentSignature) {
        this.instanceIdentityDocumentSignature = instanceIdentityDocumentSignature;
        return this;
    }

    public List<Resource> getTotalResources() {
        if (this.totalResources == null) {
            this.totalResources = new ListWithAutoConstructFlag();
            this.totalResources.setAutoConstruct(true);
        }
        return this.totalResources;
    }

    public void setTotalResources(Collection<Resource> totalResources) {
        if (totalResources == null) {
            this.totalResources = null;
            return;
        }
        ListWithAutoConstructFlag totalResourcesCopy = new ListWithAutoConstructFlag(totalResources.size());
        totalResourcesCopy.addAll(totalResources);
        this.totalResources = totalResourcesCopy;
    }

    public RegisterContainerInstanceRequest withTotalResources(Resource ... totalResources) {
        if (this.getTotalResources() == null) {
            this.setTotalResources(new ArrayList<Resource>(totalResources.length));
        }
        for (Resource value : totalResources) {
            this.getTotalResources().add(value);
        }
        return this;
    }

    public RegisterContainerInstanceRequest withTotalResources(Collection<Resource> totalResources) {
        if (totalResources == null) {
            this.totalResources = null;
        } else {
            ListWithAutoConstructFlag totalResourcesCopy = new ListWithAutoConstructFlag(totalResources.size());
            totalResourcesCopy.addAll(totalResources);
            this.totalResources = totalResourcesCopy;
        }
        return this;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    public RegisterContainerInstanceRequest withVersionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: " + this.getCluster() + ",");
        }
        if (this.getInstanceIdentityDocument() != null) {
            sb.append("InstanceIdentityDocument: " + this.getInstanceIdentityDocument() + ",");
        }
        if (this.getInstanceIdentityDocumentSignature() != null) {
            sb.append("InstanceIdentityDocumentSignature: " + this.getInstanceIdentityDocumentSignature() + ",");
        }
        if (this.getTotalResources() != null) {
            sb.append("TotalResources: " + this.getTotalResources() + ",");
        }
        if (this.getVersionInfo() != null) {
            sb.append("VersionInfo: " + this.getVersionInfo());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceIdentityDocument() == null ? 0 : this.getInstanceIdentityDocument().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceIdentityDocumentSignature() == null ? 0 : this.getInstanceIdentityDocumentSignature().hashCode());
        hashCode = 31 * hashCode + (this.getTotalResources() == null ? 0 : this.getTotalResources().hashCode());
        hashCode = 31 * hashCode + (this.getVersionInfo() == null ? 0 : this.getVersionInfo().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterContainerInstanceRequest)) {
            return false;
        }
        RegisterContainerInstanceRequest other = (RegisterContainerInstanceRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getInstanceIdentityDocument() == null ^ this.getInstanceIdentityDocument() == null) {
            return false;
        }
        if (other.getInstanceIdentityDocument() != null && !other.getInstanceIdentityDocument().equals(this.getInstanceIdentityDocument())) {
            return false;
        }
        if (other.getInstanceIdentityDocumentSignature() == null ^ this.getInstanceIdentityDocumentSignature() == null) {
            return false;
        }
        if (other.getInstanceIdentityDocumentSignature() != null && !other.getInstanceIdentityDocumentSignature().equals(this.getInstanceIdentityDocumentSignature())) {
            return false;
        }
        if (other.getTotalResources() == null ^ this.getTotalResources() == null) {
            return false;
        }
        if (other.getTotalResources() != null && !other.getTotalResources().equals(this.getTotalResources())) {
            return false;
        }
        if (other.getVersionInfo() == null ^ this.getVersionInfo() == null) {
            return false;
        }
        return other.getVersionInfo() == null || other.getVersionInfo().equals(this.getVersionInfo());
    }

    @Override
    public RegisterContainerInstanceRequest clone() {
        return (RegisterContainerInstanceRequest)super.clone();
    }
}

