/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport.model.transform;

import com.amazonaws.services.importexport.model.Artifact;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ArtifactStaxUnmarshaller
implements Unmarshaller<Artifact, StaxUnmarshallerContext> {
    private static ArtifactStaxUnmarshaller instance;

    @Override
    public Artifact unmarshall(StaxUnmarshallerContext context) throws Exception {
        Artifact artifact = new Artifact();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return artifact;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Description", targetDepth)) {
                    artifact.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("URL", targetDepth)) continue;
                artifact.setURL(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return artifact;
    }

    public static ArtifactStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ArtifactStaxUnmarshaller();
        }
        return instance;
    }
}

