/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.invoke;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.invoke.LambdaFunction;
import com.amazonaws.services.lambda.invoke.LambdaFunctionError;
import com.amazonaws.services.lambda.invoke.LambdaFunctionException;
import com.amazonaws.services.lambda.invoke.LambdaSerializationException;
import com.amazonaws.services.lambda.model.InvocationType;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import com.amazonaws.services.lambda.model.LogType;
import com.amazonaws.util.Base64;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LambdaInvokerFactory {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static <T> T build(Class<T> interfaceClass, AWSLambda awsLambda) {
        Object proxy = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new LambdaInvocationHandler(interfaceClass, awsLambda));
        return interfaceClass.cast(proxy);
    }

    private LambdaInvokerFactory() {
    }

    private static class LambdaInvocationHandler
    implements InvocationHandler {
        private final AWSLambda awsLambda;
        private final Log log;

        public LambdaInvocationHandler(Class<?> interfaceClass, AWSLambda awsLambda) {
            this.awsLambda = awsLambda;
            this.log = LogFactory.getLog(interfaceClass);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            LambdaFunction annotation = this.validateInterfaceMethod(method, args);
            InvokeRequest invokeRequest = this.buildInvokeRequest(method, annotation, args == null ? null : args[0]);
            InvokeResult invokeResult = this.awsLambda.invoke(invokeRequest);
            return this.processInvokeResult(method, invokeResult);
        }

        private LambdaFunction validateInterfaceMethod(Method method, Object[] args) {
            LambdaFunction annotation = method.getAnnotation(LambdaFunction.class);
            if (annotation == null) {
                throw new LambdaSerializationException("No LambdaFunction annotation for method " + method.getName());
            }
            if (annotation.invocationType() != InvocationType.RequestResponse && annotation.logType() != LogType.None) {
                throw new LambdaSerializationException("InvocationType must be RequestResponse if LogType is set");
            }
            if (args != null && args.length > 1) {
                throw new LambdaSerializationException("LambdaFunctions take either 0 or 1 arguments");
            }
            return annotation;
        }

        private InvokeRequest buildInvokeRequest(Method method, LambdaFunction annotation, Object input) {
            InvokeRequest invokeRequest = new InvokeRequest();
            String functionName = annotation.functionName();
            if (functionName.isEmpty()) {
                functionName = method.getName();
            }
            invokeRequest.setFunctionName(functionName);
            invokeRequest.setInvocationType(annotation.invocationType());
            invokeRequest.setLogType(annotation.logType());
            if (input != null) {
                try {
                    String payload = MAPPER.writer().writeValueAsString(input);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Serialized request object to '" + payload + "'"));
                    }
                    invokeRequest.setPayload(payload);
                }
                catch (JsonProcessingException ex) {
                    throw new LambdaSerializationException("Failed to serialize request object to JSON", ex);
                }
            }
            return invokeRequest;
        }

        private Object processInvokeResult(Method method, InvokeResult invokeResult) throws Throwable {
            String functionError;
            if (invokeResult.getLogResult() != null && this.log.isInfoEnabled()) {
                try {
                    String decoded = new String(Base64.decode(invokeResult.getLogResult()), StringUtils.UTF8);
                    this.log.info((Object)(method.getName() + " log:\n\t" + decoded.replaceAll("\n", "\n\t")));
                }
                catch (Exception ex) {
                    this.log.warn((Object)("Error decoding log result '" + invokeResult.getLogResult() + "'"), (Throwable)ex);
                }
            }
            if ((functionError = invokeResult.getFunctionError()) == null) {
                return this.getObjectFromPayload(method, invokeResult);
            }
            throw this.getExceptionFromPayload(method, invokeResult);
        }

        private Object getObjectFromPayload(Method method, InvokeResult invokeResult) {
            try {
                return this.getObjectFromPayload(method.getGenericReturnType(), invokeResult.getPayload());
            }
            catch (IOException ex) {
                throw new LambdaSerializationException("Failed to parse Lambda function result", ex);
            }
        }

        private Throwable getExceptionFromPayload(Method method, InvokeResult invokeResult) {
            Throwable throwable = null;
            String message = "Unexpected error executing Lambda function";
            String type = null;
            List<String> stackTrace = null;
            try {
                LambdaFunctionError error = this.getObjectFromPayload(LambdaFunctionError.class, invokeResult.getPayload());
                if (error != null) {
                    message = error.getErrorMessage();
                    type = error.getErrorType();
                    stackTrace = error.getStackTrace();
                    throwable = this.getCustomException(method, error);
                }
            }
            catch (Exception ex) {
                this.log.warn((Object)"Error parsing exception information from response payload", (Throwable)ex);
            }
            if (throwable == null) {
                throwable = new LambdaFunctionException(message, "Handled".equals(invokeResult.getFunctionError()), type);
            }
            if (stackTrace != null) {
                this.fillStackTrace(throwable, stackTrace, method.getDeclaringClass());
            }
            return throwable;
        }

        private Throwable getCustomException(Method method, LambdaFunctionError error) {
            String type = error.getErrorType();
            Constructor<?> constructor = null;
            if (type != null) {
                Class<?> exceptionType;
                Class<?>[] arr$ = method.getExceptionTypes();
                int len$ = arr$.length;
                for (int i$ = 0; !(i$ >= len$ || (exceptionType = arr$[i$]).getSimpleName().startsWith(type) && (constructor = this.findConstructor(exceptionType)) != null); ++i$) {
                }
            }
            if (constructor != null) {
                try {
                    return (Throwable)constructor.newInstance(error.getErrorMessage());
                }
                catch (Exception ex) {
                    this.log.warn((Object)"Error constructing custom exception", (Throwable)ex);
                }
            }
            return null;
        }

        private Constructor<?> findConstructor(Class<?> type) {
            for (Constructor<?> constructor : type.getConstructors()) {
                Class<?>[] params = constructor.getParameterTypes();
                if (params == null || params.length != 1 || !String.class.equals(params[0])) continue;
                return constructor;
            }
            return null;
        }

        private void fillStackTrace(Throwable throwable, List<String> stackTrace, Class<?> interfaceClass) {
            StackTraceElement[] elements = new StackTraceElement[stackTrace.size()];
            for (int i = 0; i < stackTrace.size(); ++i) {
                elements[i] = new StackTraceElement(interfaceClass.getName(), stackTrace.get(i).trim(), null, 0);
            }
            throwable.setStackTrace(elements);
        }

        private <T> T getObjectFromPayload(Class<T> type, ByteBuffer payload) throws IOException {
            return type.cast(this.getObjectFromPayload((Type)type, payload));
        }

        private Object getObjectFromPayload(Type type, ByteBuffer payload) throws IOException {
            if (type == Void.TYPE || payload.remaining() == 0) {
                return null;
            }
            JavaType javaType = MAPPER.getTypeFactory().constructType(type);
            return MAPPER.reader(javaType).readValue(BinaryUtils.copyAllBytesFrom(payload));
        }
    }
}

