/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.logs.model.TestMetricFilterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class TestMetricFilterRequestMarshaller
implements Marshaller<Request<TestMetricFilterRequest>, TestMetricFilterRequest> {
    @Override
    public Request<TestMetricFilterRequest> marshall(TestMetricFilterRequest testMetricFilterRequest) {
        if (testMetricFilterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TestMetricFilterRequest> request = new DefaultRequest<TestMetricFilterRequest>(testMetricFilterRequest, "AWSLogs");
        String target = "Logs_20140328.TestMetricFilter";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag logEventMessagesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (testMetricFilterRequest.getFilterPattern() != null) {
                jsonWriter.key("filterPattern").value(testMetricFilterRequest.getFilterPattern());
            }
            if (!((logEventMessagesList = (ListWithAutoConstructFlag)testMetricFilterRequest.getLogEventMessages()) == null || logEventMessagesList.isAutoConstruct() && logEventMessagesList.isEmpty())) {
                jsonWriter.key("logEventMessages");
                jsonWriter.array();
                for (String logEventMessagesListValue : logEventMessagesList) {
                    if (logEventMessagesListValue == null) continue;
                    jsonWriter.value(logEventMessagesListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

