/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.AssignInstanceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class AssignInstanceRequestMarshaller
implements Marshaller<Request<AssignInstanceRequest>, AssignInstanceRequest> {
    @Override
    public Request<AssignInstanceRequest> marshall(AssignInstanceRequest assignInstanceRequest) {
        if (assignInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AssignInstanceRequest> request = new DefaultRequest<AssignInstanceRequest>(assignInstanceRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.AssignInstance";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag layerIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (assignInstanceRequest.getInstanceId() != null) {
                jsonWriter.key("InstanceId").value(assignInstanceRequest.getInstanceId());
            }
            if (!((layerIdsList = (ListWithAutoConstructFlag)assignInstanceRequest.getLayerIds()) == null || layerIdsList.isAutoConstruct() && layerIdsList.isEmpty())) {
                jsonWriter.key("LayerIds");
                jsonWriter.array();
                for (String layerIdsListValue : layerIdsList) {
                    if (layerIdsListValue == null) continue;
                    jsonWriter.value(layerIdsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

