/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.redshift.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateClusterSubnetGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clusterSubnetGroupName;
    private String description;
    private ListWithAutoConstructFlag<String> subnetIds;
    private ListWithAutoConstructFlag<Tag> tags;

    public String getClusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public void setClusterSubnetGroupName(String clusterSubnetGroupName) {
        this.clusterSubnetGroupName = clusterSubnetGroupName;
    }

    public CreateClusterSubnetGroupRequest withClusterSubnetGroupName(String clusterSubnetGroupName) {
        this.clusterSubnetGroupName = clusterSubnetGroupName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateClusterSubnetGroupRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<String> getSubnetIds() {
        if (this.subnetIds == null) {
            this.subnetIds = new ListWithAutoConstructFlag();
            this.subnetIds.setAutoConstruct(true);
        }
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        ListWithAutoConstructFlag subnetIdsCopy = new ListWithAutoConstructFlag(subnetIds.size());
        subnetIdsCopy.addAll(subnetIds);
        this.subnetIds = subnetIdsCopy;
    }

    public CreateClusterSubnetGroupRequest withSubnetIds(String ... subnetIds) {
        if (this.getSubnetIds() == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String value : subnetIds) {
            this.getSubnetIds().add(value);
        }
        return this;
    }

    public CreateClusterSubnetGroupRequest withSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
        } else {
            ListWithAutoConstructFlag subnetIdsCopy = new ListWithAutoConstructFlag(subnetIds.size());
            subnetIdsCopy.addAll(subnetIds);
            this.subnetIds = subnetIdsCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public CreateClusterSubnetGroupRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public CreateClusterSubnetGroupRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterSubnetGroupName() != null) {
            sb.append("ClusterSubnetGroupName: " + this.getClusterSubnetGroupName() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: " + this.getSubnetIds() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterSubnetGroupName() == null ? 0 : this.getClusterSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterSubnetGroupRequest)) {
            return false;
        }
        CreateClusterSubnetGroupRequest other = (CreateClusterSubnetGroupRequest)obj;
        if (other.getClusterSubnetGroupName() == null ^ this.getClusterSubnetGroupName() == null) {
            return false;
        }
        if (other.getClusterSubnetGroupName() != null && !other.getClusterSubnetGroupName().equals(this.getClusterSubnetGroupName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    @Override
    public CreateClusterSubnetGroupRequest clone() {
        return (CreateClusterSubnetGroupRequest)super.clone();
    }
}

