/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationDescription;
import com.amazonaws.services.simplesystemsmanagement.model.FailedCreateAssociation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateAssociationBatchResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<AssociationDescription> successful;
    private ListWithAutoConstructFlag<FailedCreateAssociation> failed;

    public List<AssociationDescription> getSuccessful() {
        if (this.successful == null) {
            this.successful = new ListWithAutoConstructFlag();
            this.successful.setAutoConstruct(true);
        }
        return this.successful;
    }

    public void setSuccessful(Collection<AssociationDescription> successful) {
        if (successful == null) {
            this.successful = null;
            return;
        }
        ListWithAutoConstructFlag successfulCopy = new ListWithAutoConstructFlag(successful.size());
        successfulCopy.addAll(successful);
        this.successful = successfulCopy;
    }

    public CreateAssociationBatchResult withSuccessful(AssociationDescription ... successful) {
        if (this.getSuccessful() == null) {
            this.setSuccessful(new ArrayList<AssociationDescription>(successful.length));
        }
        for (AssociationDescription value : successful) {
            this.getSuccessful().add(value);
        }
        return this;
    }

    public CreateAssociationBatchResult withSuccessful(Collection<AssociationDescription> successful) {
        if (successful == null) {
            this.successful = null;
        } else {
            ListWithAutoConstructFlag successfulCopy = new ListWithAutoConstructFlag(successful.size());
            successfulCopy.addAll(successful);
            this.successful = successfulCopy;
        }
        return this;
    }

    public List<FailedCreateAssociation> getFailed() {
        if (this.failed == null) {
            this.failed = new ListWithAutoConstructFlag();
            this.failed.setAutoConstruct(true);
        }
        return this.failed;
    }

    public void setFailed(Collection<FailedCreateAssociation> failed) {
        if (failed == null) {
            this.failed = null;
            return;
        }
        ListWithAutoConstructFlag failedCopy = new ListWithAutoConstructFlag(failed.size());
        failedCopy.addAll(failed);
        this.failed = failedCopy;
    }

    public CreateAssociationBatchResult withFailed(FailedCreateAssociation ... failed) {
        if (this.getFailed() == null) {
            this.setFailed(new ArrayList<FailedCreateAssociation>(failed.length));
        }
        for (FailedCreateAssociation value : failed) {
            this.getFailed().add(value);
        }
        return this;
    }

    public CreateAssociationBatchResult withFailed(Collection<FailedCreateAssociation> failed) {
        if (failed == null) {
            this.failed = null;
        } else {
            ListWithAutoConstructFlag failedCopy = new ListWithAutoConstructFlag(failed.size());
            failedCopy.addAll(failed);
            this.failed = failedCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSuccessful() != null) {
            sb.append("Successful: " + this.getSuccessful() + ",");
        }
        if (this.getFailed() != null) {
            sb.append("Failed: " + this.getFailed());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSuccessful() == null ? 0 : this.getSuccessful().hashCode());
        hashCode = 31 * hashCode + (this.getFailed() == null ? 0 : this.getFailed().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssociationBatchResult)) {
            return false;
        }
        CreateAssociationBatchResult other = (CreateAssociationBatchResult)obj;
        if (other.getSuccessful() == null ^ this.getSuccessful() == null) {
            return false;
        }
        if (other.getSuccessful() != null && !other.getSuccessful().equals(this.getSuccessful())) {
            return false;
        }
        if (other.getFailed() == null ^ this.getFailed() == null) {
            return false;
        }
        return other.getFailed() == null || other.getFailed().equals(this.getFailed());
    }

    public CreateAssociationBatchResult clone() {
        try {
            return (CreateAssociationBatchResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

