/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.core;

import com.amazonaws.services.simpleworkflow.flow.core.AsyncContextBase;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncParentContext;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncStackTrace;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import java.util.concurrent.Executor;

class TaskContext
extends AsyncContextBase
implements AsyncParentContext {
    private final Task task;
    private boolean canceled;
    private final String parentTaskMethodName;
    private final boolean hideStartFromMethod;

    public TaskContext(Task task, Boolean daemon, Promise<?>[] waitFor) {
        super(daemon, waitFor, 7);
        this.task = task;
        this.parentTaskMethodName = null;
        this.hideStartFromMethod = false;
    }

    public TaskContext(AsyncParentContext parent, Task task, Boolean daemon, Promise<?>[] waitFor) {
        super(parent, daemon, waitFor, 5);
        this.task = task;
        this.parentTaskMethodName = null;
        this.hideStartFromMethod = false;
    }

    public TaskContext(AsyncParentContext parent, Task task, Boolean daemon, String parentTaskMethodName, boolean hideParentTaskMethodName, int skipStackLines, Promise<?>[] waitFor) {
        super(parent, daemon, waitFor, skipStackLines);
        this.task = task;
        this.parentTaskMethodName = parentTaskMethodName;
        this.hideStartFromMethod = hideParentTaskMethodName;
    }

    public TaskContext(Task task, Boolean daemon, String parentTaskMethodName, boolean hideParentTaskMethodName, int skipStackLines, Promise<?>[] waitFor) {
        super(daemon, waitFor, skipStackLines);
        this.task = task;
        this.parentTaskMethodName = parentTaskMethodName;
        this.hideStartFromMethod = hideParentTaskMethodName;
    }

    @Override
    public void cancel(Throwable cause) {
        this.canceled = true;
        this.parent.remove(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.canceled) {
            return;
        }
        TaskContext.setCurrent(this);
        try {
            this.task.doExecute();
            this.parent.remove(this);
        }
        catch (Throwable e) {
            if (this.stackTrace != null && !this.parent.isRethrown(e)) {
                AsyncStackTrace merged = new AsyncStackTrace(this.stackTrace, e.getStackTrace(), 0);
                merged.setStartFrom(this.getParentTaskMethodName());
                merged.setHideStartFromMethod(this.hideStartFromMethod);
                e.setStackTrace(merged.getStackTrace());
            }
            this.parent.fail(this, e);
        }
        finally {
            TaskContext.setCurrent(null);
        }
    }

    @Override
    public void add(AsyncContextBase async, Promise<?> waitFor) {
        this.parent.add(async, waitFor);
    }

    @Override
    public void remove(AsyncContextBase async) {
        this.parent.remove(async);
    }

    @Override
    public void fail(AsyncContextBase async, Throwable e) {
        this.parent.fail(async, e);
    }

    @Override
    public Executor getExecutor() {
        return this.parent.getExecutor();
    }

    @Override
    public boolean isRethrown(Throwable e) {
        return this.parent.isRethrown(e);
    }

    @Override
    public AsyncParentContext getCurrentTryCatchFinallyContext() {
        return this.parent;
    }

    @Override
    public boolean getDaemonFlagForHeir() {
        return this.isDaemon();
    }

    @Override
    public String getParentTaskMethodName() {
        return this.parentTaskMethodName == null ? "doExecute" : this.parentTaskMethodName;
    }

    @Override
    public boolean getHideStartFromMethod() {
        return this.hideStartFromMethod;
    }

    public String toString() {
        if (this.stackTrace != null) {
            return this.stackTrace.toString();
        }
        return super.toString();
    }
}

