/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.interceptors;

import com.amazonaws.services.simpleworkflow.flow.DecisionException;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class RetryPolicyBase
implements RetryPolicy {
    private List<Class<? extends Throwable>> exceptionsToRetry;
    private List<Class<? extends Throwable>> exceptionsToExclude;

    public List<Class<? extends Throwable>> getExceptionsToRetry() {
        if (this.exceptionsToRetry == null) {
            this.exceptionsToRetry = new ArrayList<Class<? extends Throwable>>();
            this.exceptionsToRetry.add(Throwable.class);
        }
        return this.exceptionsToRetry;
    }

    public void setExceptionsToRetry(List<Class<? extends Throwable>> exceptionsToRetry) {
        ArrayList<Class<? extends Throwable>> exceptionsToRetryCopy = new ArrayList<Class<? extends Throwable>>();
        if (exceptionsToRetry != null) {
            exceptionsToRetryCopy.addAll(exceptionsToRetry);
        }
        this.exceptionsToRetry = exceptionsToRetryCopy;
    }

    public RetryPolicyBase withExceptionsToRetry(Collection<Class<? extends Throwable>> exceptionsToRetry) {
        ArrayList<Class<? extends Throwable>> exceptionsToRetryCopy = new ArrayList<Class<? extends Throwable>>();
        if (exceptionsToRetry != null) {
            exceptionsToRetryCopy.addAll(exceptionsToRetry);
        }
        this.exceptionsToRetry = exceptionsToRetryCopy;
        return this;
    }

    public List<Class<? extends Throwable>> getExceptionsToExclude() {
        if (this.exceptionsToExclude == null) {
            this.exceptionsToExclude = new ArrayList<Class<? extends Throwable>>();
        }
        return this.exceptionsToExclude;
    }

    public void setExceptionsToExclude(List<Class<? extends Throwable>> exceptionsToExclude) {
        ArrayList<Class<? extends Throwable>> exceptionsToExcludeCopy = new ArrayList<Class<? extends Throwable>>();
        if (exceptionsToExclude != null) {
            exceptionsToExcludeCopy.addAll(exceptionsToExclude);
        }
        this.exceptionsToExclude = exceptionsToExcludeCopy;
    }

    public RetryPolicyBase withExceptionsToExclude(Collection<Class<? extends Throwable>> exceptionsToExclude) {
        ArrayList<Class<? extends Throwable>> exceptionsToExcludeCopy = new ArrayList<Class<? extends Throwable>>();
        if (exceptionsToExclude != null) {
            exceptionsToExcludeCopy.addAll(exceptionsToExclude);
        }
        this.exceptionsToExclude = exceptionsToExcludeCopy;
        return this;
    }

    @Override
    public boolean isRetryable(Throwable failure) {
        boolean isRetryable = false;
        if (failure instanceof DecisionException && failure.getCause() != null) {
            failure = failure.getCause();
        }
        for (Class<? extends Throwable> exceptionToRetry : this.getExceptionsToRetry()) {
            if (!exceptionToRetry.isAssignableFrom(failure.getClass())) continue;
            isRetryable = true;
            break;
        }
        if (isRetryable) {
            for (Class<? extends Throwable> exceptionNotToRetry : this.getExceptionsToExclude()) {
                if (!exceptionNotToRetry.isAssignableFrom(failure.getClass())) continue;
                isRetryable = false;
                break;
            }
        }
        return isRetryable;
    }
}

