/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.storagegateway.model.GatewayInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListGatewaysResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<GatewayInfo> gateways;
    private String marker;

    public List<GatewayInfo> getGateways() {
        if (this.gateways == null) {
            this.gateways = new ListWithAutoConstructFlag();
            this.gateways.setAutoConstruct(true);
        }
        return this.gateways;
    }

    public void setGateways(Collection<GatewayInfo> gateways) {
        if (gateways == null) {
            this.gateways = null;
            return;
        }
        ListWithAutoConstructFlag gatewaysCopy = new ListWithAutoConstructFlag(gateways.size());
        gatewaysCopy.addAll(gateways);
        this.gateways = gatewaysCopy;
    }

    public ListGatewaysResult withGateways(GatewayInfo ... gateways) {
        if (this.getGateways() == null) {
            this.setGateways(new ArrayList<GatewayInfo>(gateways.length));
        }
        for (GatewayInfo value : gateways) {
            this.getGateways().add(value);
        }
        return this;
    }

    public ListGatewaysResult withGateways(Collection<GatewayInfo> gateways) {
        if (gateways == null) {
            this.gateways = null;
        } else {
            ListWithAutoConstructFlag gatewaysCopy = new ListWithAutoConstructFlag(gateways.size());
            gatewaysCopy.addAll(gateways);
            this.gateways = gatewaysCopy;
        }
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListGatewaysResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGateways() != null) {
            sb.append("Gateways: " + this.getGateways() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGateways() == null ? 0 : this.getGateways().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGatewaysResult)) {
            return false;
        }
        ListGatewaysResult other = (ListGatewaysResult)obj;
        if (other.getGateways() == null ^ this.getGateways() == null) {
            return false;
        }
        if (other.getGateways() != null && !other.getGateways().equals(this.getGateways())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public ListGatewaysResult clone() {
        try {
            return (ListGatewaysResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

