/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ndar.model.transfer.dictionary;

import gov.nih.ndar.model.abstraction.dictionary.IDataElement;
import gov.nih.ndar.model.abstraction.dictionary.IDataStructure;
import gov.nih.ndar.model.transfer.dictionary.XmlDataDictionary;
import gov.nih.ndar.model.transfer.dictionary.XmlDataStructure;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class XmlDataDictionaryExporter {
    private JAXBContext jaxContext;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public XmlDataDictionaryExporter() throws IOException {
        try {
            this.jaxContext = JAXBContext.newInstance((Class[])new Class[]{XmlDataDictionary.class});
            this.marshaller = this.jaxContext.createMarshaller();
            this.unmarshaller = this.jaxContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    public void writeDataDictionaryXML(XmlDataDictionary dd, OutputStream outputStream) throws IOException {
        try {
            this.marshaller.marshal((Object)dd, outputStream);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    public void writeDataDictionaryTAB(XmlDataDictionary dictionary, File folder) throws Exception {
        if (!folder.isDirectory()) {
            throw new Exception("A Directory must be provided for DataDictionary Export");
        }
        for (IDataStructure ds : dictionary.getDataStructure()) {
            File file = new File(folder.getCanonicalPath() + File.separator + ds.getShortName() + ".txt");
            this.writeDataStructureTAB((XmlDataStructure)ds, file);
        }
    }

    public void writeDataStructureTAB(XmlDataStructure ds, File file) throws IOException {
        System.out.println();
        System.out.println(file.getCanonicalPath());
        FileWriter fp = new FileWriter(file);
        fp.write("elementName\t");
        fp.write("elementDescription\t");
        fp.write("Size\t");
        fp.write("Unit\t");
        fp.write("ValueRange\t");
        fp.write("Keywords\t");
        fp.write("Aliases\t");
        fp.write("Notes\t");
        fp.write("shortDescription\t");
        fp.write("DataType\t");
        fp.write("Required\t");
        fp.write("Condition\t");
        fp.write("Section\t");
        fp.write("Position\t");
        fp.write("testData\n");
        for (IDataElement de : ds.getDataElements()) {
            fp.write(this.format(de.getName()) + "\t");
            fp.write(this.format(de.getDescription()) + "\t");
            fp.write(this.format(de.getSize()) + "\t");
            fp.write(this.format(de.getUnitString()) + "\t");
            fp.write(this.format(de.getValueRange()) + "\t");
            fp.write(this.format(de.getKeywordList()) + "\t");
            fp.write(this.format(de.getAliasList()) + "\t");
            fp.write(this.format(de.getNotes()) + "\t");
            fp.write(this.format(de.getShortDescription()) + "\t");
            fp.write(this.format(de.getTypeString()) + "\t");
            fp.write(this.format(de.getRequired()) + "\t");
            fp.write(this.format(de.getRequiredCondition()) + "\t");
            fp.write(this.format(de.getSection()) + "\t");
            fp.write(this.format(de.getPosition()) + "\t");
            fp.write(this.format(de.getTestData()) + "\n");
        }
        fp.close();
    }

    private Object format(Object o) {
        if (o instanceof List) {
            String ret = "";
            List lis = (List)o;
            for (Object obj : lis) {
                if (obj == null) continue;
                ret = ret + obj + ", ";
            }
            if (ret.contains(",")) {
                ret = ret.substring(0, ret.lastIndexOf(","));
            }
            return ret;
        }
        if (o != null) {
            return o;
        }
        return "";
    }
}

