/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.OutputManager;
import imaging.AnalyzeHeader;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;
import tractography.CP_StatMap;
import tractography.MaxCP;
import tractography.MeanCP;
import tractography.MedianCP;
import tractography.MinCP;
import tractography.SumCP;

public class CP_Stats {
    private static Logger logger = Logger.getLogger("camino.apps.CP_Stats");
    private static int volume = 0;
    private static boolean volumePerPD = true;
    private static String suffix = "";

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        String string = "";
        String string2 = OutputManager.outputFile;
        String string3 = "";
        int n = 1;
        int n2 = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-inputroot")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-operation")) {
                string3 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-pd")) {
                n = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-outputroot")) {
                string2 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (!stringArray[i].equals("-targetindex")) continue;
            n2 = Integer.parseInt(stringArray[i + 1]);
            suffix = "_" + n2;
            CL_Initializer.markAsParsed(i, 2);
        }
        if (string.equals("") && CL_Initializer.inputFile != null) {
            logger.warning("input root not specified, using argument of -inputfile option as input root");
            string = CL_Initializer.inputFile;
        }
        try {
            if (new File(string + "0.hdr").exists()) {
                volumePerPD = false;
            } else if (new File(string + "1.hdr").exists()) {
                volume = 1;
                volumePerPD = false;
            } else if (new File(string + "1_1.hdr").exists()) {
                volume = 1;
                volumePerPD = true;
            } else {
                volume = 1;
                volumePerPD = true;
                String string4 = CP_Stats.getVolumeFileRoot(string, volume, 1);
                if (!new File(string4 + ".hdr").exists()) {
                    throw new LoggedException("Cannot find connection probability files matching input root");
                }
            }
            String string5 = CP_Stats.getVolumeFileRoot(string, volume, 1);
            String string6 = CP_Stats.getVolumeFileRoot(string, volume, n);
            AnalyzeHeader analyzeHeader = AnalyzeHeader.readHeader(string5 + ".hdr");
            analyzeHeader.setGzip(OutputManager.gzipOut);
            int n3 = analyzeHeader.xDataDim();
            int n4 = analyzeHeader.yDataDim();
            int n5 = analyzeHeader.zDataDim();
            CP_StatMap cP_StatMap = null;
            if (string3.equals("min")) {
                cP_StatMap = new MinCP(n3, n4, n5);
            } else if (string3.equals("max")) {
                cP_StatMap = new MaxCP(n3, n4, n5);
            } else if (string3.equals("mean")) {
                cP_StatMap = new MeanCP(n3, n4, n5);
            } else if (string3.equals("median")) {
                cP_StatMap = new MedianCP(n3, n4, n5);
            } else if (string3.equals("sum")) {
                cP_StatMap = new SumCP(n3, n4, n5);
            }
            while (new File(string5 + ".hdr").exists()) {
                if (new File(string6 + ".hdr").exists()) {
                    AnalyzeHeader analyzeHeader2 = AnalyzeHeader.readHeader(string6 + ".hdr");
                    double[][][] dArray = analyzeHeader2.readSingleVolumeData();
                    cP_StatMap.addImage(dArray);
                }
                string6 = CP_Stats.getVolumeFileRoot(string, ++volume, n);
                string5 = CP_Stats.getVolumeFileRoot(string, volume, 1);
            }
            if (!volumePerPD) {
                if (string2 == null) {
                    string2 = string3 + "cp";
                }
                analyzeHeader.writeScalarImage(cP_StatMap.result(), OutputManager.outputFile);
            } else {
                if (string2 == null) {
                    string2 = string3 + "cp_1";
                }
                analyzeHeader.writeScalarImage(cP_StatMap.result(), OutputManager.outputFile);
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    private static String getVolumeFileRoot(String string, int n, int n2) {
        if (volumePerPD) {
            String string2 = string + n + "_" + n2 + suffix;
            return string2;
        }
        String string3 = string + n;
        return string3;
    }
}

