/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import apps.FracAnis;
import apps.ModelFit;
import data.OutputManager;
import java.util.logging.Logger;
import misc.DT;
import misc.LoggedException;
import tools.CL_Initializer;

public class DT_EigenSystem
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.DT_EigenSystem");

    public DT_EigenSystem(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputModel = new String("dt");
        CL_Initializer.inputDataType = new String("double");
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initTensorDataSource();
    }

    @Override
    public void initVariables() {
    }

    @Override
    public void execute(OutputManager outputManager) {
        while (CL_Initializer.data.more()) {
            boolean bl;
            double[] dArray = CL_Initializer.data.nextVoxel();
            DT[] dTArray = FracAnis.getTensorList(dArray, CL_Initializer.inputModel);
            boolean bl2 = bl = !ModelFit.isBG(Math.exp(dArray[1]));
            if (dArray[0] >= 0.0 && bl) {
                for (int i = 0; i < dTArray.length; ++i) {
                    double[] dArray2;
                    try {
                        double[][] dArray3 = dTArray[i].sortedEigenSystem();
                        dArray2 = new double[12];
                        for (int j = 0; j < 3; ++j) {
                            for (int k = 0; k < 4; ++k) {
                                dArray2[4 * j + k] = dArray3[k][j];
                            }
                        }
                        outputManager.output(dArray2);
                        continue;
                    }
                    catch (Exception exception) {
                        LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
                        dArray2 = new double[12];
                        outputManager.output(dArray2);
                    }
                }
                continue;
            }
            outputManager.output(new double[dTArray.length * 12]);
        }
        outputManager.close();
    }
}

