/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import data.VoxelOrderDataSource;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;

public class DT_ShapeStatistics
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.DT_ShapeStatistics");
    int maxComponents;
    VoxelOrderDataSource input;
    String statistic;
    String stat;

    public DT_ShapeStatistics(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.stat = " ";
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.maxTensorComponents = 1;
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-stat")) continue;
            this.stat = stringArray[i + 1];
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
        this.maxComponents = CL_Initializer.maxTensorComponents;
        this.input = new VoxelOrderDataSource(CL_Initializer.inputFile, 12, CL_Initializer.inputDataType);
        this.statistic = this.stat;
    }

    @Override
    public void execute(OutputManager outputManager) {
        while (this.input.more()) {
            double[] dArray = this.input.nextVoxel();
            double d = DT_ShapeStatistics.computeStat(dArray, this.statistic);
            outputManager.output(new double[]{d});
        }
        outputManager.close();
    }

    public static final double computeStat(double[] dArray, String string) {
        double d = 0.0;
        if (string.equals("cl")) {
            d = (dArray[0] - dArray[4]) / dArray[0];
        } else if (string.equals("cp")) {
            d = (dArray[4] - dArray[8]) / dArray[0];
        } else if (string.equals("cs")) {
            d = dArray[8] / dArray[0];
        } else if (string.equals("l1")) {
            d = dArray[0];
        } else if (string.equals("l2")) {
            d = dArray[4];
        } else if (string.equals("l3")) {
            d = dArray[8];
        } else if (string.equals("tr")) {
            d = dArray[0] + dArray[4] + dArray[8];
        } else if (string.equals("md")) {
            d = (dArray[0] + dArray[4] + dArray[8]) / 3.0;
        } else if (string.equals("rd")) {
            d = (dArray[4] + dArray[8]) / 2.0;
        } else if (string.equals("fa")) {
            double d2 = (dArray[0] + dArray[4] + dArray[8]) / 3.0;
            d = d2 > 0.0 ? Math.sqrt(1.5 * ((dArray[0] - d2) * (dArray[0] - d2) + (dArray[4] - d2) * (dArray[4] - d2) + (dArray[8] - d2) * (dArray[8] - d2)) / (dArray[0] * dArray[0] + dArray[4] * dArray[4] + dArray[8] * dArray[8])) : 0.0;
        } else if (string.equals("ra")) {
            double d3 = (dArray[0] + dArray[4] + dArray[8]) / 3.0;
            d = d3 > 0.0 ? Math.sqrt(0.3333333333333333 * ((dArray[0] - d3) * (dArray[0] - d3) + (dArray[4] - d3) * (dArray[4] - d3) + (dArray[8] - d3) * (dArray[8] - d3))) / d3 : 0.0;
        } else if (string.equals("2dfa")) {
            double d4 = (dArray[4] + dArray[8]) / 2.0;
            d = d4 > 0.0 ? Math.sqrt(2.0 * ((dArray[4] - d4) * (dArray[4] - d4) + (dArray[8] - d4) * (dArray[8] - d4)) / (dArray[4] * dArray[4] + dArray[8] * dArray[8])) : 0.0;
        } else {
            throw new LoggedException("unrecognized statistic " + string);
        }
        return d;
    }
}

