/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import imaging.ImageHeader;
import tools.CL_Initializer;

public class DT_ToImage
extends Executable {
    private ImageHeader header;
    private int xDataDim;
    private int yDataDim;
    private int zDataDim;
    private static String outputRoot = "camino_";
    private static String headerFile = null;

    public DT_ToImage(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.xDataDim = 0;
        this.yDataDim = 0;
        this.zDataDim = 0;
        this.header = null;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputDataType = "double";
        OutputManager.outputDataType = "float";
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-outputroot")) continue;
            outputRoot = stringArray[i + 1];
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.inputModel = "dt";
        CL_Initializer.initTensorDataSource();
        CL_Initializer.initInputSpaceAndHeaderOptions();
        this.header = CL_Initializer.headerTemplate;
        this.xDataDim = this.header.xDataDim();
        this.yDataDim = this.header.yDataDim();
        this.zDataDim = this.header.zDataDim();
    }

    @Override
    public void initVariables() {
    }

    @Override
    public void execute(OutputManager outputManager) {
        double[][][][] dArray = new double[this.xDataDim][this.yDataDim][this.zDataDim][6];
        double[][][] dArray2 = new double[this.xDataDim][this.yDataDim][this.zDataDim];
        double[][][] dArray3 = new double[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    double[] dArray4 = CL_Initializer.data.nextVoxel();
                    dArray2[k][j][i] = dArray4[0];
                    dArray3[k][j][i] = dArray4[1];
                    System.arraycopy(dArray4, 2, dArray[k][j][i], 0, 6);
                }
            }
        }
        String string = outputRoot + "dt";
        this.header.writeTensorImage(dArray, string);
        String string2 = outputRoot + "exitcode";
        this.header.writeScalarImage(dArray2, string2);
        String string3 = outputRoot + "lns0";
        this.header.writeScalarImage(dArray3, string3);
    }
}

