/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.DataSource;
import data.OutputManager;
import imaging.DW_Scheme;
import imaging.ImageHeader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import misc.LoggedException;
import tools.ArrayOps;
import tools.CL_Initializer;

public class EstimateSNR
extends Executable {
    DataSource bgROI_Source;
    int[] b0Indices;
    DW_Scheme scheme;
    int numMeas;

    public EstimateSNR(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.bgROI_Source = null;
        this.b0Indices = null;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputDataType = "float";
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-noiseroi")) {
                try {
                    this.bgROI_Source = ImageHeader.readHeader(stringArray[i + 1]).getImageDataSource();
                }
                catch (IOException iOException) {
                    throw new LoggedException("Cannot read background ROI " + stringArray[i + 1]);
                }
                CL_Initializer.markAsParsed(i, 2);
            }
            if (!stringArray[i].equals("-approxb0meas")) continue;
            String[] stringArray2 = new String[1000];
            int n = 0;
            while (n + i + 1 < stringArray.length && !stringArray[i + n + 1].startsWith("-")) {
                stringArray2[n] = stringArray[i + n + 1];
                ++n;
            }
            this.b0Indices = new int[n];
            for (int j = 0; j < n; ++j) {
                this.b0Indices[j] = Integer.parseInt(stringArray2[j]);
            }
            CL_Initializer.markAsParsed(i, n + 1);
        }
        CL_Initializer.checkParsing(stringArray);
        if (CL_Initializer.bgMask == null) {
            throw new LoggedException("This program requires a foreground ROI with -bgmask");
        }
    }

    @Override
    public void initVariables() {
        this.scheme = CL_Initializer.imPars;
        this.numMeas = this.scheme.numMeasurements();
    }

    @Override
    public void execute(OutputManager outputManager) {
        int n;
        int n2;
        Object[] objectArray;
        Object object;
        int n3;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        boolean[] blArray = new boolean[this.numMeas];
        int n4 = 0;
        if (this.b0Indices != null) {
            n4 = this.b0Indices.length;
            for (n3 = 0; n3 < n4; ++n3) {
                blArray[this.b0Indices[n3]] = true;
            }
        } else {
            for (n3 = 0; n3 < this.numMeas; ++n3) {
                blArray[n3] = this.scheme.zero(n3);
                if (!blArray[n3]) continue;
                ++n4;
            }
        }
        if (n4 == 0) {
            throw new LoggedException("Can't calculate SNR without any data at b=0");
        }
        n3 = 0;
        int n5 = 0;
        while (CL_Initializer.data.more()) {
            object = CL_Initializer.data.nextVoxel();
            if (CL_Initializer.bgMask.nextVoxel()[0] > 0.0) {
                objectArray = new double[n4];
                ++n5;
                for (n2 = 0; n2 < this.numMeas; ++n2) {
                    if (!blArray[n2]) continue;
                    arrayList.add(new Double(object[n2]));
                }
            }
            if (this.bgROI_Source == null || !(this.bgROI_Source.nextVoxel()[0] > 0.0)) continue;
            arrayList2.add(new Double(object[0]));
            ++n3;
        }
        object = new double[n5][n4];
        objectArray = new Double[n5 * n4];
        arrayList.toArray(objectArray);
        n2 = 0;
        for (int i = 0; i < n5; ++i) {
            for (n = 0; n < n4; ++n) {
                object[i][n] = objectArray[n2++];
            }
        }
        double[] dArray = null;
        if (this.bgROI_Source != null) {
            objectArray = new Double[n3];
            arrayList2.toArray(objectArray);
            dArray = new double[n3];
            for (n = 0; n < n3; ++n) {
                dArray[n] = objectArray[n];
            }
        }
        System.out.println("\nNumber of b=0 images:\t" + n4 + "\n");
        System.out.println("\nNumber of foreground voxels:\t" + n5);
        System.out.println("\nNumber of background voxels:\t" + n3 + "\n");
        System.out.println("\nSignal to noise in foreground ROI\n");
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        if (dArray != null) {
            dArray2 = EstimateSNR.snrStdv((double[][])object, dArray);
        }
        if (n4 > 1) {
            dArray3 = EstimateSNR.snrDiff((double[][])object);
            dArray4 = EstimateSNR.snrMult((double[][])object);
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        if (dArray2 != null) {
            System.out.println("SNR stdv:\t\t" + decimalFormat.format(dArray2[0] / dArray2[1]));
        }
        if (n4 == 1) {
            System.out.println("SNR mult:\t\t undefined");
            System.out.println("SNR diff:\t\t undefined");
        } else {
            System.out.println("SNR diff:\t\t" + decimalFormat.format(dArray3[0] / dArray3[1]));
            System.out.println("SNR mult:\t\t" + decimalFormat.format(dArray4[0] / dArray4[1]));
        }
        System.out.println("\nNoise standard deviation\n");
        if (dArray2 != null) {
            System.out.println("sigma stdv:\t\t" + decimalFormat.format(dArray2[1]));
        }
        if (n4 == 1) {
            System.out.println("sigma mult:\t\t undefined");
            System.out.println("sigma diff:\t\t undefined");
        } else {
            System.out.println("sigma diff:\t\t" + decimalFormat.format(dArray3[1]));
            System.out.println("sigma mult:\t\t" + decimalFormat.format(dArray4[1]));
        }
        System.out.println();
    }

    public static double[] snrDiff(double[][] dArray) {
        int n = dArray.length;
        double d = 0.0;
        double[] dArray2 = new double[n];
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i][0] + dArray[i][1];
            dArray2[i] = dArray[i][0] - dArray[i][1];
        }
        d2 = 1.0 / Math.sqrt(2.0) * Math.sqrt(ArrayOps.var(dArray2, ArrayOps.mean(dArray2)));
        return new double[]{d /= 2.0 * (double)n, d2};
    }

    public static double[] snrMult(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double d = 0.0;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            d += ArrayOps.sum(dArray[i]);
            dArray2[i] = Math.sqrt(ArrayOps.var(dArray[i], ArrayOps.mean(dArray[i])));
        }
        return new double[]{d /= (double)(n * n2), ArrayOps.mean(dArray2)};
    }

    public static double[] snrStdv(double[][] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i][0];
        }
        double d = ArrayOps.mean(dArray3);
        double d2 = Math.sqrt(2.3298961831627434) * Math.sqrt(ArrayOps.var(dArray2, ArrayOps.mean(dArray2)));
        return new double[]{d, d2};
    }
}

