/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.SphPDF_Fit;
import data.OutputManager;
import data.VoxelOrderDataSource;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import misc.LoggedException;
import numerics.RealMatrix;
import numerics.Rotations;
import numerics.Vector3D;
import tools.CL_Initializer;
import tools.FileInput;
import tractography.HistBin;
import tractography.Histogram;

public class GenerateMFR_LUT {
    private static Logger logger = Logger.getLogger("camino.GenerateMFR_LUT");
    private static final String BINGHAM = "bingham";
    private static final String WATSON = "watson";
    private static final String ACG = "acg";
    private static boolean testDataOutput = false;
    private static int order = 2;
    private static int numFOEsPerVoxel = 3;
    private static double binSize = 1.0;
    private static int numVectsPerBin = 50;
    private static boolean useLog = true;
    private static Histogram hist_1Fibre;
    private static Histogram hist_2Fibre;
    private static Random rand;
    private static int oneDT_BlockSize;
    private static double minDT2RotAngle;
    private static double maxDT2RotAngle;
    private static double dt2RotAngleStep;
    private static int twoDT_BlockSize;
    private static int numTwoDT_Blocks;
    private static double dt1E1Theta;
    private static double dt1E1Phi;
    private static double dt2E1Theta;
    private static double dt2E1Phi;
    private static double dt2RotAxisTheta;
    private static double dt2RotAxisPhi;
    private static String outputStem;
    private static String distributionType;

    private static void readInfoFile(String string) {
        FileInput fileInput = new FileInput(string);
        String string2 = fileInput.readString();
        String string3 = string2.substring(0, string2.indexOf("\t")).trim();
        String string4 = string2.substring(string2.indexOf("\t") + 1, string2.length());
        double d = 0.0;
        if (string3.equals("VERSION")) {
            d = Double.parseDouble(string4);
            string2 = fileInput.readString();
            string3 = string2.substring(0, string2.indexOf("\t")).trim();
            string4 = string2.substring(string2.indexOf("\t") + 1, string2.length());
        } else {
            logger.warning("no version information found in info file.  Assuming version 1.0. flag: " + string3);
            d = 1.0;
        }
        boolean bl = false;
        while (!bl) {
            GenerateMFR_LUT.processVersion1flags(string3, string4);
            if (!fileInput.eof()) {
                string2 = fileInput.readString();
                if (string2 == null) continue;
                string3 = string2.substring(0, string2.indexOf("\t")).trim();
                string4 = string2.substring(string2.indexOf("\t") + 1, string2.length());
                continue;
            }
            bl = true;
            fileInput.close();
        }
    }

    private static void processVersion1flags(String string, String string2) {
        if (string.equals("ROTATION_SEED")) {
            rand = new Random(Integer.parseInt(string2));
            if (testDataOutput) {
                System.err.println("rotation seed: " + string2);
            }
        } else if (string.equals("ONE_DT_BLOCK_SIZE")) {
            oneDT_BlockSize = Integer.parseInt(string2);
            if (testDataOutput) {
                System.err.println("one block size: " + string2);
            }
        } else if (string.equals("MIN_DT2_ROT_ANGLE")) {
            minDT2RotAngle = Double.parseDouble(string2);
            if (testDataOutput) {
                System.err.println("min dt2 rot angle: " + string2);
            }
        } else if (string.equals("MAX_DT2_ROT_ANGLE")) {
            maxDT2RotAngle = Double.parseDouble(string2);
            if (testDataOutput) {
                System.err.println("max dt2 rot angle: " + string2);
            }
        } else if (string.equals("DT2_ROT_ANGLE_STEP")) {
            dt2RotAngleStep = Double.parseDouble(string2);
            if (testDataOutput) {
                System.err.println("dt2 rot angle step: " + string2);
            }
        } else if (string.equals("TWO_DT_BLOCK_SIZE")) {
            twoDT_BlockSize = Integer.parseInt(string2);
            if (testDataOutput) {
                System.err.println("dt2 block size: " + string2);
            }
        } else if (string.equals("NUM_TWO_DT_BLOCKS")) {
            numTwoDT_Blocks = Integer.parseInt(string2);
            if (testDataOutput) {
                System.err.println("num dt2 blocks: " + string2);
            }
        } else if (string.equals("DT1_E1_THETA")) {
            dt1E1Theta = Double.parseDouble(string2);
            if (testDataOutput) {
                System.err.println("dt1 e1 theta: " + string2);
            }
        } else if (string.equals("DT1_E1_PHI")) {
            dt1E1Phi = Double.parseDouble(string2);
            if (testDataOutput) {
                System.err.println("dt1 e1 phi: " + string2);
            }
        } else if (string.equals("DT2_E1_THETA")) {
            dt2E1Theta = Double.parseDouble(string2);
            if (testDataOutput) {
                System.err.println("dt2 e1 theta: " + string2);
            }
        } else if (string.equals("DT2_E1_PHI")) {
            dt2E1Phi = Double.parseDouble(string2);
            if (testDataOutput) {
                System.err.println("dt2 e1 phi: " + string2);
            }
        } else if (string.equals("DT2_ROT_AXIS_THETA")) {
            dt2RotAxisTheta = Double.parseDouble(string2);
            if (testDataOutput) {
                System.err.println("dt2 rot axis theta: " + string2);
            }
        } else if (string.equals("DT2_ROT_AXIS_PHI")) {
            dt2RotAxisPhi = Double.parseDouble(string2);
            if (testDataOutput) {
                System.err.println("dt2 rot axis phi: " + string2);
            }
        } else {
            logger.warning("could not parse info file entry: " + string + "\t" + string2);
        }
    }

    private static void processData(String string, int n) {
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(string, n, "double");
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        Vector3D[] vector3DArray = new Vector3D[1];
        Vector3D[] vector3DArray2 = new Vector3D[2];
        int n3 = oneDT_BlockSize + twoDT_BlockSize * numTwoDT_Blocks;
        if (testDataOutput) {
            System.err.println("total data size: " + n3);
        }
        Vector3D vector3D = Vector3D.vectorFromSPC(1.0, dt1E1Theta, dt1E1Phi);
        Vector3D vector3D2 = Vector3D.vectorFromSPC(1.0, dt2E1Theta, dt2E1Phi);
        Vector3D vector3D3 = Vector3D.vectorFromSPC(1.0, dt2RotAxisTheta, dt2RotAxisPhi);
        Vector3D vector3D4 = null;
        Object var17_13 = null;
        RealMatrix realMatrix = null;
        double[] dArray = null;
        while (n2 < n3) {
            dArray = voxelOrderDataSource.nextVoxel();
            if (dArray[2] > 0.0) {
                if (n2 < oneDT_BlockSize) {
                    realMatrix = Rotations.randomRotMat(rand);
                    vector3DArray[0] = Rotations.rotateVector(vector3D, realMatrix);
                    GenerateMFR_LUT.binFOEs(dArray, vector3DArray, 1);
                } else if (n2 >= oneDT_BlockSize) {
                    int n4 = (n2 - oneDT_BlockSize) / twoDT_BlockSize;
                    double d3 = -(minDT2RotAngle + dt2RotAngleStep * (double)n4);
                    if (d3 > maxDT2RotAngle) {
                        logger.warning("dt2angle exceeded maximum angle specified! angle: " + d3);
                    }
                    vector3D4 = Rotations.rotateVector(vector3D2, vector3D3, d3);
                    realMatrix = Rotations.randomRotMat(rand);
                    vector3DArray2[0] = Rotations.rotateVector(vector3D, realMatrix);
                    vector3DArray2[1] = Rotations.rotateVector(vector3D4, realMatrix);
                    GenerateMFR_LUT.binFOEs(dArray, vector3DArray2, 2);
                }
            } else {
                realMatrix = Rotations.randomRotMat(rand);
            }
            ++n2;
        }
    }

    private static void binFOEs(double[] dArray, Vector3D[] vector3DArray, int n) {
        double d = 0.0;
        int[] nArray = null;
        int[][] nArray2 = GenerateMFR_LUT.getCombinations(numFOEsPerVoxel);
        Vector3D vector3D = null;
        for (int i = 0; i < nArray2.length; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                vector3D = new Vector3D(dArray[6 + nArray2[i][j] * 8], dArray[7 + nArray2[i][j] * 8], dArray[8 + nArray2[i][j] * 8]);
                d2 += Math.abs(vector3DArray[j].dot(vector3D));
            }
            if (!(d2 > d)) continue;
            d = d2;
            nArray = nArray2[i];
        }
        Vector3D vector3D2 = null;
        RealMatrix realMatrix = new RealMatrix(2, 2);
        double d3 = 1.0;
        for (int i = 0; i < n; ++i) {
            d3 = dArray[4];
            vector3D2 = new Vector3D(dArray[6 + nArray[i] * 8], dArray[7 + nArray[i] * 8], dArray[8 + nArray[i] * 8]);
            realMatrix.setEntry(0, 0, dArray[10 + nArray[i] * 8]);
            realMatrix.setEntry(0, 1, dArray[11 + nArray[i] * 8]);
            realMatrix.setEntry(1, 0, dArray[12 + nArray[i] * 8]);
            realMatrix.setEntry(1, 1, dArray[13 + nArray[i] * 8]);
            if (!(vector3D2.x * vector3D2.x + vector3D2.y * vector3D2.y + vector3D2.z * vector3D2.z > 0.0)) continue;
            GenerateMFR_LUT.transformFibre(vector3D2, realMatrix, vector3DArray[i], d3, n);
        }
    }

    private static void transformFibre(Vector3D vector3D, RealMatrix realMatrix, Vector3D vector3D2, double d, int n) {
        Vector3D vector3D3;
        Vector3D vector3D4 = new Vector3D(0.0, 0.0, 1.0);
        RealMatrix realMatrix2 = Rotations.getRotMat(vector3D, vector3D4);
        RealMatrix[] realMatrixArray = realMatrix.jacobi();
        double d2 = 0.0;
        double d3 = 0.0;
        if (Math.abs(realMatrixArray[0].entry(0, 0)) > Math.abs(realMatrixArray[0].entry(1, 1))) {
            vector3D3 = new Vector3D(realMatrixArray[1].entry(0, 0), realMatrixArray[1].entry(1, 0), 0.0);
            d2 = Math.abs(realMatrixArray[0].entry(0, 0));
            d3 = Math.abs(realMatrixArray[0].entry(1, 1));
        } else {
            vector3D3 = new Vector3D(realMatrixArray[1].entry(1, 0), realMatrixArray[1].entry(1, 1), 0.0);
            d2 = Math.abs(realMatrixArray[0].entry(1, 1));
            d3 = Math.abs(realMatrixArray[0].entry(0, 0));
        }
        Vector3D vector3D5 = new Vector3D(1.0, 0.0, 0.0);
        RealMatrix realMatrix3 = Rotations.getRotMat(vector3D3, vector3D5);
        RealMatrix realMatrix4 = realMatrix3.product(realMatrix2);
        Vector3D vector3D6 = Rotations.rotateVector(vector3D2, realMatrix4);
        if (vector3D2.dot(vector3D) < 0.0) {
            vector3D6 = vector3D6.negated();
        }
        if (d == 0.0) {
            d = 1.0;
            logger.warning("mean of function is zero!  Setting to " + d + " and continuing");
        }
        if (n == 1) {
            hist_1Fibre.add(new Vector3D(vector3D6.x, vector3D6.y, vector3D6.z), d2 / d, d3 / d);
        } else if (n == 2) {
            hist_2Fibre.add(new Vector3D(vector3D6.x, vector3D6.y, vector3D6.z), d2 / d, d3 / d);
        }
    }

    private static int[][] getCombinations(int n) {
        if (n == 1) {
            int[][] nArrayArray = new int[][]{{0}};
            return nArrayArray;
        }
        if (n == 2) {
            int[][] nArrayArray = new int[][]{{0, 1}, {1, 0}};
            return nArrayArray;
        }
        if (n == 3) {
            int[][] nArrayArray = new int[][]{{0, 1, 2}, {0, 2, 1}, {1, 0, 2}, {1, 2, 0}, {2, 0, 1}, {2, 1, 0}};
            return nArrayArray;
        }
        logger.warning("numpds greater than 3.  Currently not supported!  Program will attempt to continue");
        return null;
    }

    private static double[][] fitDistribution(String string, Histogram histogram) {
        double[][] dArray;
        Set set = histogram.getEntrySet();
        Iterator iterator = set.iterator();
        int n = set.size();
        if (string.equals(BINGHAM) || string.equals(ACG)) {
            dArray = new double[n][4];
        } else if (string.equals(WATSON)) {
            dArray = new double[n][2];
        } else {
            throw new LoggedException("distribution type " + string + " unknown");
        }
        int n2 = 0;
        while (iterator.hasNext()) {
            double[] dArray2;
            double[] dArray3;
            HistBin histBin = (HistBin)((Map.Entry)iterator.next()).getValue();
            Vector3D[] vector3DArray = histBin.getDirsList();
            if (vector3DArray.length < numVectsPerBin) continue;
            if (string.equals(BINGHAM)) {
                dArray3 = SphPDF_Fit.getBinghamConcentrationParams(vector3DArray);
                dArray2 = useLog ? histBin.getLogEigs() : histBin.getEigs();
                dArray[n2][0] = dArray2[0];
                dArray[n2][1] = dArray2[1];
                dArray[n2][2] = Math.log(-dArray3[0]);
                dArray[n2][3] = Math.log(-dArray3[1]);
            } else if (string.equals(WATSON)) {
                dArray3 = SphPDF_Fit.getWatsonConcentrationParams(vector3DArray);
                dArray[n2][0] = useLog ? histBin.getLogTrace() : histBin.getTrace();
                dArray[n2][1] = dArray3[0];
            } else if (string.equals(ACG)) {
                dArray3 = SphPDF_Fit.getACGConcentrationParams(vector3DArray);
                System.err.println("ACG eigs: " + dArray3[0] + " " + dArray3[1] + " " + dArray3[2]);
                dArray2 = useLog ? histBin.getLogEigs() : histBin.getEigs();
                dArray[n2][0] = dArray2[0];
                dArray[n2][1] = dArray2[1];
                dArray[n2][2] = Math.log(dArray3[0] / dArray3[2]);
                dArray[n2][3] = Math.log(dArray3[1] / dArray3[2]);
            }
            ++n2;
        }
        return GenerateMFR_LUT.trimArray(dArray, n2);
    }

    private static double[][] trimArray(double[][] dArray, int n) {
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        return dArray2;
    }

    private static double[] fitSurface(double[][] dArray, int n) {
        int n2;
        int n3 = (order + 1) * (order + 2) / 2;
        if (dArray.length < 1) {
            throw new LoggedException("no fibre-orientation estimates in histogram!  Increase calibration data set size (best) or reduce -minvectsperbin for testing.");
        }
        if (dArray.length < n3) {
            throw new LoggedException("not enough populated bins to enable surface fit.  Number of bins: " + dArray.length);
        }
        if (n >= dArray[0].length) {
            throw new LoggedException("out of bounds! zInd = " + n + " orderedDataSize = " + dArray[0].length);
        }
        double[] dArray2 = new double[dArray.length];
        double[] dArray3 = new double[dArray.length];
        RealMatrix realMatrix = new RealMatrix(1, dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i][0];
            dArray3[i] = dArray[i][1];
            realMatrix.setEntry(0, i, dArray[i][n]);
        }
        RealMatrix realMatrix2 = new RealMatrix(n3, dArray2.length);
        int n4 = 0;
        for (int i = 0; i <= order; ++i) {
            for (int j = 0; j <= order; ++j) {
                if (i + j > order) continue;
                for (int k = 0; k < dArray2.length; ++k) {
                    realMatrix2.setEntry(n4, k, Math.pow(dArray2[k], i) * Math.pow(dArray3[k], j));
                }
                ++n4;
            }
        }
        RealMatrix realMatrix3 = realMatrix2.pseudoInv();
        RealMatrix realMatrix4 = realMatrix.product(realMatrix3);
        double[] dArray4 = new double[realMatrix4.columns()];
        for (n2 = 0; n2 < dArray4.length; ++n2) {
            dArray4[n2] = realMatrix4.entry(0, n2);
        }
        if (testDataOutput) {
            System.err.println("Coeffs: ");
            for (n2 = 0; n2 < dArray4.length; ++n2) {
                System.err.println(dArray4[n2]);
            }
            System.err.println();
        }
        return dArray4;
    }

    private static double[] fitLine(double[][] dArray) {
        int n;
        if (dArray.length == 0) {
            throw new LoggedException("no fibre-orientation estimates in histogram!");
        }
        double[] dArray2 = new double[dArray.length];
        RealMatrix realMatrix = new RealMatrix(1, dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i][0];
            realMatrix.setEntry(0, i, dArray[i][1]);
        }
        RealMatrix realMatrix2 = new RealMatrix(order + 1, dArray2.length);
        for (int i = 0; i < order + 1; ++i) {
            for (int j = 0; j < dArray2.length; ++j) {
                realMatrix2.setEntry(i, j, Math.pow(dArray2[j], i));
            }
        }
        RealMatrix realMatrix3 = realMatrix2.pseudoInv();
        RealMatrix realMatrix4 = realMatrix.product(realMatrix3);
        double[] dArray3 = new double[realMatrix4.columns()];
        for (n = 0; n < dArray3.length; ++n) {
            dArray3[n] = realMatrix4.entry(0, n);
        }
        if (testDataOutput) {
            System.err.println("Coeffs: ");
            for (n = 0; n < dArray3.length; ++n) {
                System.err.println(dArray3[n]);
            }
            System.err.println();
        }
        return dArray3;
    }

    private static void saveCoeffs(double[] dArray, String string) {
        OutputManager.outputFile = string;
        OutputManager outputManager = new OutputManager();
        outputManager.output(dArray);
        outputManager.close();
    }

    private static void outputCoeffs(double[] dArray, String string) {
        double[] dArray2 = new double[dArray.length + 2];
        if (distributionType.equals(BINGHAM) || distributionType.equals(ACG)) {
            dArray2[0] = 2.0;
        } else if (distributionType.equals(WATSON)) {
            dArray2[0] = 1.0;
        }
        dArray2[1] = order;
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i + 2] = dArray[i];
        }
        GenerateMFR_LUT.saveCoeffs(dArray2, string);
    }

    private static void outputCoeffs(double[] dArray, double[] dArray2, String string) {
        if (dArray.length != dArray2.length) {
            throw new LoggedException("surface coefficient arrays not the same length for 2 fibre case");
        }
        double[] dArray3 = new double[dArray.length * 2 + 2];
        if (distributionType.equals(BINGHAM) || distributionType.equals(ACG)) {
            dArray3[0] = 2.0;
        } else if (distributionType.equals(WATSON)) {
            dArray3[0] = 1.0;
        }
        dArray3[1] = order;
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i + 2] = dArray[i];
            dArray3[i + dArray.length + 2] = dArray2[i];
        }
        GenerateMFR_LUT.saveCoeffs(dArray3, string);
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        CL_Initializer.CL_init(stringArray);
        String string = CL_Initializer.inputFile;
        numFOEsPerVoxel = CL_Initializer.numPDsIO;
        String string2 = "";
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].equals("-order")) {
                order = Integer.parseInt(stringArray[n2 + 1]);
                CL_Initializer.markAsParsed(n2, 2);
                continue;
            }
            if (stringArray[n2].equals("-binincsize")) {
                binSize = Double.parseDouble(stringArray[n2 + 1]);
                CL_Initializer.markAsParsed(n2, 2);
                continue;
            }
            if (stringArray[n2].equals("-minvectsperbin")) {
                numVectsPerBin = Integer.parseInt(stringArray[n2 + 1]);
                CL_Initializer.markAsParsed(n2, 2);
                continue;
            }
            if (stringArray[n2].equals("-directmap")) {
                useLog = false;
                CL_Initializer.markAsParsed(n2, 1);
                continue;
            }
            if (stringArray[n2].equals("-infofile")) {
                string2 = stringArray[n2 + 1];
                CL_Initializer.markAsParsed(n2, 2);
                continue;
            }
            if (stringArray[n2].equals("-outputstem")) {
                outputStem = stringArray[n2 + 1];
                CL_Initializer.markAsParsed(n2, 2);
                continue;
            }
            if (stringArray[n2].equals("-pdf")) {
                distributionType = stringArray[n2 + 1];
                CL_Initializer.markAsParsed(n2, 2);
                continue;
            }
            if (!stringArray[n2].equals("-test")) continue;
            testDataOutput = true;
            CL_Initializer.markAsParsed(n2, 1);
        }
        CL_Initializer.checkParsing(stringArray);
        if (!(distributionType.equals(BINGHAM) || distributionType.equals(WATSON) || distributionType.equals(ACG))) {
            throw new LoggedException("distribution not recognized.  requested: " + distributionType);
        }
        if (order < 0) {
            throw new LoggedException("order must be >= 0.  order=" + order);
        }
        if (binSize <= 0.0) {
            throw new LoggedException("bin size must be > 0.0.  binincsize=" + binSize);
        }
        if (distributionType.equals(BINGHAM) || distributionType.equals(ACG)) {
            hist_1Fibre = new Histogram(2, binSize, useLog);
            hist_2Fibre = new Histogram(2, binSize, useLog);
        } else {
            hist_1Fibre = new Histogram(1, binSize, useLog);
            hist_2Fibre = new Histogram(1, binSize, useLog);
        }
        n2 = 6 + numFOEsPerVoxel * 8;
        GenerateMFR_LUT.readInfoFile(string2);
        GenerateMFR_LUT.processData(string, n2);
        double[][] dArray = GenerateMFR_LUT.fitDistribution(distributionType, hist_1Fibre);
        if (testDataOutput) {
            System.err.println("Dist 1");
            for (int i = 0; i < dArray.length; ++i) {
                for (n = 0; n < dArray[0].length; ++n) {
                    System.err.print(dArray[i][n] + " ");
                }
                System.err.println();
            }
        }
        double[][] dArray2 = GenerateMFR_LUT.fitDistribution(distributionType, hist_2Fibre);
        if (testDataOutput) {
            System.err.println("Dist 2");
            for (n = 0; n < dArray2.length; ++n) {
                for (int i = 0; i < dArray2[0].length; ++i) {
                    System.err.print(dArray2[n][i] + " ");
                }
                System.err.println();
            }
        }
        if (distributionType.equals(BINGHAM) || distributionType.equals(ACG)) {
            double[] dArray3 = GenerateMFR_LUT.fitSurface(dArray, 2);
            double[] dArray4 = GenerateMFR_LUT.fitSurface(dArray, 3);
            GenerateMFR_LUT.outputCoeffs(dArray3, dArray4, outputStem + "_oneFibreSurfaceCoeffs.Bdouble");
            double[] dArray5 = GenerateMFR_LUT.fitSurface(dArray2, 2);
            double[] dArray6 = GenerateMFR_LUT.fitSurface(dArray2, 3);
            GenerateMFR_LUT.outputCoeffs(dArray5, dArray6, outputStem + "_twoFibreSurfaceCoeffs.Bdouble");
        } else if (distributionType.equals(WATSON)) {
            double[] dArray7 = GenerateMFR_LUT.fitLine(dArray);
            GenerateMFR_LUT.outputCoeffs(dArray7, outputStem + "_oneFibreLineCoeffs.Bdouble");
            double[] dArray8 = GenerateMFR_LUT.fitLine(dArray2);
            GenerateMFR_LUT.outputCoeffs(dArray8, outputStem + "_twoFibreLineCoeffs.Bdouble");
        }
    }

    static {
        oneDT_BlockSize = 1;
        minDT2RotAngle = 0.0;
        maxDT2RotAngle = 0.5;
        dt2RotAngleStep = 0.1;
        twoDT_BlockSize = 1;
        numTwoDT_Blocks = 1;
        dt1E1Theta = 0.0;
        dt1E1Phi = 0.0;
        dt2E1Theta = 0.0;
        dt2E1Phi = 0.0;
        dt2RotAxisTheta = 0.0;
        dt2RotAxisPhi = 0.0;
        outputStem = "PICoCalibOut";
        distributionType = BINGHAM;
    }
}

