/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import apps.FracAnis;
import apps.ModelFit;
import data.OutputManager;
import java.util.logging.Logger;
import misc.DT;
import misc.LoggedException;
import tools.CL_Initializer;

public class MeanDiff
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.TraceD");

    public MeanDiff(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputModel = "dt";
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initTensorDataSource();
    }

    @Override
    public void initVariables() {
    }

    @Override
    public void execute(OutputManager outputManager) {
        while (CL_Initializer.data.more()) {
            try {
                int n;
                boolean bl;
                double[] dArray = CL_Initializer.data.nextVoxel();
                DT[] dTArray = FracAnis.getTensorList(dArray, CL_Initializer.inputModel);
                double[] dArray2 = new double[dTArray.length];
                boolean bl2 = bl = !ModelFit.isBG(Math.exp(dArray[1]));
                if (dArray[0] >= 0.0 && bl) {
                    for (n = 0; n < dTArray.length; ++n) {
                        dArray2[n] = dTArray[n].trace() / 3.0;
                    }
                } else {
                    for (n = 0; n < dTArray.length; ++n) {
                        dArray2[n] = 0.0;
                    }
                }
                outputManager.output(dArray2);
            }
            catch (Exception exception) {
                LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
            }
        }
        outputManager.close();
    }
}

