/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.DataSourceException;
import data.OutputManager;
import fitters.BallCylinderAstrocylindersLM_Fitter;
import fitters.BallCylinderAstrocylindersMultiRunLM_Fitter;
import fitters.BallCylinderAstrosticksLM_Fitter;
import fitters.BallCylinderAstrosticksMultiRunLM_Fitter;
import fitters.BallCylinderDotLM_Fitter;
import fitters.BallCylinderDotMultiRunLM_Fitter;
import fitters.BallCylinderLM_Fitter;
import fitters.BallCylinderMultiRunLM_Fitter;
import fitters.BallCylinderSphereLM_Fitter;
import fitters.BallCylinderSphereMultiRunLM_Fitter;
import fitters.BallGDRCylindersAstrocylindersLM_Fitter;
import fitters.BallGDRCylindersAstrocylindersMultiRunLM_Fitter;
import fitters.BallGDRCylindersAstrosticksLM_Fitter;
import fitters.BallGDRCylindersAstrosticksMultiRunLM_Fitter;
import fitters.BallGDRCylindersDotLM_Fitter;
import fitters.BallGDRCylindersDotMultiRunLM_Fitter;
import fitters.BallGDRCylindersLM_Fitter;
import fitters.BallGDRCylindersMultiRunLM_Fitter;
import fitters.BallGDRCylindersSphereLM_Fitter;
import fitters.BallGDRCylindersSphereMultiRunLM_Fitter;
import fitters.BallStickAstrocylindersLM_Fitter;
import fitters.BallStickAstrocylindersMultiRunLM_Fitter;
import fitters.BallStickAstrosticksLM_Fitter;
import fitters.BallStickAstrosticksMultiRunLM_Fitter;
import fitters.BallStickDotLM_Fitter;
import fitters.BallStickDotMultiRunLM_Fitter;
import fitters.BallStickLM_Fitter;
import fitters.BallStickMCMC_Fitter;
import fitters.BallStickMultiRunLM_Fitter;
import fitters.BallStickSphereLM_Fitter;
import fitters.BallStickSphereMultiRunLM_Fitter;
import fitters.BiZeppelinLM_Fitter;
import fitters.BiZeppelinMultiRunLM_Fitter;
import fitters.FitAlgorithm;
import fitters.FitModel;
import fitters.Fitter;
import fitters.MMWMD_BasicLM_DirectFitter;
import fitters.MMWMD_BasicMCMC_Fitter;
import fitters.MMWMD_BasicMultiRunLM_DirectFitter;
import fitters.MMWMD_FixedLM_DirectFitter;
import fitters.MMWMD_FixedMCMC_Fitter;
import fitters.MMWMD_FixedMultiRunLM_DirectFitter;
import fitters.MMWMD_InVivoLM_DirectFitter;
import fitters.MMWMD_InVivoMCMC_Fitter;
import fitters.MMWMD_InVivoMultiRunLM_DirectFitter;
import fitters.NoiseModel;
import fitters.TensorCylinderAstrocylindersLM_Fitter;
import fitters.TensorCylinderAstrocylindersMultiRunLM_Fitter;
import fitters.TensorCylinderAstrosticksLM_Fitter;
import fitters.TensorCylinderAstrosticksMultiRunLM_Fitter;
import fitters.TensorCylinderDotLM_Fitter;
import fitters.TensorCylinderDotMultiRunLM_Fitter;
import fitters.TensorCylinderLM_Fitter;
import fitters.TensorCylinderMultiRunLM_Fitter;
import fitters.TensorCylinderSphereLM_Fitter;
import fitters.TensorCylinderSphereMultiRunLM_Fitter;
import fitters.TensorGDRCylindersAstrocylindersLM_Fitter;
import fitters.TensorGDRCylindersAstrocylindersMultiRunLM_Fitter;
import fitters.TensorGDRCylindersAstrosticksLM_Fitter;
import fitters.TensorGDRCylindersAstrosticksMultiRunLM_Fitter;
import fitters.TensorGDRCylindersDotLM_Fitter;
import fitters.TensorGDRCylindersDotMultiRunLM_Fitter;
import fitters.TensorGDRCylindersLM_Fitter;
import fitters.TensorGDRCylindersMultiRunLM_Fitter;
import fitters.TensorGDRCylindersSphereLM_Fitter;
import fitters.TensorGDRCylindersSphereMultiRunLM_Fitter;
import fitters.TensorStickAstrocylindersLM_Fitter;
import fitters.TensorStickAstrocylindersMultiRunLM_Fitter;
import fitters.TensorStickAstrosticksLM_Fitter;
import fitters.TensorStickAstrosticksMultiRunLM_Fitter;
import fitters.TensorStickDotLM_Fitter;
import fitters.TensorStickDotMultiRunLM_Fitter;
import fitters.TensorStickLM_Fitter;
import fitters.TensorStickMultiRunLM_Fitter;
import fitters.TensorStickSphereLM_Fitter;
import fitters.TensorStickSphereMultiRunLM_Fitter;
import fitters.ZeppelinCylinderAstrocylindersLM_Fitter;
import fitters.ZeppelinCylinderAstrocylindersMultiRunLM_Fitter;
import fitters.ZeppelinCylinderAstrosticksLM_Fitter;
import fitters.ZeppelinCylinderAstrosticksMultiRunLM_Fitter;
import fitters.ZeppelinCylinderDotCSF_LM_DirectFitter;
import fitters.ZeppelinCylinderDotCSF_MultiRunLM_DirectFitter;
import fitters.ZeppelinCylinderDotLM_DirectFitter;
import fitters.ZeppelinCylinderDotLM_Fitter;
import fitters.ZeppelinCylinderDotMCMC_GaussianFitter;
import fitters.ZeppelinCylinderDotMultiRunLM_DirectFitter;
import fitters.ZeppelinCylinderDotMultiRunLM_Fitter;
import fitters.ZeppelinCylinderLM_DirectFitter;
import fitters.ZeppelinCylinderLM_Fitter;
import fitters.ZeppelinCylinderMultiRunLM_DirectFitter;
import fitters.ZeppelinCylinderMultiRunLM_Fitter;
import fitters.ZeppelinCylinderSphereLM_Fitter;
import fitters.ZeppelinCylinderSphereMultiRunLM_Fitter;
import fitters.ZeppelinCylinderTortLM_Fitter;
import fitters.ZeppelinCylinderTortMultiRunLM_Fitter;
import fitters.ZeppelinGDRCylindersAstrocylindersLM_Fitter;
import fitters.ZeppelinGDRCylindersAstrocylindersMultiRunLM_Fitter;
import fitters.ZeppelinGDRCylindersAstrosticksLM_Fitter;
import fitters.ZeppelinGDRCylindersAstrosticksMultiRunLM_Fitter;
import fitters.ZeppelinGDRCylindersDotLM_Fitter;
import fitters.ZeppelinGDRCylindersDotMultiRunLM_Fitter;
import fitters.ZeppelinGDRCylindersLM_Fitter;
import fitters.ZeppelinGDRCylindersMultiRunLM_Fitter;
import fitters.ZeppelinGDRCylindersSphereLM_Fitter;
import fitters.ZeppelinGDRCylindersSphereMultiRunLM_Fitter;
import fitters.ZeppelinStickAstrocylindersLM_Fitter;
import fitters.ZeppelinStickAstrocylindersMultiRunLM_Fitter;
import fitters.ZeppelinStickAstrosticksLM_Fitter;
import fitters.ZeppelinStickAstrosticksMultiRunLM_Fitter;
import fitters.ZeppelinStickDotLM_Fitter;
import fitters.ZeppelinStickDotMultiRunLM_Fitter;
import fitters.ZeppelinStickLM_DirectFitter;
import fitters.ZeppelinStickLM_Fitter;
import fitters.ZeppelinStickMultiRunLM_DirectFitter;
import fitters.ZeppelinStickMultiRunLM_Fitter;
import fitters.ZeppelinStickSphereLM_Fitter;
import fitters.ZeppelinStickSphereMultiRunLM_Fitter;
import fitters.ZeppelinStickTortLM_Fitter;
import fitters.ZeppelinStickTortMultiRunLM_Fitter;
import imaging.DW_Scheme;
import inverters.BallStickInversion;
import inverters.DT_Inversion;
import inverters.DiffusionInversion;
import inverters.LinearADC_Inversion;
import inverters.ModelIndex;
import inverters.RestoreDT_Inversion;
import inverters.ThreeTensorInversion;
import inverters.TwoTensorInversion;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;

public class ModelFit
extends Executable {
    protected static Logger logger = Logger.getLogger("camino.apps.ModelFit");
    private Fitter fitter;
    protected DiffusionInversion inv;

    public ModelFit(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
    }

    @Override
    public void initVariables() {
        if (CL_Initializer.compartmentModel) {
            FitModel fitModel = FitModel.getFitModel(CL_Initializer.fitModel);
            NoiseModel noiseModel = NoiseModel.getNoiseModel(CL_Initializer.noiseModel);
            FitAlgorithm fitAlgorithm = FitAlgorithm.getFitAlgorithm(CL_Initializer.fitAlgorithm);
            this.fitter = ModelFit.getFitter(fitModel, noiseModel, fitAlgorithm);
        } else {
            this.inv = ModelFit.getIndexedInversion(CL_Initializer.inversionIndices, CL_Initializer.imPars);
        }
    }

    @Override
    public void execute(OutputManager outputManager) {
        int n = 0;
        while (CL_Initializer.data.more()) {
            try {
                int n2;
                double[] dArray = CL_Initializer.data.nextVoxel();
                double d = CL_Initializer.imPars.geoMeanZeroMeas(dArray);
                boolean bl = ModelFit.isBG(d);
                if (bl) {
                    int n3 = 0;
                    n2 = 0;
                    if (CL_Initializer.compartmentModel) {
                        n3 = this.fitter.getNumValuesPerRun();
                        n2 = this.fitter.getNumValuesPerSolution();
                    } else {
                        n2 = n3 = this.inv.itemsPerVoxel();
                    }
                    double[] dArray2 = new double[n3];
                    for (int i = 0; i < n3; i += n2) {
                        dArray2[i] = -1.0;
                        dArray2[i + 1] = d > 0.0 ? Math.log(d) : 0.0;
                    }
                    outputManager.output(dArray2);
                    if (!CL_Initializer.compartmentModel) {
                        this.inv.background();
                    }
                } else {
                    try {
                        Object object;
                        if (CL_Initializer.compartmentModel) {
                            object = this.fitter.fit(dArray);
                            for (n2 = 0; n2 < ((double[][])object).length; ++n2) {
                                outputManager.output(object[n2]);
                            }
                        } else {
                            object = this.inv.invert(dArray);
                            outputManager.output((double[])object);
                        }
                    }
                    catch (Exception exception) {
                        throw new LoggedException(exception);
                    }
                }
                logger.fine("Completed voxel: " + n + " " + bl);
                ++n;
            }
            catch (DataSourceException dataSourceException) {
                throw new LoggedException("The data file does not contain a whole number of voxels. Check the scheme file. Got Exception " + dataSourceException);
            }
        }
        if (!CL_Initializer.compartmentModel) {
            this.inv.close();
        }
        outputManager.close();
    }

    public static final Fitter getFitter(FitModel fitModel, NoiseModel noiseModel, FitAlgorithm fitAlgorithm) {
        if (fitModel == FitModel.BALLSTICK) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallStickLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallStickMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
            if (fitAlgorithm == FitAlgorithm.MCMC) {
                return new BallStickMCMC_Fitter(CL_Initializer.imPars);
            }
        } else if (fitModel == FitModel.BIZEPPELIN) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BiZeppelinLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BiZeppelinMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINGDRCYLINDERS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinGDRCylindersLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinGDRCylindersMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINGDRCYLINDERSDOT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinGDRCylindersDotLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinGDRCylindersDotMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINGDRCYLINDERSSPHERE) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinGDRCylindersSphereLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinGDRCylindersSphereMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINGDRCYLINDERSASTROSTICKS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinGDRCylindersAstrosticksLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinGDRCylindersAstrosticksMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINGDRCYLINDERSASTROCYLINDERS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinGDRCylindersAstrocylindersLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinGDRCylindersAstrocylindersMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.BALLCYLINDER) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallCylinderLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallCylinderMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINSTICK) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinStickLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinStickMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINSTICKDIRECT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinStickLM_DirectFitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinStickMultiRunLM_DirectFitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINSTICKTORT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinStickTortLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinStickTortMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINCYLINDER) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinCylinderLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinCylinderMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINCYLINDERDIRECT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinCylinderLM_DirectFitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinCylinderMultiRunLM_DirectFitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINCYLINDERTORT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinCylinderTortLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinCylinderTortMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORSTICK) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorStickLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorStickMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORCYLINDER) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorCylinderLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorCylinderMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.BALLSTICKDOT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallStickDotLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallStickDotMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.BALLSTICKASTROSTICKS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallStickAstrosticksLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallStickAstrosticksMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.BALLSTICKASTROCYLINDERS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallStickAstrocylindersLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallStickAstrocylindersMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINSTICKDOT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinStickDotLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinStickDotMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINSTICKSPHERE) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinStickSphereLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinStickSphereMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINSTICKASTROSTICKS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinStickAstrosticksLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinStickAstrosticksMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINSTICKASTROCYLINDERS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinStickAstrocylindersLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinStickAstrocylindersMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORSTICKDOT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorStickDotLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorStickDotMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORSTICKSPHERE) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorStickSphereLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorStickSphereMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORSTICKASTROSTICKS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorStickAstrosticksLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorStickAstrosticksMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORSTICKASTROCYLINDERS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorStickAstrocylindersLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorStickAstrocylindersMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.BALLCYLINDERDOT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallCylinderDotLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallCylinderDotMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINCYLINDERDOT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinCylinderDotLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinCylinderDotMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
            if (fitAlgorithm == FitAlgorithm.MCMC) {
                return new ZeppelinCylinderDotMCMC_GaussianFitter(CL_Initializer.imPars);
            }
        } else if (fitModel == FitModel.ZEPPELINCYLINDERDOTDIRECT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinCylinderDotLM_DirectFitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinCylinderDotMultiRunLM_DirectFitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINCYLINDERDOTCSFDIRECT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinCylinderDotCSF_LM_DirectFitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinCylinderDotCSF_MultiRunLM_DirectFitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORCYLINDERDOT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorCylinderDotLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorCylinderDotMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.BALLCYLINDERASTROSTICKS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallCylinderAstrosticksLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallCylinderAstrosticksMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.BALLCYLINDERASTROCYLINDERS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallCylinderAstrocylindersLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallCylinderAstrocylindersMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.BALLCYLINDERSPHERE) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallCylinderSphereLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallCylinderSphereMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORCYLINDERASTROSTICKS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorCylinderAstrosticksLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorCylinderAstrosticksMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORCYLINDERASTROCYLINDERS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorCylinderAstrocylindersLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorCylinderAstrocylindersMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORCYLINDERSPHERE) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorCylinderSphereLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorCylinderSphereMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINCYLINDERASTROSTICKS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinCylinderAstrosticksLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinCylinderAstrosticksMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.ZEPPELINCYLINDERASTROCYLINDERS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinCylinderAstrocylindersLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinCylinderAstrocylindersMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.MMWMDBASIC) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new MMWMD_BasicLM_DirectFitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new MMWMD_BasicMultiRunLM_DirectFitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
            if (fitAlgorithm == FitAlgorithm.MCMC) {
                return new MMWMD_BasicMCMC_Fitter(CL_Initializer.imPars);
            }
        } else if (fitModel == FitModel.MMWMDINVIVO) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new MMWMD_InVivoLM_DirectFitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new MMWMD_InVivoMultiRunLM_DirectFitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
            if (fitAlgorithm == FitAlgorithm.MCMC) {
                return new MMWMD_InVivoMCMC_Fitter(CL_Initializer.imPars);
            }
        } else if (fitModel == FitModel.MMWMDFIXED) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new MMWMD_FixedLM_DirectFitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new MMWMD_FixedMultiRunLM_DirectFitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
            if (fitAlgorithm == FitAlgorithm.MCMC) {
                return new MMWMD_FixedMCMC_Fitter(CL_Initializer.imPars);
            }
        } else if (fitModel == FitModel.ZEPPELINCYLINDERSPHERE) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new ZeppelinCylinderSphereLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new ZeppelinCylinderSphereMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.BALLGDRCYLINDERS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallGDRCylindersLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallGDRCylindersMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.BALLGDRCYLINDERSDOT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallGDRCylindersDotLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallGDRCylindersDotMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.BALLGDRCYLINDERSSPHERE) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallGDRCylindersSphereLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallGDRCylindersSphereMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.BALLGDRCYLINDERSASTROSTICKS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallGDRCylindersAstrosticksLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallGDRCylindersAstrosticksMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.BALLGDRCYLINDERSASTROCYLINDERS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallGDRCylindersAstrocylindersLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallGDRCylindersAstrocylindersMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORGDRCYLINDERS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorGDRCylindersLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorGDRCylindersMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORGDRCYLINDERSDOT) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorGDRCylindersDotLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorGDRCylindersDotMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORGDRCYLINDERSSPHERE) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorGDRCylindersSphereLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorGDRCylindersSphereMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORGDRCYLINDERSASTROSTICKS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorGDRCylindersAstrosticksLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorGDRCylindersAstrosticksMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.TENSORGDRCYLINDERSASTROCYLINDERS) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new TensorGDRCylindersAstrocylindersLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new TensorGDRCylindersAstrocylindersMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        } else if (fitModel == FitModel.BALLSTICKSPHERE) {
            if (fitAlgorithm == FitAlgorithm.LM) {
                return new BallStickSphereLM_Fitter(CL_Initializer.imPars);
            }
            if (fitAlgorithm == FitAlgorithm.MULTIRUNLM) {
                return new BallStickSphereMultiRunLM_Fitter(CL_Initializer.imPars, CL_Initializer.samples, CL_Initializer.seed);
            }
        }
        throw new LoggedException("no fitter available for combination of " + (Object)((Object)fitModel) + ", " + (Object)((Object)noiseModel) + " and " + (Object)((Object)fitAlgorithm));
    }

    public static DiffusionInversion getIndexedInversion(ModelIndex[] modelIndexArray, DW_Scheme dW_Scheme) {
        if (modelIndexArray[0] == ModelIndex.BALL_STICK) {
            return new BallStickInversion(dW_Scheme);
        }
        if (modelIndexArray[0] == ModelIndex.RESTORE) {
            if (CL_Initializer.sigma == -1.0) {
                logger.severe("Noise level must be specified (-sigma <std>) for RESTORE.");
                System.exit(1);
            }
            return new RestoreDT_Inversion(dW_Scheme, CL_Initializer.sigma);
        }
        if (modelIndexArray[0] == ModelIndex.ADC) {
            return new LinearADC_Inversion(dW_Scheme);
        }
        if (modelIndexArray[0].numDTs == 1) {
            return DT_Inversion.getIndexedDT_Inversion(modelIndexArray[0], dW_Scheme);
        }
        if (modelIndexArray[0].numDTs == 2) {
            if (modelIndexArray.length == 1) {
                return new TwoTensorInversion(dW_Scheme, modelIndexArray[0], ModelIndex.LDT);
            }
            return new TwoTensorInversion(dW_Scheme, modelIndexArray[0], modelIndexArray[1]);
        }
        if (modelIndexArray[0].numDTs == 3) {
            if (modelIndexArray.length == 1) {
                return new ThreeTensorInversion(dW_Scheme, modelIndexArray[0], ModelIndex.LDT);
            }
            return new ThreeTensorInversion(dW_Scheme, modelIndexArray[0], modelIndexArray[1]);
        }
        return null;
    }

    public static boolean isBG(double d) {
        boolean bl = false;
        if (CL_Initializer.BACKGROUNDTHRESHOLD > 0.0) {
            boolean bl2 = bl = d < CL_Initializer.BACKGROUNDTHRESHOLD;
        }
        if (CL_Initializer.bgMask != null) {
            try {
                bl = CL_Initializer.bgMask.nextVoxel()[0] == 0.0;
            }
            catch (DataSourceException dataSourceException) {
                throw new LoggedException("Error reading background mask." + dataSourceException);
            }
        }
        return bl;
    }
}

