/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.PD_OrientationViewer;
import apps.ZoomPanel;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class NavPanel
extends JPanel {
    private PD_OrientationViewer container;
    private JButton axialButton;
    private JButton coronalButton;
    private JButton sagittalButton;
    private JButton saveButton;
    private JTextArea textPane;
    private JSlider zoomSlider;
    private DecimalFormat df = new DecimalFormat("0.0");
    private ZoomPanel zoomPanel;
    private JPanel rightPanel;

    public NavPanel(PD_OrientationViewer pD_OrientationViewer) {
        this.container = pD_OrientationViewer;
        this.setLayout(new GridLayout(1, 3));
        this.initComponents();
    }

    public int[] getZoomedRegion() {
        return this.zoomPanel.getZoomedRegion();
    }

    public void resetZoomPosition() {
        this.zoomPanel.resetZoomPosition();
    }

    public void setText(String string) {
        this.textPane.setText(string);
    }

    public void setSlice() {
        this.zoomPanel.setSlice();
    }

    private void initComponents() {
        int n;
        this.setLayout(new BoxLayout(this, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.axialButton = new JButton("AXIAL");
        this.axialButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavPanel.this.container.setSliceOrientation(100);
            }
        });
        jPanel2.add(this.axialButton);
        this.coronalButton = new JButton("CORONAL");
        this.coronalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavPanel.this.container.setSliceOrientation(200);
            }
        });
        jPanel2.add(this.coronalButton);
        this.sagittalButton = new JButton("SAGITTAL");
        this.sagittalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavPanel.this.container.setSliceOrientation(300);
            }
        });
        jPanel2.add(this.sagittalButton);
        this.saveButton = new JButton("SAVE RGB");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavPanel.this.container.writeRGB();
            }
        });
        jPanel2.add(this.saveButton);
        this.textPane = new JTextArea();
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        JCheckBox jCheckBox = new JCheckBox("Show vectors", true);
        jCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ((NavPanel)NavPanel.this).container.showVectors = !((NavPanel)NavPanel.this).container.showVectors;
                NavPanel.this.container.repaint();
            }
        });
        jPanel3.add(jCheckBox);
        int n2 = Math.max(this.container.xSize, this.container.ySize);
        int n3 = n2 = Math.max(n2, this.container.zSize);
        if (n3 % 2 == 1) {
            --n3;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n = n3 - this.container.preferredZoomedExtent) < 0) {
            n = 0;
        }
        this.zoomSlider = new JSlider(0, 0, n3, n);
        this.zoomSlider.setMajorTickSpacing(2);
        this.zoomSlider.setMinorTickSpacing(2);
        this.zoomSlider.setSnapToTicks(true);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = NavPanel.this.zoomSlider.getMaximum() - NavPanel.this.zoomSlider.getValue() - NavPanel.this.zoomSlider.getValue() % 2;
                ((NavPanel)NavPanel.this).container.preferredZoomedExtent = n >= 2 ? n : 2;
                NavPanel.this.zoomPanel.recentreBox();
                NavPanel.this.container.setZoomedSlice();
                NavPanel.this.container.repaint();
            }
        });
        jPanel3.add(new JLabel("    Zoom"));
        jPanel3.add(this.zoomSlider);
        jPanel.add(jPanel3);
        jPanel.add(this.textPane);
        this.add(jPanel);
        this.zoomPanel = new ZoomPanel(this.container);
        this.add(this.zoomPanel);
        JPanel jPanel4 = this.createRightPanel();
        this.add(jPanel4);
    }

    protected JPanel createRightPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1));
        final JLabel jLabel = new JLabel(this.df.format(this.container.image.rgbGamma()) + " ");
        final JLabel jLabel2 = new JLabel(this.df.format(this.container.image.scalarGamma()) + " ");
        final JSlider jSlider = new JSlider(0, 0, 20, (int)(10.0 * this.container.image.scalarGamma()));
        jSlider.setMajorTickSpacing(1);
        jSlider.setMinorTickSpacing(1);
        jSlider.setSnapToTicks(true);
        jSlider.setPreferredSize(new Dimension(100, 20));
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ((NavPanel)NavPanel.this).container.image.setScalarGamma((double)jSlider.getValue() / 10.0);
                jLabel2.setText(NavPanel.this.df.format(((NavPanel)NavPanel.this).container.image.scalarGamma()));
                NavPanel.this.container.updateDisplay();
                NavPanel.this.container.repaint();
            }
        });
        final JSlider jSlider2 = new JSlider(0, 0, 20, (int)(10.0 * this.container.image.rgbGamma()));
        jSlider2.setMajorTickSpacing(1);
        jSlider2.setMinorTickSpacing(1);
        jSlider2.setSnapToTicks(true);
        jSlider2.setPreferredSize(new Dimension(100, 20));
        jSlider2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ((NavPanel)NavPanel.this).container.image.setRGB_Gamma((double)jSlider2.getValue() / 10.0);
                jLabel.setText(NavPanel.this.df.format(((NavPanel)NavPanel.this).container.image.rgbGamma()) + " ");
                JSlider jSlider = (JSlider)changeEvent.getSource();
                NavPanel.this.container.updateDisplay();
                NavPanel.this.container.repaint();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel(" Grey gamma"));
        jPanel2.add(jSlider);
        jPanel2.add(jLabel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(new JLabel("  RGB gamma"));
        jPanel3.add(jSlider2);
        jPanel3.add(jLabel);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }
}

