/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.DataSource;
import data.OutputManager;
import imaging.ImageHeader;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import misc.LoggedException;
import numerics.Point3D;
import numerics.RealMatrix;
import tools.CL_Initializer;
import tractography.ConnectionProbabilityImage;
import tractography.ConnectivitySegmentedImage;
import tractography.RegionOfInterest;
import tractography.StreamlineROI_Filter;
import tractography.TargetCP_Image;
import tractography.Tract;
import tractography.TractCollection;
import tractography.TractSource;
import tractography.VoxelROI;

public class ProcessStreamlines
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.ProcessStreamlines");
    private static int MAX_PDS = 1000;
    private boolean outputCP;
    private boolean outputCBS;
    private boolean outputACM;
    private boolean normalizeCP;
    private int xDataDim;
    private int yDataDim;
    private int zDataDim;
    private double xVoxelDim;
    private double yVoxelDim;
    private double zVoxelDim;
    private String seedFile;
    private String targetFile;
    private String waypointFile;
    private String exclusionFile;
    private String endFile;
    private RealMatrix voxelToPhysical;
    private boolean countFirstEntry;
    private boolean discardOnExclusionEntry;
    private boolean truncateLoops;
    private boolean discardLoops;
    private RegionOfInterest[] allROIs;
    private int regionIndex;
    private int minTractPoints;
    private int maxTractPoints;
    private double minTractLength;
    private double maxTractLength;
    private String outputRoot;
    private double resampleStepSize;
    private boolean gzip;
    private int iterations;
    private boolean silent;

    public ProcessStreamlines(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.outputCP = false;
        this.outputCBS = false;
        this.outputACM = false;
        this.normalizeCP = false;
        this.xDataDim = 0;
        this.yDataDim = 0;
        this.zDataDim = 0;
        this.xVoxelDim = 0.0;
        this.yVoxelDim = 0.0;
        this.zVoxelDim = 0.0;
        this.seedFile = null;
        this.targetFile = null;
        this.waypointFile = null;
        this.exclusionFile = null;
        this.endFile = null;
        this.voxelToPhysical = null;
        this.countFirstEntry = true;
        this.discardOnExclusionEntry = true;
        this.truncateLoops = false;
        this.discardLoops = false;
        this.allROIs = null;
        this.regionIndex = -1;
        this.minTractPoints = 0;
        this.maxTractPoints = 0;
        this.minTractLength = 0.0;
        this.maxTractLength = 0.0;
        this.outputRoot = null;
        this.resampleStepSize = 0.0;
        this.iterations = 0;
        this.silent = false;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputModel = "raw";
        CL_Initializer.numPDsIO = 1;
        OutputManager.outputDataType = "float";
        CL_Initializer.CL_init(stringArray);
        this.gzip = OutputManager.gzipOut;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-resamplestepsize")) {
                this.resampleStepSize = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-noresample")) {
                this.resampleStepSize = -1.0;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-seedfile")) {
                this.seedFile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-regionindex")) {
                this.regionIndex = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-waypointfile")) {
                this.waypointFile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-exclusionfile")) {
                this.exclusionFile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-targetfile")) {
                this.targetFile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-endpointfile")) {
                this.endFile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-mintractpoints")) {
                this.minTractPoints = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-mintractlength")) {
                this.minTractLength = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-maxtractpoints")) {
                this.maxTractPoints = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-maxtractlength")) {
                this.maxTractLength = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-truncateinexclusion")) {
                this.discardOnExclusionEntry = false;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-truncateloops")) {
                this.truncateLoops = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-discardloops")) {
                this.discardLoops = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-allowmultitargets")) {
                this.countFirstEntry = false;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-outputtracts")) {
                this.outputCP = false;
                CL_Initializer.markAsParsed(i, 1);
                continue;
            }
            if (stringArray[i].equals("-outputcp")) {
                this.outputCP = true;
                this.normalizeCP = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-outputcbs")) {
                this.outputCBS = true;
                this.outputCP = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-outputsc")) {
                this.outputCP = true;
                this.normalizeCP = false;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-outputacm")) {
                this.outputCP = true;
                this.outputACM = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-iterations")) {
                this.iterations = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-outputroot")) {
                this.outputRoot = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (!stringArray[i].equals("-silent")) continue;
            this.silent = true;
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
    }

    @Override
    public void execute(OutputManager outputManager) {
        if (this.truncateLoops && this.discardLoops) {
            logger.warning("Discard and truncate loops both selected. Program will truncate loops (run again with discard option to remove them if desired)");
            this.discardLoops = false;
        }
        if (this.iterations == 0) {
            this.iterations = this.outputCP ? 5000 : 1;
        }
        if (CL_Initializer.headerTemplateFile != null || CL_Initializer.dataDims[0] > 0) {
            CL_Initializer.initInputSpaceAndHeaderOptions();
        }
        if (this.seedFile != null) {
            if (CL_Initializer.headerTemplate == null) {
                logger.info("Determining input physical space from seed file");
                CL_Initializer.headerTemplateFile = this.seedFile;
                CL_Initializer.initInputSpaceAndHeaderOptions();
            } else if (!CL_Initializer.headerTemplate.sameSpace(this.seedFile)) {
                throw new LoggedException(" Inconsistent image space : " + this.seedFile);
            }
            this.allROIs = new VoxelROI(this.seedFile, CL_Initializer.headerTemplate).getAllRegions();
            if (this.outputRoot == null) {
                if (OutputManager.outputFile != null) {
                    logger.info("Have seed file but no output root, output will be to output file " + OutputManager.outputFile);
                } else {
                    logger.info("Have seed file but no output root, output will be to stdout");
                }
            }
        } else {
            if (this.outputCP && !this.outputACM) {
                throw new LoggedException("Seed points must be specified for connection probability images");
            }
            if (!this.outputCP && this.outputRoot != null) {
                throw new LoggedException("Without seed ROI information, output is to a single stream (default stdout). Specify a file with -outputfile");
            }
        }
        if (this.outputRoot == null) {
            outputManager = new OutputManager();
        }
        int[][][] nArray = null;
        if (this.waypointFile != null) {
            if (CL_Initializer.headerTemplate == null) {
                logger.info("Determining input physical space from waypoint file");
                CL_Initializer.headerTemplateFile = this.waypointFile;
                CL_Initializer.initInputSpaceAndHeaderOptions();
            } else if (!CL_Initializer.headerTemplate.sameSpace(this.waypointFile)) {
                throw new LoggedException(" Inconsistent image space : " + this.waypointFile);
            }
            nArray = ProcessStreamlines.readIntVolume(this.waypointFile);
        }
        int[][][] nArray2 = null;
        if (this.exclusionFile != null) {
            if (CL_Initializer.headerTemplate == null) {
                logger.info("Determining input physical space from exclusion file");
                CL_Initializer.headerTemplateFile = this.exclusionFile;
                CL_Initializer.initInputSpaceAndHeaderOptions();
            } else if (!CL_Initializer.headerTemplate.sameSpace(this.exclusionFile)) {
                throw new LoggedException(" Inconsistent image space : " + this.exclusionFile);
            }
            nArray2 = ProcessStreamlines.readIntVolume(this.exclusionFile);
        }
        int[][][] nArray3 = null;
        if (this.targetFile != null) {
            if (CL_Initializer.headerTemplate == null) {
                logger.info("Determining input physical space from target file");
                CL_Initializer.headerTemplateFile = this.targetFile;
                CL_Initializer.initInputSpaceAndHeaderOptions();
            } else if (!CL_Initializer.headerTemplate.sameSpace(this.targetFile)) {
                throw new LoggedException(" Inconsistent image space : " + this.targetFile);
            }
            nArray3 = ProcessStreamlines.readIntVolume(this.targetFile);
        }
        int[][][] nArray4 = null;
        if (this.endFile != null) {
            if (CL_Initializer.headerTemplate == null) {
                logger.info("Determining input physical space from endpoint file");
                CL_Initializer.headerTemplateFile = this.endFile;
                CL_Initializer.initInputSpaceAndHeaderOptions();
            } else if (!CL_Initializer.headerTemplate.sameSpace(this.endFile)) {
                throw new LoggedException(" Inconsistent image space : " + this.endFile);
            }
            nArray4 = ProcessStreamlines.readIntVolume(this.endFile);
        }
        if (CL_Initializer.headerTemplate == null) {
            throw new LoggedException("Definition of physical space required, use -header <image> with any image in the correct space");
        }
        this.voxelToPhysical = CL_Initializer.headerTemplate.getVoxelToPhysicalTransform();
        this.xDataDim = CL_Initializer.dataDims[0];
        this.yDataDim = CL_Initializer.dataDims[1];
        this.zDataDim = CL_Initializer.dataDims[2];
        this.xVoxelDim = CL_Initializer.voxelDims[0];
        this.yVoxelDim = CL_Initializer.voxelDims[1];
        this.zVoxelDim = CL_Initializer.voxelDims[2];
        TractSource tractSource = new TractSource(CL_Initializer.inputFile, CL_Initializer.headerTemplate);
        if (this.outputCBS && nArray3 == null) {
            throw new LoggedException("Cannot do connectivity segmentation without targets");
        }
        if ((double)this.xDataDim == 0.0 || (double)this.yDataDim == 0.0 || (double)this.zDataDim == 0.0 || this.xVoxelDim == 0.0 || this.yVoxelDim == 0.0 || this.zVoxelDim == 0.0) {
            throw new LoggedException("This program requires a definition of the image space");
        }
        StreamlineROI_Filter streamlineROI_Filter = new StreamlineROI_Filter(CL_Initializer.dataDims, CL_Initializer.voxelDims);
        if (this.waypointFile != null) {
            streamlineROI_Filter.setWaypoints(nArray);
            streamlineROI_Filter.setTruncateLoops(this.truncateLoops);
            streamlineROI_Filter.setDiscardLoops(this.discardLoops);
        }
        if (this.exclusionFile != null) {
            streamlineROI_Filter.setExclusionROIs(nArray2);
            streamlineROI_Filter.setDiscardOnExclusionEntry(this.discardOnExclusionEntry);
        }
        if (this.endFile != null) {
            streamlineROI_Filter.setEndZones(nArray4);
        }
        if (this.resampleStepSize > 0.0) {
            streamlineROI_Filter.setResampleStepSize(this.resampleStepSize);
        } else {
            streamlineROI_Filter.setResampleTracts(false);
        }
        if (this.minTractPoints > 0) {
            streamlineROI_Filter.setMinTractPoints(this.minTractPoints);
        }
        if (this.minTractLength > 0.0) {
            streamlineROI_Filter.setMinTractLength(this.minTractLength);
        }
        if (this.maxTractPoints > 0) {
            streamlineROI_Filter.setMaxTractPoints(this.maxTractPoints);
            streamlineROI_Filter.setResampleTracts(false);
            if (this.resampleStepSize > 0.0) {
                logger.info("Max tract points set, resampling disabled");
            }
        }
        if (this.maxTractLength > 0.0) {
            streamlineROI_Filter.setMaxTractLength(this.maxTractLength);
        }
        try {
            int n = 1;
            if (this.allROIs != null) {
                n = this.allROIs.length;
            }
            if (this.outputACM) {
                int n2 = 0;
                if (!this.silent) {
                    System.err.println();
                }
                if (nArray3 != null) {
                    Object object;
                    TargetCP_Image targetCP_Image = new TargetCP_Image(nArray3, this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
                    targetCP_Image.setCountFirstEntry(this.countFirstEntry);
                    while (tractSource.more()) {
                        if (!this.silent) {
                            System.err.print("\rProcessing streamline " + (n2 + 1));
                        }
                        object = new TractCollection(2, 100.0);
                        ((TractCollection)object).addTract(tractSource.nextTract());
                        object = streamlineROI_Filter.processTracts((TractCollection)object);
                        targetCP_Image.processTracts((TractCollection)object);
                        ++n2;
                    }
                    if (this.normalizeCP) {
                        object = targetCP_Image.getConnectionProbabilities();
                        CL_Initializer.headerTemplate.writeScalarImage((double[][][])object, this.outputRoot + "acm_target_cp");
                    } else {
                        object = targetCP_Image.getStreamlineCounts();
                        CL_Initializer.headerTemplate.writeScalarImage((double[][][])object, this.outputRoot + "acm_target_sc");
                    }
                } else {
                    Object object;
                    ConnectionProbabilityImage connectionProbabilityImage = new ConnectionProbabilityImage(this.xDataDim, this.yDataDim, this.zDataDim, this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
                    while (tractSource.more()) {
                        if (!this.silent) {
                            System.err.print("\rProcessing streamline " + (n2 + 1));
                        }
                        object = new TractCollection(2, 100.0);
                        ((TractCollection)object).addTract(tractSource.nextTract());
                        object = streamlineROI_Filter.processTracts((TractCollection)object);
                        connectionProbabilityImage.processTracts((TractCollection)object);
                        ++n2;
                    }
                    if (this.normalizeCP) {
                        object = connectionProbabilityImage.getConnectionProbabilities();
                        CL_Initializer.headerTemplate.writeScalarImage((double[][][])object, this.outputRoot + "acm_cp");
                    } else {
                        object = connectionProbabilityImage.getStreamlineCounts();
                        CL_Initializer.headerTemplate.writeScalarImage((double[][][])object, this.outputRoot + "acm_sc");
                    }
                }
                if (!this.silent) {
                    System.err.println();
                }
                logger.info("Processed " + n2 + " streamlines for anatomical connectivity map");
            } else if (!this.outputCP && this.outputRoot == null) {
                DataOutputStream dataOutputStream = outputManager.getOutputStream();
                int n3 = 0;
                if (!this.silent) {
                    System.err.println();
                }
                while (tractSource.more()) {
                    if (!this.silent) {
                        System.err.print("\rProcessing streamline " + (n3 + 1));
                    }
                    TractCollection tractCollection = new TractCollection(2, 100.0);
                    tractCollection.addTract(tractSource.nextTract());
                    tractCollection = streamlineROI_Filter.processTracts(tractCollection);
                    for (int i = 0; i < tractCollection.numberOfTracts(); ++i) {
                        Tract tract = tractCollection.getTract(i);
                        tract.transformToPhysicalSpace(this.voxelToPhysical, this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
                        tract.writeRaw(dataOutputStream);
                    }
                    ++n3;
                }
                dataOutputStream.close();
            } else {
                boolean bl = false;
                TractCollection tractCollection = new TractCollection(2, 100.0);
                tractCollection.addTract(tractSource.nextTract());
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Object object2;
                    Object object3;
                    RegionOfInterest regionOfInterest = this.allROIs[i];
                    int n4 = regionOfInterest.getSeedPoints().length;
                    int n5 = regionOfInterest.getRegionLabel();
                    if (this.regionIndex > -1 && n5 != this.regionIndex) continue;
                    if (!this.silent) {
                        System.err.println("\nProcessing ROI " + (i + 1) + " of " + n);
                    }
                    if (this.outputCBS) {
                        int n6;
                        object3 = new ConnectivitySegmentedImage[MAX_PDS];
                        for (n6 = 0; n6 < n4; ++n6) {
                            if (!this.silent) {
                                System.err.print("\rProcessing seed " + (n6 + 1) + " of " + n4);
                            }
                            int n7 = 0;
                            object2 = tractCollection.getTract(0).getSeedPoint();
                            object = tractCollection.getTract(0).getSeedPoint();
                            while (tractCollection != null && ((Point3D)object2).equals(object)) {
                                if (object3[n7] == null) {
                                    object3[n7] = new ConnectivitySegmentedImage(regionOfInterest, nArray3, this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
                                    object3[n7].setCountFirstEntry(this.countFirstEntry);
                                }
                                object3[n7].processTracts(n6, streamlineROI_Filter.processTracts(tractCollection));
                                for (int j = 1; j < this.iterations; ++j) {
                                    TractCollection tractCollection2 = streamlineROI_Filter.processTract(tractSource.nextTract());
                                    object3[n7].processTracts(n6, tractCollection2);
                                }
                                if (tractSource.more()) {
                                    ++n7;
                                    tractCollection = new TractCollection(2, 100.0);
                                    tractCollection.addTract(tractSource.nextTract());
                                    object = tractCollection.getTract(0).getSeedPoint();
                                    continue;
                                }
                                tractCollection = null;
                                object2 = null;
                                object = null;
                                if (n6 >= n4 - 1) continue;
                                throw new LoggedException("No more tracts in input after processing seed " + (n6 + 1) + " of " + n4);
                            }
                        }
                        for (n6 = 0; n6 < MAX_PDS; ++n6) {
                            if (object3[n6] == null) continue;
                            double[][][] dArray = object3[n6].getSegmentedSeeds();
                            object2 = null;
                            CL_Initializer.headerTemplate.writeScalarImage(dArray, this.outputRoot + "labels_" + n5 + "_" + (n6 + 1));
                            if (this.normalizeCP) {
                                object2 = object3[n6].getMaxTargetCP();
                                CL_Initializer.headerTemplate.writeScalarImage((double[][][])object2, this.outputRoot + "labelcp_" + n5 + "_" + (n6 + 1));
                                continue;
                            }
                            object2 = object3[n6].getMaxTargetSC();
                            CL_Initializer.headerTemplate.writeScalarImage((double[][][])object2, this.outputRoot + "labelsc_" + n5 + "_" + (n6 + 1));
                        }
                        continue;
                    }
                    if (this.outputCP && nArray3 != null) {
                        for (int j = 0; j < n4; ++j) {
                            if (!this.silent) {
                                System.err.print("\rProcessing seed " + (j + 1) + " of " + n4);
                            }
                            int n8 = 0;
                            Point3D point3D = tractCollection.getTract(0).getSeedPoint();
                            object2 = tractCollection.getTract(0).getSeedPoint();
                            while (tractCollection != null && point3D.equals(object2)) {
                                double[][][] dArray;
                                object = new TargetCP_Image(nArray3, this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
                                ((TargetCP_Image)object).setCountFirstEntry(this.countFirstEntry);
                                ((TargetCP_Image)object).processTracts(streamlineROI_Filter.processTracts(tractCollection));
                                for (int k = 1; k < this.iterations; ++k) {
                                    TractCollection tractCollection3 = streamlineROI_Filter.processTract(tractSource.nextTract());
                                    ((TargetCP_Image)object).processTracts(tractCollection3);
                                }
                                if (this.normalizeCP) {
                                    dArray = ((TargetCP_Image)object).getConnectionProbabilities();
                                    CL_Initializer.headerTemplate.writeScalarImage(dArray, this.outputRoot + n5 + "_" + (j + 1) + "_" + (n8 + 1));
                                } else {
                                    dArray = ((TargetCP_Image)object).getStreamlineCounts();
                                    CL_Initializer.headerTemplate.writeScalarImage(dArray, this.outputRoot + n5 + "_" + (j + 1) + "_" + (n8 + 1));
                                }
                                ++n8;
                                if (tractSource.more()) {
                                    tractCollection = new TractCollection(2, 100.0);
                                    tractCollection.addTract(tractSource.nextTract());
                                    object2 = tractCollection.getTract(0).getSeedPoint();
                                    continue;
                                }
                                tractCollection = null;
                                point3D = null;
                                object2 = null;
                                if (j >= n4 - 1) continue;
                                throw new LoggedException("No more tracts in input after processing seed " + (j + 1) + " of " + n4);
                            }
                        }
                        continue;
                    }
                    if (this.outputCP) {
                        for (int j = 0; j < n4; ++j) {
                            if (!this.silent) {
                                System.err.print("\rProcessing seed " + (j + 1) + " of " + n4);
                            }
                            int n9 = 0;
                            Point3D point3D = tractCollection.getTract(0).getSeedPoint();
                            object2 = tractCollection.getTract(0).getSeedPoint();
                            while (tractCollection != null && point3D.equals(object2)) {
                                double[][][] dArray;
                                object = new ConnectionProbabilityImage(this.xDataDim, this.yDataDim, this.zDataDim, this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
                                ((ConnectionProbabilityImage)object).processTracts(streamlineROI_Filter.processTracts(tractCollection));
                                for (int k = 1; k < this.iterations; ++k) {
                                    TractCollection tractCollection4 = streamlineROI_Filter.processTract(tractSource.nextTract());
                                    ((ConnectionProbabilityImage)object).processTracts(tractCollection4);
                                }
                                if (this.normalizeCP) {
                                    dArray = ((ConnectionProbabilityImage)object).getConnectionProbabilities();
                                    CL_Initializer.headerTemplate.writeScalarImage(dArray, this.outputRoot + n5 + "_" + (j + 1) + "_" + (n9 + 1));
                                } else {
                                    dArray = ((ConnectionProbabilityImage)object).getStreamlineCounts();
                                    CL_Initializer.headerTemplate.writeScalarImage(dArray, this.outputRoot + n5 + "_" + (j + 1) + "_" + (n9 + 1));
                                }
                                if (tractSource.more()) {
                                    tractCollection = new TractCollection(2, 100.0);
                                    tractCollection.addTract(tractSource.nextTract());
                                    object2 = tractCollection.getTract(0).getSeedPoint();
                                } else {
                                    tractCollection = null;
                                    point3D = null;
                                    object2 = null;
                                    if (j < n4 - 1) {
                                        throw new LoggedException("No more tracts in input after processing seed " + (j + 1) + " of " + n4);
                                    }
                                }
                                ++n9;
                            }
                        }
                        continue;
                    }
                    object3 = null;
                    DataOutputStream dataOutputStream = null;
                    if (this.gzip) {
                        object3 = new FileOutputStream(this.outputRoot + n5 + ".Bfloat.gz");
                        dataOutputStream = new DataOutputStream(new GZIPOutputStream((OutputStream)object3, 0x1000000));
                    } else {
                        object3 = new FileOutputStream(this.outputRoot + n5 + ".Bfloat");
                        dataOutputStream = new DataOutputStream(new BufferedOutputStream((OutputStream)object3, 0x1000000));
                    }
                    if (!this.silent) {
                        System.err.println();
                    }
                    for (int j = 0; j < n4; ++j) {
                        if (!this.silent) {
                            System.err.print("\rProcessing seed " + (j + 1) + " of " + n4);
                        }
                        object2 = tractCollection.getTract(0).getSeedPoint();
                        object = tractCollection.getTract(0).getSeedPoint();
                        while (tractCollection != null && ((Point3D)object2).equals(object)) {
                            TractCollection tractCollection5 = streamlineROI_Filter.processTracts(tractCollection);
                            for (int k = 0; k < tractCollection5.numberOfTracts(); ++k) {
                                Tract tract = tractCollection5.getTract(k);
                                tract.transformToPhysicalSpace(this.voxelToPhysical, this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
                                tract.writeRaw(dataOutputStream);
                            }
                            if (tractSource.more()) {
                                tractCollection = new TractCollection(2, 100.0);
                                tractCollection.addTract(tractSource.nextTract());
                                object = tractCollection.getTract(0).getSeedPoint();
                                continue;
                            }
                            tractCollection = null;
                            object2 = null;
                            object = null;
                            if (j >= n4 - 1) continue;
                            throw new LoggedException("No more tracts in input after processing seed " + (j + 1) + " of " + n4);
                        }
                    }
                    dataOutputStream.close();
                }
            }
            if (tractSource.more()) {
                logger.warning("Tract processing finished but there are more Tracts in input. Check -seedfile and -iterations options.");
            }
            if (!this.silent) {
                System.err.println("\n");
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    protected static int[][][] readIntVolume(String string) {
        try {
            ImageHeader imageHeader = ImageHeader.readHeader(string);
            int n = imageHeader.xDataDim();
            int n2 = imageHeader.yDataDim();
            int n3 = imageHeader.zDataDim();
            int[][][] nArray = new int[n][n2][n3];
            DataSource dataSource = imageHeader.getImageDataSource();
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n; ++k) {
                        double d = dataSource.nextVoxel()[0];
                        if (!(d > 0.0)) continue;
                        if (d > 2.147483647E9) {
                            throw new LoggedException("Maximum value allowed for seeds / waypoints / targets is 2147483647");
                        }
                        nArray[k][j][i] = (int)Math.round(d);
                    }
                }
            }
            return nArray;
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }
}

